/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.RoomUtil;
import merlin.mv.ModelView;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSeg2D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.ShapeUtil;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.guiInputDlg;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.GenericActor;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.util.Pair;

public class DeveloperTool
extends CursorTool {
    private final MerlinData d_data;
    private final ModelScene d_scene;
    private final GenericActor d_actor;
    private static int s_lastWallCount = 1;
    private Plane3d d_isectPlane = null;
    private Point3d d_p1 = new Point3d();
    private Point3d d_p2 = new Point3d();
    private List<Point3d> d_isects = new ArrayList<Point3d>();
    private static Random s_random = new Random(0L);
    private static List<LineSeg2D> allSegs = null;
    private static long d_lastTime;

    public DeveloperTool(ModelView mv, MerlinData data) {
        super(mv, new Func());
        this.d_data = data;
        this.d_scene = mv.getMainScene();
        this.d_actor = new GenericActor();
        this.d_actor.setColor(Color.YELLOW);
        this.d_actor.setLineWidth(3.0);
        this.d_actor.setLineStipplePattern(1, (short)-256);
        this.d_actor.setPointSize(10.0);
    }

    @Override
    public void activate() {
        this.d_scene.addRenderableObjects(this.d_actor);
        super.activate();
        try {
            this.doSomeWork();
        }
        catch (Exception t) {
            t.printStackTrace();
        }
    }

    @Override
    public void deactivate() {
        this.d_scene.removeRenderableObjects(this.d_actor);
        super.deactivate();
    }

    private void doSomeWork() throws Exception {
        UIHook.run(this.getAttachedComponent(), "dev op", new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                DeveloperTool.this.addWalls(app, md);
            }
        }, 0);
    }

    private void addWalls(MerlinApp app, MerlinData md) {
        Integer numWalls = md.ui(() -> guiInputDlg.getInteger(app.getActiveFrame(), "Num Walls", "Enter number of walls", s_lastWallCount));
        if (numWalls == null) {
            return;
        }
        s_lastWallCount = numWalls;
        ArrayList boundaries = new ArrayList();
        Set rooms = md.selection.getDeepSelected(EgressRoom.class);
        for (EgressRoom room : rooms) {
            ArrayList<LineSeg> arrayList = new ArrayList<LineSeg>();
            Model model = room.getModel();
            for (Face face : model.getFaces()) {
                if (face.edgeLoops.size() != 1 || face.edgeLoops.get((int)0).edges.size() < 2) continue;
                for (FaceLoop loop : face.edgeLoops) {
                    ArrayList<EdgeUse> eus = new ArrayList<EdgeUse>(loop.edges);
                    eus.sort((eu1, eu2) -> {
                        boolean shared2;
                        boolean shared1 = DeveloperTool.isShared(md, room, eu1);
                        if (shared1 != (shared2 = DeveloperTool.isShared(md, room, eu2))) {
                            if (shared1) {
                                return -1;
                            }
                            if (shared2) {
                                return 1;
                            }
                        }
                        return Double.compare(eu2.edge.curve.length(), eu1.edge.curve.length());
                    });
                    EdgeUse eu12 = (EdgeUse)eus.get(0);
                    EdgeUse eu22 = (EdgeUse)eus.get(1);
                    for (int m = 0; m < numWalls; ++m) {
                        double t1 = ((double)m + 1.0) / ((double)numWalls.intValue() + 1.0);
                        double t2 = 1.0 - t1;
                        Point3d p1 = eu12.curve().get(t1);
                        Point3d p2 = eu22.curve().get(t2);
                        arrayList.add(new LineSeg(p1, Util3D.getMidPoint(p1, p2)));
                    }
                }
            }
            if (arrayList.isEmpty()) continue;
            boundaries.add(new Pair(room, arrayList));
        }
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Undo.begin("Split Rooms");
            for (Pair pair : boundaries) {
                EgressRoom geom = (EgressRoom)pair.v1;
                Undo.insertUndoEntry_restore(md, geom);
                List<EgressRoom> splitGeom = geom.addBoundary((Collection)pair.v2, MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_EDGE_ERROR));
                if (splitGeom.size() <= 1) continue;
                Composite parent = (Composite)md.hierarchy.getParent(geom);
                Undo.insertUndoEntry_add(md, geom);
                parent.remove(geom);
                Undo.insertUndoEntry_delete(md, parent, splitGeom);
                RoomUtil.assignSeparatedProps(splitGeom, md.roomNameGen);
                parent.addAll(splitGeom);
            }
            Undo.end(md);
        }
    }

    private static boolean isShared(MerlinData md, EgressRoom room, EdgeUse eu) {
        AABox bounds = new AABox();
        bounds.add(eu.edge.curve.get(0.0));
        bounds.add(eu.edge.curve.get(1.0));
        boolean[] result = new boolean[]{false};
        IResult<IDisplayableGeomSrc> fresult = (obj, ctmt) -> {
            if (obj == room || !(obj instanceof EgressRoom)) {
                return;
            }
            EgressRoom room2 = (EgressRoom)obj;
            for (Face face : room2.getModel().getFaces()) {
                for (FaceLoop loop : face.edgeLoops) {
                    for (EdgeUse eu2 : loop.edges) {
                        double[] overlap = Inter3D.lineSeglineSegOverlap(eu.curve().get(0.0), eu.curve().get(1.0), eu2.curve().get(0.0), eu2.curve().get(1.0), 1.0E-9, 1.0E-12);
                        if (overlap == null) continue;
                        result[0] = true;
                        return;
                    }
                }
            }
        };
        md.geomLocation.getLocator().find((ITest<AABox>)bounds, fresult, 1);
        return result[0];
    }

    private void makeObj(List<ImportedGeom> objs, List<Point3d> points) {
        if (points.size() > 1) {
            PolyLine line = new PolyLine(points.toArray(new Point3d[points.size()]));
            IPrimProps.Edge props = new IPrimProps.Edge(Color.RED, 2.0, IPrimProps.DEF_STIPPLE, 0);
            ImportedGeom ig = new ImportedGeom("Line " + (objs.size() + 1) + ": " + points.size(), new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(line), (IPrimProps)props));
            objs.add(ig);
        } else if (points.size() == 1) {
            System.err.println("Could not add point");
        }
    }

    private Point2d[] xformPoints(Matrix4d wlXform) {
        Point3d p1 = ShapeUtil.invXform(wlXform, this.d_p1);
        Point3d p2 = ShapeUtil.invXform(wlXform, this.d_p2);
        return new Point2d[]{new Point2d(p1.x, p1.y), new Point2d(p2.x, p2.y)};
    }

    private void updateActor() {
        this.d_actor.resetData();
        this.d_actor.addLine(this.d_p1, this.d_p2);
        for (Point3d isect : this.d_isects) {
            this.d_actor.addPoint(isect);
        }
        this.d_actor.finalizeData();
    }

    private static void beginSubTask(String message) {
        System.out.println(message);
        d_lastTime = System.nanoTime();
    }

    private static void endSubTask() {
        long endTime = System.nanoTime();
        System.out.println("took " + (double)(endTime - d_lastTime) * 1.0E-9);
    }

    protected static class Func
    extends AToolFunction<DeveloperTool> {
        protected Func() {
        }

        @Override
        public Cursor getCursor(DeveloperTool tool) {
            return null;
        }

        @Override
        public void mouseDragged(DeveloperTool tool, MouseEvent e) {
        }

        @Override
        public void mouseMoved(DeveloperTool tool, MouseEvent e) {
        }

        @Override
        public void mousePressed(DeveloperTool tool, MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            tool.d_isectPlane = null;
        }

        @Override
        public void mouseReleased(DeveloperTool tool, MouseEvent e) {
            if (e.getButton() == 1) {
                CursorTool.Ray pickRay = tool.getPickRay(tool.getP1().referenceSnap);
                Point3d isect = new Point3d();
                Inter3D.linePlaneIntersection(isect, pickRay.begin, pickRay.dir, new Plane3d(0.0, 0.0, 1.0, 0.0), 1.0E-9);
            }
        }
    }
}

