/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.behaviors;

import java.awt.FontMetrics;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import merlin.data.egress.scripting.IWaitUntilSrc;
import merlin.mv.gui.behaviors.WaitSrcEditorPnl;
import merlin.mv.gui.behaviors.guiWaitSrcUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.value.APopupValEditor;

public class WaitUntilSrcPnl
extends APopupValEditor<IWaitUntilSrc> {
    private static final long serialVersionUID = 1L;
    private final String d_name;
    private final JEditorPane d_editor;

    public WaitUntilSrcPnl(String name) {
        super(IWaitUntilSrc.class);
        this.d_name = name;
        this.d_editor = merlin.gui.guiUtil.getHtmlLabel("", e -> this.editValue());
        GridBagHelper gbh = new GridBagHelper(this, false);
        gbh.addRow(this.d_editor);
        gbh.finalizeRows();
        this.loadValue((IWaitUntilSrc)this.getValue());
    }

    @Override
    public boolean isLive() {
        return true;
    }

    @Override
    public String formatNonLiveValue() {
        return "";
    }

    @Override
    public void add(GridBagHelper gb) {
    }

    @Override
    public boolean editValue() {
        WaitSrcEditorPnl pnl = new WaitSrcEditorPnl(1);
        guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this), this.d_name, 9);
        this.applyButtonLabels(dlg);
        GridBagHelper gbh = new GridBagHelper(dlg.getDialogPane());
        gbh.addRow(pnl);
        gbh.finalizeRows();
        pnl.setValue((IWaitUntilSrc)this.getValue());
        if (dlg.doModal() == 1) {
            this.setValue((IWaitUntilSrc)pnl.getValue());
            return true;
        }
        return false;
    }

    @Override
    protected void loadValue(IWaitUntilSrc value) {
        FontMetrics fm = this.d_editor.getFontMetrics(this.d_editor.getFont());
        String str = WaitUntilSrcPnl.format(value, true);
        String shortened = guiUtil.shorten(str, 100, fm);
        String lblStr = "<html><a href=\"blank\">" + shortened + "</a></html>";
        this.d_editor.setText(lblStr);
        if (!str.equals(shortened)) {
            this.d_editor.setToolTipText(str);
        } else {
            this.d_editor.setToolTipText(null);
        }
        this.setModified(true);
        this.revalidate();
    }

    @Override
    protected IWaitUntilSrc saveValue(Mediator domain) {
        return (IWaitUntilSrc)this.getValue();
    }

    public static String format(IWaitUntilSrc src, boolean verbose) {
        return guiWaitSrcUtil.format(src, verbose);
    }
}

