/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.behaviors;

import merlin.Intl;
import merlin.MerlinApp;
import merlin.builders.GotoActionBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.GotoOccTarget;
import merlin.gui.APropEditPanel;
import merlin.gui.OccTargetsChooser;
import merlin.gui.guiUtil;
import merlin.mv.gui.behaviors.ANewBehaviorActionPnl;
import merlin.mv.gui.behaviors.ActionCreatePnl;
import merlin.mv.gui.behaviors.BehaviorPnl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.util.Pair;

public class NewGotoOccTargetPnl
extends ANewBehaviorActionPnl<GotoActionBuilder> {
    private static final long serialVersionUID = 1L;

    public NewGotoOccTargetPnl() {
        super(new Object[0]);
        MerlinData md = MerlinApp.getApp().getData();
        this.addSection(new BehaviorPnl());
        this.addSeparator();
        this.addSection(new LocsPanel(md));
        this.addSeparator();
        this.addSection(new ActionCreatePnl());
    }

    private static class LocsPanel
    extends APropEditPanel<GotoActionBuilder> {
        private static final long serialVersionUID = 1L;
        private final OccTargetsChooser d_occTargets;
        private final guiComboBox<GotoOccTarget.DistancePref> d_distPref;
        private final guiComboBox<GotoOccTarget.PriorityPref> d_priorityPref;

        public LocsPanel(MerlinData md) {
            super(GotoActionBuilder.DEST_CHANGED, GotoOccTarget.PROP_PRIORITY_PREF, GotoOccTarget.PROP_DIST_PREF);
            this.d_occTargets = new OccTargetsChooser(md);
            this.d_occTargets.addValueListener(e -> this.getUpdateToCommand().updateProp(this.d_occTargets, true));
            this.d_occTargets.setButtonLabel(1, ANewBehaviorActionPnl.CREATE);
            this.d_occTargets.setButtonLabel(8, ANewBehaviorActionPnl.GO_BACK);
            this.d_distPref = this.initComboBox(guiUtil.newCombo(choice -> new Pair<String, String>(choice.name, choice.desc), GotoOccTarget.DistancePref.values()));
            this.d_priorityPref = this.initComboBox(guiUtil.newCombo(pref -> new Pair<String, String>(pref.name, pref.desc), GotoOccTarget.PriorityPref.values()));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(Intl.intl("Occ Targets:"), this.d_occTargets);
            gb.addRow(guiUtil.lbl(Intl.intl("Priority Preference:"), "<html>" + Intl.intl("Defines the occupant's preference for a target based on the<br>target's priority. This interacts with the <b>Distance Preference</b><br>to define how the occupant chooses a target.")), this.d_priorityPref, 1.0);
            gb.addRow(guiUtil.lbl(Intl.intl("Distance Preference:"), "<html>" + Intl.intl("Defines the occupant's preference for a target based on the distance<br>to the target. This is secondary to the <b>Priority Preference</b>,<br>but also helps define how the occupant chooses a target.")), this.d_distPref, 1.0);
            this.d_occTargets.addPropertyChangeListener("edit", e -> {
                if (((Boolean)e.getNewValue()).booleanValue()) {
                    ((GotoActionBuilder)this.props()).commit(this);
                }
            });
        }

        @Override
        protected void updateFromProps(GotoActionBuilder props) {
            this.d_occTargets.setObjs(props.getOccTargets());
            this.d_distPref.setSelectedItem(props.get(GotoOccTarget.PROP_DIST_PREF));
            this.d_priorityPref.setSelectedItem(props.get(GotoOccTarget.PROP_PRIORITY_PREF));
        }

        @Override
        protected void updateToProps(GotoActionBuilder props) {
            props.setOccTargetsDest(this.d_occTargets.getObjs());
            props.set(GotoOccTarget.PROP_DIST_PREF, this.d_distPref.getSelectedItem());
            props.set(GotoOccTarget.PROP_PRIORITY_PREF, this.d_priorityPref.getSelectedItem());
        }
    }
}

