/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.behaviors;

import merlin.Intl;
import merlin.builders.CreateAttractorActionBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.CreateAttractor;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.gui.APropEditPanel;
import merlin.gui.SetChooser;
import merlin.gui.guiUtil;
import merlin.mv.gui.behaviors.ANewBehaviorActionPnl;
import merlin.mv.gui.behaviors.ActionCreatePnl;
import merlin.mv.gui.behaviors.BehaviorPnl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.util.Pair;

public class NewCreateAttractorPnl
extends ANewBehaviorActionPnl<CreateAttractorActionBuilder> {
    private static final long serialVersionUID = 1L;

    public NewCreateAttractorPnl(MerlinData md) {
        super(CreateAttractor.PROP_ATTRACTORS, CreateAttractor.PROP_LOCATION);
        this.addSection(new BehaviorPnl());
        this.addSeparator();
        this.addSection(new AttractorLocationPanel(md));
        this.addSeparator();
        this.addSection(new ActionCreatePnl());
    }

    private static class AttractorLocationPanel
    extends APropEditPanel<CreateAttractorActionBuilder> {
        private static final long serialVersionUID = 1L;
        private final SetChooser<Attractor> d_chooser;
        private final guiComboBox<CreateAttractor.LocationMode> d_locationCombo;

        public AttractorLocationPanel(MerlinData md) {
            super(CreateAttractor.PROP_ATTRACTORS);
            guiLabel attractorsLbl = guiUtil.lbl(CreateAttractor.PROP_ATTRACTORS.getNameWithColon(), CreateAttractor.PROP_ATTRACTORS.getDisplayDesc());
            this.d_chooser = SetChooser.fromRoot(md, Intl.intl("Triggers"), "", 0, md.attractorTemplates, Attractor.class, Attractor::isTemplate);
            this.d_chooser.addValueListener(e -> this.getUpdateToCommand().updateProp(this.d_chooser, true));
            guiLabel locationLbl = guiUtil.lbl(Intl.intl("Location:"), Intl.intl("The location where triggers will be placed."));
            this.d_locationCombo = this.initComboBox(guiUtil.newCombo(location -> new Pair<String, String>(location.name, location.desc), CreateAttractor.LocationMode.values()));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(attractorsLbl, this.d_chooser);
            gb.addRow(locationLbl, this.d_locationCombo);
        }

        @Override
        protected void updateFromProps(CreateAttractorActionBuilder props) {
            this.d_chooser.setObjs(props.getAttractors());
            this.d_locationCombo.setSelectedItem(props.getLocationMode());
        }

        @Override
        protected void updateToProps(CreateAttractorActionBuilder props) {
            props.setAttractors(this.d_chooser.getObjs());
            props.setLocationMode(this.d_locationCombo.getSelectedItem());
        }
    }
}

