/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.behaviors;

import common.data.ClientAwareness;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.builders.AssistedEvacActionBuilder;
import merlin.data.AssistedEvacTeam;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.AssistOccupants;
import merlin.gui.APropEditPanel;
import merlin.gui.IPropEditCommand;
import merlin.gui.MerlinComboBox;
import merlin.gui.MerlinUDF;
import merlin.gui.RoomChooser;
import merlin.gui.guiUtil;
import merlin.mv.gui.behaviors.ANewBehaviorActionPnl;
import merlin.mv.gui.behaviors.ActionCreatePnl;
import merlin.mv.gui.behaviors.BehaviorPnl;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Pair;

public class NewAssistOccupantsPnl
extends ANewBehaviorActionPnl<AssistedEvacActionBuilder> {
    private static final long serialVersionUID = 1L;

    public NewAssistOccupantsPnl() {
        super(new Object[0]);
        MerlinData md = MerlinApp.getApp().getData();
        this.addSection(new BehaviorPnl());
        this.addSeparator();
        this.addSection(new PropsPanel(md));
        this.addSeparator();
        this.addSection(new ActionCreatePnl());
    }

    private static class PropsPanel
    extends APropEditPanel<AssistedEvacActionBuilder> {
        private static final long serialVersionUID = 1L;
        private final guiComboBox<AssistedEvacTeam> d_teamChooser;
        private final guiComboBox<ClientAwareness> d_awarenessChooser;
        private final RoomChooser d_roomChooser;
        private final guiLabel d_roomLbl;
        private final MerlinUDF d_radiusFld;
        private final guiLabel d_radiusLbl;

        public PropsPanel(MerlinData md) {
            super(AssistedEvacActionBuilder.TYPE, AssistedEvacActionBuilder.TEAM, AssistedEvacActionBuilder.CLIENT_AWARENESS, AssistedEvacActionBuilder.ROOMS, AssistedEvacActionBuilder.AWARENESS_RADIUS);
            this.d_teamChooser = new MerlinComboBox(md, AssistedEvacTeam.class, (IMerlinObj[])new AssistedEvacTeam[0]);
            this.d_teamChooser.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.getUpdateToCommand().updateProp(this.d_teamChooser, true);
                }
            });
            this.d_awarenessChooser = guiUtil.newCombo(awareness -> awareness == null ? new Pair<String, Object>(Intl.intl("<mixed>"), null) : new Pair<String, String>(guiUtil.encodeToHtmlLabel(awareness.name), guiUtil.encodeToHtmlLabel(awareness.desc)), ClientAwareness.values());
            this.d_awarenessChooser.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.getUpdateToCommand().updateProp(this.d_awarenessChooser, true);
                }
            });
            this.d_roomLbl = guiUtil.lblProp(AssistOccupants.ROOMS.getDisplayName(), AssistOccupants.ROOMS.getDisplayDesc());
            this.d_roomChooser = new RoomChooser(md);
            this.d_roomChooser.addValueListener(e -> this.getUpdateToCommand().updateProp(this.d_roomChooser, true));
            this.d_radiusLbl = guiUtil.lblProp(AssistOccupants.AWARENESS_RADIUS.getDisplayName(), AssistOccupants.AWARENESS_RADIUS.getDisplayDesc());
            this.d_radiusFld = this.initValueField(new MerlinUDF(0, DoubleVR.above(0.0, false)), new IPropEditCommand[0]);
            this.d_radiusFld.addSpecialValue(AssistOccupants.AWARENESS_RADIUS_DISABLED_STR, new UnitDouble(Double.POSITIVE_INFINITY, SI.METER));
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(guiUtil.lblProp(AssistOccupants.TEAM.getDisplayName(), AssistOccupants.TEAM.getDisplayDesc()), this.d_teamChooser);
            gb.addRow(guiUtil.lblProp(AssistOccupants.CLIENT_AWARENESS.getDisplayName(), AssistOccupants.CLIENT_AWARENESS.getDisplayDesc()), this.d_awarenessChooser);
            gb.addRow(this.d_roomLbl, this.d_roomChooser);
            gb.addRow(this.d_radiusLbl, this.d_radiusFld);
            this.updateParamsVisible();
        }

        private void updateParamsVisible() {
            boolean roomsVisible = this.d_awarenessChooser.getSelectedItem() == ClientAwareness.ROOMS;
            this.d_roomChooser.setVisible(roomsVisible);
            this.d_roomLbl.setVisible(roomsVisible);
            boolean radiusVisible = this.d_awarenessChooser.getSelectedItem() == ClientAwareness.LINE_OF_SIGHT;
            this.d_radiusFld.setVisible(radiusVisible);
            this.d_radiusLbl.setVisible(radiusVisible);
        }

        @Override
        protected void updateFromProps(AssistedEvacActionBuilder props) {
            this.d_teamChooser.setSelectedItem(props.get(AssistedEvacActionBuilder.TEAM));
            this.d_awarenessChooser.setSelectedItem(props.get(AssistedEvacActionBuilder.CLIENT_AWARENESS));
            this.d_roomChooser.setRooms(props.get(AssistedEvacActionBuilder.ROOMS));
            this.d_radiusFld.setValue(props.get(AssistedEvacActionBuilder.AWARENESS_RADIUS));
            this.updateParamsVisible();
        }

        @Override
        protected void updateToProps(AssistedEvacActionBuilder props) {
            props.set(AssistedEvacActionBuilder.TEAM, this.d_teamChooser.getSelectedItem());
            props.set(AssistedEvacActionBuilder.CLIENT_AWARENESS, this.d_awarenessChooser.getSelectedItem());
            props.set(AssistedEvacActionBuilder.ROOMS, this.d_roomChooser.getRooms());
            props.set(AssistedEvacActionBuilder.AWARENESS_RADIUS, (UnitDouble)this.d_radiusFld.getValue());
        }
    }
}

