/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.awt.Color;
import java.util.List;
import javax.vecmath.Vector3d;
import merlin.builders.queues.QueuePathBuilder;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.queues.QueuePath;
import merlin.data.egress.scripting.queues.QueuePathNode;
import merlin.geom.Geometry;
import merlin.geom.IMerlinGeomSrc;
import merlin.mv.ModelView;
import merlin.mv.displays.APropsDisplay;
import thunderheadeng.scene3d.text.IDisplayableTextSrc;
import thunderheadeng.units.UnitPoint3D;

public class QueuePathBuilderDisplay
extends APropsDisplay<QueuePathBuilder> {
    public QueuePathBuilderDisplay(ModelView mv) {
        super(mv);
    }

    @Override
    protected Object[] getInterestingChanges() {
        return new Object[]{QueuePathBuilder.TEMP_LOC_CHANGED, QueuePathBuilder.NODE_COMMITTED, QueuePathBuilder.DIRECTION_CHANGED, QueuePathBuilder.VALIDITY};
    }

    @Override
    protected IMerlinGeomSrc constructGeom(QueuePathBuilder builder) {
        if (!builder.isValid()) {
            return null;
        }
        QueuePath path = new QueuePath("");
        List<IEgressOccupiable> drawRooms = builder.getDrawRooms();
        List<UnitPoint3D> drawPoints = builder.getDrawPoints();
        List<Vector3d> drawNorms = builder.getDrawFaceNormals();
        assert (drawRooms.size() == drawPoints.size());
        for (int i = 0; i < drawPoints.size(); ++i) {
            path.add(new QueuePathNode("", drawPoints.get(i).getPoint3dValue(Geometry.LENGTH_UNIT), drawRooms.get(i), drawNorms.get(i)));
        }
        return path;
    }

    @Override
    protected IDisplayableTextSrc constructText(QueuePathBuilder builder) {
        return builder.getLabelTextSrc(this.getModelView().getLengthUnits()[1], Color.GREEN);
    }
}

