/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import merlin.actions.InfernoGeomBuilder;
import merlin.actions.InfernoUtil;
import merlin.data.MerlinData;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.SimError;
import merlin.geom.IMerlinGeomSrc;
import merlin.io.inferno.InfernoGeom;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.DisplayGeomBuilder;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import thunderheadeng.scene3d.transformpreview.GeomDispTransformPreview;
import thunderheadeng.util.EmptyTaskProgress;
import thunderheadeng.util.ITaskProgress;
import thunderheadeng.util.theUtil;

public class NavMeshTriDisplay
extends GeomDisplay {
    private static final long serialVersionUID = 3833210511036298391L;

    public NavMeshTriDisplay(INativeDisplayProps dispProps) {
        super(dispProps, (IDisplayableGeomSrc)new DisplaySrc(), GeomDispTransformPreview.IDENTITY_ANIM);
    }

    @Override
    public DisplaySrc getSource() {
        return (DisplaySrc)super.getSource();
    }

    public void resetData() {
        this.getSource().geom = DisplayGeom.EMPTY;
        this.update();
    }

    public void regenerateDisplay(MerlinData data) {
        List<InfernoGeom> igeoms = InfernoUtil.collectInfernoGeom((ITaskProgress)EmptyTaskProgress.INSTANCE, (MerlinData)data).igeoms;
        ArrayList<SimError> errors = new ArrayList<SimError>();
        LinkedHashMap pointIxes = new LinkedHashMap();
        ArrayList resultLines = new ArrayList();
        ArrayList resultPoints = new ArrayList();
        Consumer<Point3d> addPoint = p -> {
            Integer next = pointIxes.size();
            Integer existing = pointIxes.putIfAbsent(p, next);
            if (existing == null) {
                existing = next;
                resultPoints.add(resultPoints.size());
            }
            resultLines.add(existing);
        };
        BiConsumer<Point3d, Point3d> addLine = (p1, p2) -> {
            addPoint.accept((Point3d)p1);
            addPoint.accept((Point3d)p2);
        };
        for (InfernoGeomBuilder igb : InfernoUtil.constructMeshes(EmptyTaskProgress.INSTANCE, data, igeoms, errors)) {
            List<Point3d> points = igb.getPoints();
            List<InfernoGeomBuilder.NavTriangle> tri = igb.getTriangles();
            for (InfernoGeomBuilder.NavTriangle nt : tri) {
                IEgressObj src;
                InfernoGeom igeom = nt.getBestSource();
                IEgressObj iEgressObj = igeom.source;
                if (!(iEgressObj instanceof IMerlinGeomSrc) || !(src = iEgressObj).isVisible()) continue;
                Point3d p12 = points.get(nt.i1);
                Point3d p22 = points.get(nt.i2);
                Point3d p3 = points.get(nt.i3);
                addLine.accept(p12, p22);
                addLine.accept(p22, p3);
                addLine.accept(p3, p12);
            }
        }
        for (SimError error : errors) {
            System.err.printf("[%s] %s%n", error.level.toString(), error.cause);
        }
        Point3d[] verts = theUtil.toArray(pointIxes.keySet(), Point3d.class);
        Mesh lineMesh = new Mesh(verts, theUtil.toIntArray(resultLines), 1);
        Mesh pointMesh = new Mesh(verts, theUtil.toIntArray(resultPoints), 0);
        DisplayGeomBuilder builder = new DisplayGeomBuilder();
        builder.add((IGeom)lineMesh, new IPrimProps.Edge(Color.BLACK, 1.0, IPrimProps.DEF_STIPPLE, 0), Elements.NONE);
        builder.add((IGeom)pointMesh, new IPrimProps.Vertex(Color.BLACK, 5.0), Elements.NONE);
        DisplayGeomBuilder.Rep rep = builder.finish();
        this.getSource().geom = rep.toDisplay();
        this.update();
    }

    private static class DisplaySrc
    implements IDisplayableGeomSrc {
        private DisplayGeom geom = DisplayGeom.EMPTY;

        private DisplaySrc() {
        }

        @Override
        public AABox getBounds() {
            return this.geom.node.getBoundingBox(new AABox());
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps props) {
            return this.geom;
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public void setVisible(boolean visible) {
        }
    }
}

