/*
 * Decompiled with CFR 0.152.
 */
package merlin.manip;

import java.util.Collection;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.actions.TransformAction;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.geom.Geometry;
import merlin.geom.IMerlinGeomSrc;
import merlin.manip.ATransformManip;
import merlin.mv.ModelView;
import merlin.mv.displays.GlobalDisplayMgr;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.AABox;
import thunderheadeng.scene3d.tools.transform.RotateTool;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class RotateManip
extends ATransformManip {
    private final MerlinData d_data;
    private Vector3d d_axis = null;
    private UnitPoint3D d_base = null;
    private UnitDouble d_angle = null;

    public RotateManip(MerlinData md, ModelView mv, GlobalDisplayMgr dispMgr, GlobalDisplayMgr xformDispMgr) {
        super(mv, dispMgr, xformDispMgr);
        this.d_data = md;
        this.d_angle = new UnitDouble(0.0, NonSI.DEGREE_ANGLE);
        this.d_base = new UnitPoint3D(0.0, 0.0, 0.0, SI.METER);
        this.d_axis = new Vector3d(0.0, 0.0, 1.0);
        this.updateXform();
    }

    @Override
    public void setSelection(Collection<? extends IMerlinObj> objs) {
        this.pause();
        super.setSelection(objs);
        if (!this.getCopyMode()) {
            this.setBaseToCenter();
        }
        this.resume();
    }

    public void setRotateAxis(Vector3d rotAxis) {
        if (!this.lock()) {
            return;
        }
        this.d_axis = new Vector3d(rotAxis);
        this.updateXform();
        this.release();
    }

    public Vector3d getAxis() {
        return this.d_axis;
    }

    public void setBaseToCenter() {
        AABox bounds = new AABox();
        for (IMerlinGeomSrc obj : TransformAction.getGeom(this.d_data, this.getSelection())) {
            bounds.add(obj.getBounds());
        }
        this.setBase(new UnitPoint3D(bounds.getCenter(), Geometry.LENGTH_UNIT));
    }

    public void setBase(UnitPoint3D base) {
        if (!this.lock()) {
            return;
        }
        this.d_base = base;
        this.updateXform();
        this.release();
    }

    public UnitPoint3D getBase() {
        return this.d_base;
    }

    public void setAngle(UnitDouble angle) {
        if (!this.lock()) {
            return;
        }
        this.d_angle = angle;
        this.updateXform();
        this.release();
    }

    public UnitDouble getAngle() {
        return this.d_angle;
    }

    @Override
    protected void reset() {
        this.d_angle = new UnitDouble(0.0, NonSI.DEGREE_ANGLE);
    }

    @Override
    protected String getActionName() {
        return Intl.intl("Rotate");
    }

    private void updateXform() {
        this.modify(RotateTool.generateTransforms(() -> this.getDOF(), this.d_base.getPoint3dValue(Geometry.LENGTH_UNIT), this.d_axis, this.d_angle.getValue(Geometry.ANGLE_UNIT)));
    }
}

