/*
 * Decompiled with CFR 0.152.
 */
package merlin.legacy.valpha;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.IMerlinObj;
import merlin.data.INameGenerator;
import merlin.data.ImportedGeom;
import merlin.data.MerlinSelectionModel;
import merlin.data.SimParams;
import merlin.data.egress.Floor;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.egress.agents.IOccNameGen;
import merlin.data.egress.geom.EgressStair;
import merlin.data.egress.geom.IEgressComp;
import merlin.geom.Geometry;
import merlin.legacy.ILegacyMerlinObjStub;
import thunderheadeng.gui.Mediator;
import thunderheadeng.units.UnitDouble;

public class MerlinData
extends Mediator
implements Serializable,
ILegacyMerlinObjStub {
    public static final long serialVersionUID = 1L;
    public Composite<ImportedGeom> sceneGeom;
    public Composite<IEgressComp> navMesh;
    public EgressAgentComp agents;
    public INameGenerator roomNameGen;
    public INameGenerator doorNameGen;
    public IOccNameGen occNameGen;
    public MerlinSelectionModel selection;
    public SimParams simParams;

    @Override
    public Object clone() {
        assert (false);
        return null;
    }

    @Override
    public boolean changedEvt(Object ... changes) {
        return false;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public Collection<? extends IMerlinObj> getChildren() {
        return null;
    }

    @Override
    public void setDomain(merlin.data.MerlinData domain, IMerlinObj parent) {
    }

    @Override
    public merlin.data.MerlinData getDomain() {
        return null;
    }

    @Override
    public void setDomain(merlin.data.MerlinData owner) {
    }

    private Floor getFloor(merlin.data.MerlinData md, double loc) {
        return this.getFloor(md, new UnitDouble(loc, Geometry.LENGTH_UNIT));
    }

    private Floor getFloor(merlin.data.MerlinData md, UnitDouble loc) {
        Floor floor = md.floors.getFloor(loc);
        if (floor == null) {
            floor = new Floor(loc);
            md.floors.add(floor);
        }
        return floor;
    }

    private GeomComposite<IMerlinObj> convertToGeomComp(Composite<? extends IMerlinObj> comp) {
        GeomComposite<IMerlinObj> newcomp = new GeomComposite<IMerlinObj>(comp.getName());
        for (IMerlinObj member : comp.getMembers()) {
            if (member instanceof Composite) {
                newcomp.add(this.convertToGeomComp((Composite)member));
                continue;
            }
            newcomp.add(member);
        }
        return newcomp;
    }

    private Object readResolve() throws ObjectStreamException {
        merlin.data.MerlinData md = new merlin.data.MerlinData(false);
        md.sceneGeom = this.convertToGeomComp(this.sceneGeom);
        md.selection = this.selection;
        md.simParams = this.simParams;
        md.occNameGen = this.occNameGen;
        md.roomNameGen = this.roomNameGen;
        md.agents = this.agents;
        for (IEgressComp comp : this.navMesh.getDeepMembers(IEgressComp.class)) {
            if (comp instanceof EgressStair) {
                double z = ((EgressStair)comp).getBottomDoor().getEdge().p1.z;
                this.getFloor(md, z).add(comp);
                continue;
            }
            double lowestZ = comp.getBounds().getMinZ();
            this.getFloor(md, lowestZ).add(comp);
        }
        return md;
    }
}

