/*
 * Decompiled with CFR 0.152.
 */
package merlin.legacy.v0172.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import merlin.data.SimParams;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.TypedProp;

public class SimParams
implements Serializable {
    static final long serialVersionUID = 8116442157363966490L;
    private boolean runTimeMaxFlag = true;
    private UnitDouble runTimeMax = new UnitDouble(3600.0, SI.SECOND);
    private boolean showVis = false;
    @Deprecated
    private boolean maxEdgeLengthFlag = false;
    private SimParams.NavMeshRefinement navmeshRefinement = SimParams.NavMeshRefinement.NONE;
    private UnitDouble maxEdgeLength = new UnitDouble(2.5, SI.METER);
    private double minAngle = 0.0;
    private UnitDouble maxTriangleArea = new UnitDouble(2.0, SI.METER.pow(2));
    private UnitDouble dtSim = new UnitDouble(0.025, SI.SECOND);
    private UnitDouble dtVis = new UnitDouble(0.25, SI.SECOND);
    private UnitDouble dtStatus = new UnitDouble(0.5, SI.SECOND);
    private UnitDouble dtCSV = new UnitDouble(1.0, SI.SECOND);
    private UnitDouble dtSnapshot = new UnitDouble(120.0, SI.SECOND);
    private UnitDouble dtSteerUpdate = new UnitDouble(0.1, SI.SECOND);
    private boolean handleCollisions = true;
    private boolean forceSeparation = false;
    private boolean reactiveSteering = true;
    private boolean useProfileFundamental = false;
    private boolean useAdvancedProfileSpeeds = false;
    private double minSFPEVelFrac = 0.15;
    @Deprecated
    private boolean inertia = true;
    private boolean useDoorQueues = false;
    @Deprecated
    private UnitDouble specificFlowrateMax = new UnitDouble(1.32, Unit.ONE.divide(SI.SECOND).divide(SI.METER));
    private UnitDouble specificFlowSteering = new UnitDouble(1.32, Unit.ONE.divide(SI.SECOND).divide(SI.METER));
    private boolean wallSlide = true;
    private boolean printPerformance = false;
    private UnitDouble densityMax = new UnitDouble(1.88, SIUS.unit(3));
    private UnitDouble doorBoundaryLayer = new UnitDouble(150.0, SI.MILLI(SI.METER));
    private double minFlowrateFactor = 0.1;
    private boolean doorFlowDensityFlag = true;
    @Deprecated
    private UnitDouble doorFlowDensityMin = new UnitDouble(1.9, SIUS.unit(3));
    @Deprecated
    private UnitDouble doorFlowDensityMax = new UnitDouble(3.0, SIUS.unit(3));
    @Deprecated
    private double elevatorSizeFactor = 0.6;
    @Deprecated
    private UnitDouble elevatorFillDensity = new UnitDouble(5.5, SIUS.unit(3));
    private UnitDouble maxTrimError = new UnitDouble(1.0, NonSI.INCH);
    private UnitDouble lowSpeedThreshold = new UnitDouble(0.25, SI.METER.divide(SI.SECOND));
    private UnitDouble lowSpeedAveragingTime = new UnitDouble(10.0, SI.SECOND);
    private boolean occCSVFileAsOne = true;
    private boolean writeJsonFiles = false;
    private boolean writeOccParamsFile = true;
    private boolean socialDistanceEnable = false;
    private UnitDouble socialDistance = new UnitDouble(2.0, SI.METER);
    private boolean measurementRegionSeekSpeed = true;
    private double edgeError = 0.1;
    private double faceError = 0.1;
    private boolean smvDataEnable = false;
    @Deprecated
    private boolean smvSmokeSlowEnable = false;
    private String smvDataFileName = null;
    private UnitDouble hypoxiaLimit = new UnitDouble(19.5, NonSI.PERCENT);
    private boolean enableVehicleLateralMovementVis = false;
    private UnitDouble attractorDefaultIdleTime = new UnitDouble(15.0, NonSI.MINUTE);
    private UnitDouble occTargetConflictResolveTime = new UnitDouble(5.0, SI.SECOND);
    private UnitDouble dynamicTargetSearchDt = new UnitDouble(0.25, SI.SECOND);

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.navmeshRefinement == null) {
            SimParams.NavMeshRefinement navMeshRefinement = this.maxEdgeLengthFlag ? SimParams.NavMeshRefinement.EDGE_LENGTH : (this.navmeshRefinement = this.maxTriangleArea != null ? SimParams.NavMeshRefinement.TRIANGLE_AREA : SimParams.NavMeshRefinement.NONE);
        }
        if (this.maxTriangleArea == null) {
            this.maxTriangleArea = new merlin.data.SimParams().get(merlin.data.SimParams.MAX_TRIANGLE_AREA);
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0004)) {
            this.dtSteerUpdate = new UnitDouble(0.0, SI.SECOND);
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0007)) {
            this.maxTrimError = new UnitDouble(1.0, NonSI.INCH);
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0021)) {
            this.elevatorSizeFactor = 0.6;
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0022)) {
            this.elevatorFillDensity = new UnitDouble(5.5, SIUS.unit(3));
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0105)) {
            this.minSFPEVelFrac = 0.15;
            this.useProfileFundamental = false;
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0120)) {
            this.minFlowrateFactor = 0.1;
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0135)) {
            this.writeOccParamsFile = true;
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0136)) {
            this.socialDistanceEnable = false;
            this.socialDistance = new UnitDouble(2.0, SI.METER);
            if (System.getProperty("social_distance") != null) {
                this.socialDistanceEnable = true;
                try {
                    double sd = Double.parseDouble(System.getProperty("social_distance"));
                    if (0.0 < sd && sd < 50.0) {
                        this.socialDistance = new UnitDouble(sd, SI.METER);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0137)) {
            boolean bl = this.forceSeparation = System.getProperty("ASeek.FORCE_SEPARATION") != null;
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0138)) {
            this.smvSmokeSlowEnable = false;
        }
        if (this.hypoxiaLimit == null) {
            this.hypoxiaLimit = new UnitDouble(19.5, NonSI.PERCENT);
        }
        if (this.faceError == 0.0) {
            this.faceError = 0.1;
        }
        if (this.edgeError == 0.0) {
            this.edgeError = 0.1;
        }
        if (this.attractorDefaultIdleTime == null) {
            this.attractorDefaultIdleTime = new merlin.data.SimParams().get(merlin.data.SimParams.ATTRACTOR_DEFAULT_IDLE_TIME);
        }
        if (this.occTargetConflictResolveTime == null) {
            this.occTargetConflictResolveTime = new merlin.data.SimParams().get(merlin.data.SimParams.OCC_TARGET_CONFLICT_RESOLVE_TIME);
        }
        if (this.dynamicTargetSearchDt == null) {
            this.dynamicTargetSearchDt = new merlin.data.SimParams().get(merlin.data.SimParams.DYNAMIC_TARGET_SEARCH_DT);
        }
        if (this.lowSpeedAveragingTime == null) {
            this.lowSpeedAveragingTime = new merlin.data.SimParams().get(merlin.data.SimParams.LOW_SPEED_AVERAGING_TIME);
        }
    }

    private <T> void setIfNotNull(merlin.data.SimParams target, TypedProp<T> prop, T prevVal) {
        if (prevVal == null) {
            return;
        }
        target.set(prop, prevVal);
    }

    public Object readResolve() {
        merlin.data.SimParams newSP = new merlin.data.SimParams();
        this.setIfNotNull(newSP, merlin.data.SimParams.RUNTIME_MAX_FLAG, this.runTimeMaxFlag);
        this.setIfNotNull(newSP, merlin.data.SimParams.RUNTIME_MAX, this.runTimeMax);
        this.setIfNotNull(newSP, merlin.data.SimParams.SHOW_RUNTIME_VIS, this.showVis);
        this.setIfNotNull(newSP, merlin.data.SimParams.MAX_EDGE_LENGTH, this.maxEdgeLength);
        this.setIfNotNull(newSP, merlin.data.SimParams.MIN_ANGLE, new UnitDouble(this.minAngle, NonSI.DEGREE_ANGLE));
        this.setIfNotNull(newSP, merlin.data.SimParams.MAX_TRIANGLE_AREA, this.maxTriangleArea);
        this.setIfNotNull(newSP, merlin.data.SimParams.DT_SIM, this.dtSim);
        this.setIfNotNull(newSP, merlin.data.SimParams.DT_VIS, this.dtVis);
        this.setIfNotNull(newSP, merlin.data.SimParams.DT_STATUS, this.dtStatus);
        this.setIfNotNull(newSP, merlin.data.SimParams.DT_CSV, this.dtCSV);
        this.setIfNotNull(newSP, merlin.data.SimParams.DT_SNAPSHOT, this.dtSnapshot);
        this.setIfNotNull(newSP, merlin.data.SimParams.DT_STEER_UPDATE, this.dtSteerUpdate);
        this.setIfNotNull(newSP, merlin.data.SimParams.HANDLE_COLLISIONS, this.handleCollisions);
        this.setIfNotNull(newSP, merlin.data.SimParams.FORCE_SEPARATION, this.forceSeparation);
        this.setIfNotNull(newSP, merlin.data.SimParams.REACTIVE_STEERING, this.reactiveSteering);
        this.setIfNotNull(newSP, merlin.data.SimParams.USE_PROFILE_FUNDAMENTAL, this.useProfileFundamental);
        this.setIfNotNull(newSP, merlin.data.SimParams.MIN_SFPE_VELOCITY_FRACTION, this.minSFPEVelFrac);
        this.setIfNotNull(newSP, merlin.data.SimParams.INERTIA, this.inertia);
        this.setIfNotNull(newSP, merlin.data.SimParams.USE_DOOR_QUEUES, this.useDoorQueues);
        this.setIfNotNull(newSP, merlin.data.SimParams.SPECIFIC_FLOW_STEERING, this.specificFlowSteering);
        this.setIfNotNull(newSP, merlin.data.SimParams.DENSITY_MAX, this.densityMax);
        this.setIfNotNull(newSP, merlin.data.SimParams.DOOR_BOUNDARY_LAYER, this.doorBoundaryLayer);
        this.setIfNotNull(newSP, merlin.data.SimParams.MIN_FLOWRATE_FACTOR, this.minFlowrateFactor);
        this.setIfNotNull(newSP, merlin.data.SimParams.DOOR_FLOW_DENSITY_FLAG, this.doorFlowDensityFlag);
        this.setIfNotNull(newSP, merlin.data.SimParams.ELEVATOR_SIZE_FACTOR, this.elevatorSizeFactor);
        this.setIfNotNull(newSP, merlin.data.SimParams.MAX_TRIM_ERROR, this.maxTrimError);
        this.setIfNotNull(newSP, merlin.data.SimParams.LOW_SPEED_THRESHOLD, this.lowSpeedThreshold);
        this.setIfNotNull(newSP, merlin.data.SimParams.LOW_SPEED_AVERAGING_TIME, this.lowSpeedAveragingTime);
        this.setIfNotNull(newSP, merlin.data.SimParams.OCC_CSV_FILE_MERGE, this.occCSVFileAsOne);
        this.setIfNotNull(newSP, merlin.data.SimParams.WRITE_JSON_FILES, this.writeJsonFiles);
        this.setIfNotNull(newSP, merlin.data.SimParams.WRITE_OCCUPANT_PARAMS_FILE, this.writeOccParamsFile);
        this.setIfNotNull(newSP, merlin.data.SimParams.WRITE_SOCIAL_DISTANCE, this.socialDistanceEnable);
        this.setIfNotNull(newSP, merlin.data.SimParams.SOCIAL_DISTANCE, this.socialDistance);
        this.setIfNotNull(newSP, merlin.data.SimParams.MEASUREMENT_REGION_SEEK_SPEED, this.measurementRegionSeekSpeed);
        this.setIfNotNull(newSP, merlin.data.SimParams.EDGE_ERROR, this.edgeError);
        this.setIfNotNull(newSP, merlin.data.SimParams.FACE_ERROR, this.faceError);
        this.setIfNotNull(newSP, merlin.data.SimParams.SMV_DATA_ENABLE, this.smvDataEnable);
        this.setIfNotNull(newSP, merlin.data.SimParams.SMV_SMOKE_SLOW_ENABLE, this.smvSmokeSlowEnable);
        this.setIfNotNull(newSP, merlin.data.SimParams.SMV_DATA_FILE_NAME, this.smvDataFileName);
        this.setIfNotNull(newSP, merlin.data.SimParams.HYPOXIA_LIMIT, this.hypoxiaLimit);
        this.setIfNotNull(newSP, merlin.data.SimParams.ENABLE_VEHICLE_LATERAL_MOVEMENT_VIS, this.enableVehicleLateralMovementVis);
        this.setIfNotNull(newSP, merlin.data.SimParams.ATTRACTOR_DEFAULT_IDLE_TIME, this.attractorDefaultIdleTime);
        this.setIfNotNull(newSP, merlin.data.SimParams.OCC_TARGET_CONFLICT_RESOLVE_TIME, this.occTargetConflictResolveTime);
        this.setIfNotNull(newSP, merlin.data.SimParams.DYNAMIC_TARGET_SEARCH_DT, this.dynamicTargetSearchDt);
        return newSP;
    }
}

