/*
 * Decompiled with CFR 0.152.
 */
package merlin.legacy.v0160.data.egress.elevators;

import common.data.IElevatorTimingModel;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;

public interface ITimingModel {
    public IElevatorTimingModel fromLegacy();

    public static class LegacyModel
    implements Serializable,
    ITimingModel {
        static final long serialVersionUID = 4L;
        public Map<Double, Double> timeMap;
        public double defaultVel;

        @Override
        public IElevatorTimingModel fromLegacy() {
            double defVel = this.defaultVel;
            if (defVel == 0.0) {
                double max = Collections.max(this.timeMap.keySet());
                defVel = max / this.timeMap.get(max);
            }
            return new IElevatorTimingModel.DistModel(this.timeMap, defVel);
        }
    }

    public static class VelModel
    extends AModel
    implements Serializable,
    ITimingModel {
        static final long serialVersionUID = 3L;
        public double vel;

        @Override
        public IElevatorTimingModel fromLegacy() {
            return new IElevatorTimingModel.VelModel(this.vel);
        }
    }

    public static class AccelModel
    extends AModel
    implements Serializable,
    ITimingModel {
        static final long serialVersionUID = 2L;
        public double accel;
        public double maxVel;

        @Override
        public IElevatorTimingModel fromLegacy() {
            return new IElevatorTimingModel.AccelModel(this.accel, this.maxVel);
        }
    }

    public static abstract class AModel
    implements Serializable,
    ITimingModel {
        static final long serialVersionUID = 1L;
        public double openDoorTime;
        public double closeDoorTime;
    }
}

