/*
 * Decompiled with CFR 0.152.
 */
package merlin.legacy.v0151.data.egress.geom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Vector3d;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.blockages.EgressBlockage;
import merlin.data.egress.geom.SpeedModifier;
import merlin.data.material.Material;
import merlin.legacy.ILegacyMerlinObjStub;
import merlin.legacy.v0151.data.egress.geom.EgressRoom;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.value.DiscreteVariant;
import thunderheadeng.util.value.IVariant;
import thunderheadeng.util.value.VariantUtil;

public class EgressBlockage
extends NamedMerlinObj
implements Serializable,
ILegacyMerlinObjStub {
    static final long serialVersionUID = 1L;
    public int d_faceId;
    @Deprecated
    private double d_speedFactor;
    @Deprecated
    private IVariant<Boolean> d_state;
    @Deprecated
    private IVariant<Double> d_speedFactors;
    public SpeedModifier d_speedModifier;
    public Material d_texture;

    public EgressBlockage(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_state != null && this.d_speedModifier == null) {
            this.d_speedModifier = EgressBlockage.convertLegacyFactor(this.d_speedFactor, this.d_state);
            this.d_state = null;
            this.d_speedFactor = Double.NaN;
        } else if (this.d_speedFactors != null && this.d_speedModifier == null) {
            List<DiscreteVariant.Entry<Double>> dFactors = VariantUtil.getDiscreteValues(this.d_speedFactors, true);
            ArrayList udFactors = new ArrayList(dFactors.size());
            for (DiscreteVariant.Entry<Double> dEntry : dFactors) {
                udFactors.add(new DiscreteVariant.Entry<UnitDouble>(dEntry.t, new UnitDouble((Double)dEntry.val, Unit.ONE)));
            }
            this.d_speedModifier = new SpeedModifier(SpeedModifier.Type.FACTOR, VariantUtil.newVariant(udFactors));
            this.d_speedFactors = null;
        }
    }

    public static SpeedModifier convertLegacyFactor(double speedFactor, IVariant<Boolean> state) {
        ArrayList speedFactors = new ArrayList();
        for (DiscreteVariant.Entry<Boolean> bEntry : VariantUtil.getDiscreteValues(state, true)) {
            boolean blocking = (Boolean)bEntry.val;
            speedFactors.add(new DiscreteVariant.Entry<UnitDouble>(bEntry.t, new UnitDouble(blocking ? speedFactor : 1.0, Unit.ONE)));
        }
        return speedFactors.isEmpty() ? merlin.data.egress.blockages.EgressBlockage.DEFAULT_SPEED_MOD : new SpeedModifier(SpeedModifier.Type.FACTOR, VariantUtil.newVariant(speedFactors));
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.readObject();
    }

    public merlin.data.egress.blockages.EgressBlockage fromLegacy(EgressRoom parentRoom) {
        merlin.data.egress.blockages.EgressBlockage result = new merlin.data.egress.blockages.EgressBlockage(this.getStoredName());
        result.set(merlin.data.egress.blockages.EgressBlockage.DISPLAY_TYPE, EgressBlockage.DisplayType.SIMPLE);
        result.set(MerlinData.MATERIAL, new IMaterial[]{this.d_texture});
        result.setSpeedModifier(this.d_speedModifier);
        result.setResultsId(this.getResultsId());
        Model model = parentRoom.d_geometry;
        Collection<Face> mfaces = model.getFaces(this.d_faceId);
        ArrayList<EdgeUse> bedges = new ArrayList<EdgeUse>();
        for (Face face : mfaces) {
            for (FaceLoop loop : face.edgeLoops) {
                for (EdgeUse eu : loop.edges) {
                    if (face.isInternalEdge(eu.edge)) continue;
                    bedges.add(eu);
                }
            }
        }
        double offsetDist = 0.25;
        TransformInfo tiUp = TransformUtil.translate(0.0, 0.0, 0.25).getInfo();
        ArrayList<ExtrudedPoly> geoms = new ArrayList<ExtrudedPoly>(mfaces.size());
        Vector3d extrudeDir = new Vector3d(0.0, 0.0, -0.5);
        for (Face face : mfaces) {
            IFace gface = face.toGeomFace();
            IFace tface = gface.transform(tiUp, 1);
            if (!(tface instanceof IPolygon)) continue;
            ExtrudedPoly epoly = new ExtrudedPoly((IPolygon)tface, extrudeDir);
            geoms.add(epoly);
        }
        result.setSearchGeom(GeomNodeUtil.newNode(GeomUtil.group(geoms)));
        return result;
    }
}

