/*
 * Decompiled with CFR 0.152.
 */
package merlin.legacy.v0009;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.vecmath.Point3d;
import merlin.data.egress.geom.EgressCorridor;
import merlin.geom.Geometry;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.legacy.ILegacyMerlinObjStub;
import merlin.legacy.v0009.AEgressComp;
import merlin.legacy.v0121.geom.StrutUtil;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.units.UnitDouble;

public class EgressStair
extends AEgressComp
implements Serializable,
ILegacyMerlinObjStub {
    static final long serialVersionUID = 1L;
    private LineSeg3D d_attachedEdge1;
    private LineSeg3D d_attachedEdge2;
    private double d_tloc;
    private UnitDouble d_width;
    private UnitDouble d_door1Width;
    private UnitDouble d_door2Width;
    private UnitDouble d_rise;
    private UnitDouble d_run;

    @Override
    public merlin.data.egress.geom.EgressStair fromLegacy() {
        merlin.data.egress.geom.EgressStair stair = new merlin.data.egress.geom.EgressStair(this.getStoredName(), null, null, EgressStair.convert(this.d_attachedEdge1), EgressStair.convert(this.d_attachedEdge2), this.d_rise, this.d_run, this.getBoundary());
        stair.getDoor1().setWidth(this.d_door1Width == null ? EgressCorridor.DOOR_STAIR_WIDTH : this.d_door1Width);
        stair.getDoor2().setWidth(this.d_door2Width == null ? EgressCorridor.DOOR_STAIR_WIDTH : this.d_door2Width);
        return super.fromLegacy(stair);
    }

    private static LineSeg convert(LineSeg3D ls) {
        return new LineSeg(ls.p1, ls.p2);
    }

    private Point3d[] getBoundary() {
        return EgressStair.getBoundary(EgressStair.convert(this.d_attachedEdge1), this.d_tloc, EgressStair.convert(this.d_attachedEdge2), this.d_width.getValue(Geometry.LENGTH_UNIT));
    }

    private static Point3d[] getBoundary(LineSeg edge1, double edgeT, LineSeg edge2, double width) {
        Point3d[] points = StrutUtil.calcStrutBoundary(edge1, edge2, edgeT, width);
        if (points == null || points.length != 4) {
            return null;
        }
        return points;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0005)) {
            this.d_attachedEdge1 = (LineSeg3D)this.d_attachedEdge1.reverse();
            this.d_attachedEdge2 = (LineSeg3D)this.d_attachedEdge2.reverse();
            this.d_tloc = 1.0 - this.d_tloc;
        }
    }
}

