/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.value;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellEditor;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.property.Function1dProp;
import merlin.data.value.IFunction1d;
import merlin.data.value.RandomizedImpulseFunction1d;
import merlin.gui.guiUtil;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Pair;

public class ScheduledFlowrateEditor
extends AValEditor<RandomizedImpulseFunction1d> {
    private static final long serialVersionUID = 1L;
    private final guiTable d_table;
    private final Semaphore d_valLock = new Semaphore(1);
    private final guiComboBox<RandomizedImpulseFunction1d.Distribution> d_dist;
    private boolean d_valueDirty = true;

    public ScheduledFlowrateEditor(final Function1dProp prop) {
        super(RandomizedImpulseFunction1d.class);
        String[] headers = new String[]{prop.x.desc, prop.x.deltaDesc, Intl.intl("Num. Occupants")};
        guiTableEditor ed = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, new Class[]{UnitDouble.class, UnitDouble.class, Integer.class}), 30);
        this.d_dist = guiUtil.newCombo(dist -> dist == null ? new Pair<String, String>(Intl.intl("<mixed>"), null) : guiUtil.encodeToHtmlLabel(dist.name, dist.occFlowrateDesc), RandomizedImpulseFunction1d.Distribution.values());
        this.d_table = ed.getTable();
        this.d_table.setNullValuesAllowed(true);
        this.d_table.getColumnModel().getColumn(0).setCellEditor(new guiTable.UnitDoubleEditor(SI.SECOND));
        this.d_table.getColumnModel().getColumn(1).setCellEditor(new guiTable.UnitDoubleEditor(SI.SECOND, UnitDoubleVR.gt(0.0, SI.SECOND), true));
        this.d_table.getColumnModel().getColumn(2).setCellEditor(guiTable.newNumberEditor(Integer.class, IntVR.ge(0), true));
        this.d_table.autoSizeColumns(700);
        for (int m = 0; m < 3; ++m) {
            this.d_table.getColumnModel().getColumn(m).setPreferredWidth(100);
        }
        this.d_table.setPreferredScrollableViewportSize(new Dimension(this.d_table.getPreferredSize().width, Math.max(300, this.d_table.getPreferredSize().height)));
        ArrayList<JButton> loadBtns = new ArrayList<JButton>(prop.predef.length);
        for (final Function1dProp.PredefFunction predefFunc : prop.predef) {
            JButton btn = new JButton(predefFunc.longDesc);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int sel = JOptionPane.showConfirmDialog(ScheduledFlowrateEditor.this, Intl.intl("The current values will be overwritten. Do you want to continue?"), Intl.intl("Reset Values?"), 0);
                    if (sel == 0) {
                        Component c;
                        IFunction1d func;
                        TableCellEditor ced = ScheduledFlowrateEditor.this.d_table.getCellEditor();
                        if (ced != null) {
                            ced.cancelCellEditing();
                        }
                        if ((func = predefFunc.getFunction.apply(c = evt.getSource() instanceof Component ? (Component)evt.getSource() : Application.getApp().getActiveFrame())) != null) {
                            ScheduledFlowrateEditor.this.setValue(func.toRandomizedImpulse(prop));
                        }
                    }
                }
            });
            loadBtns.add(btn);
        }
        guiLabel numOccsLabel = new guiLabel();
        Runnable updateNumOccs = () -> {
            if (!this.validateData(false, false)) {
                numOccsLabel.setText("<html>" + Intl.intl("Invalid interval table. Press <b>OK</b> to see the errors."));
                numOccsLabel.setForeground(Color.RED);
                return;
            }
            numOccsLabel.setForeground(null);
            RandomizedImpulseFunction1d f = this.saveValue(null);
            int maxCount = f.getMaxNumOccs(0L, this.getMaxX(prop));
            String formatStr = f.dist.exact ? "%d" : Intl.intl("\u2248%d");
            numOccsLabel.setText(String.format(formatStr, maxCount));
        };
        updateNumOccs.run();
        this.d_table.getModel().addTableModelListener(e -> {
            this.d_valueDirty = true;
            updateNumOccs.run();
        });
        this.d_dist.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.d_valueDirty = true;
                updateNumOccs.run();
            }
        });
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(guiUtil.lbl(Intl.intl("Timing Distribution:"), Intl.intl("Specifies the distribution of insertion timing intervals.")), this.d_dist, 0);
        gb.addTitle(Intl.intl("Insertion Intervals"));
        gb.addRow(ed, new double[]{1.0, 1.0}, new int[]{0, 1});
        guiPanel btnPnl = new guiPanel();
        GridBagHelper gb2 = new GridBagHelper(btnPnl);
        for (JButton btn : loadBtns) {
            gb2.addRow(btn, 1.0, 0);
        }
        gb2.finalizeRows();
        gb.addRow(btnPnl);
        guiPanel totOccsPnl = new guiPanel();
        gb2 = new GridBagHelper(totOccsPnl);
        gb2.addRow(prop.integration.desc, numOccsLabel, 0);
        gb2.finalizeRows();
        gb.addFilledRow(totOccsPnl);
    }

    @Override
    public boolean isLive() {
        return true;
    }

    @Override
    public String formatNonLiveValue() {
        return "";
    }

    private UnitDouble getMaxX(Function1dProp prop) {
        return prop.integration.getRange.apply(MerlinApp.getApp().getData());
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.addRow(this, 1.0);
    }

    @Override
    public RandomizedImpulseFunction1d getValue() {
        if (this.d_valueDirty && this.d_valLock.tryAcquire()) {
            this.updateValue();
            this.d_valueDirty = false;
            this.d_valLock.release();
        }
        return (RandomizedImpulseFunction1d)super.getValue();
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.d_dist.getSelectedItem() == null) {
            if (allowModify) {
                this.d_dist.requestFocusInWindow();
            }
            if (showWarn) {
                JOptionPane.showMessageDialog(guiUtil.getWindow(this), Intl.intl("A Timing Distribution must be specified."), Intl.intl("Choose a Timing Distribution"), 2);
            }
            return false;
        }
        List<Pair<Integer, RandomizedImpulseFunction1d.Interval>> intervals = this.getSortedIntervals();
        if (intervals.isEmpty()) {
            if (allowModify) {
                this.d_table.requestFocusInWindow();
            }
            if (showWarn) {
                JOptionPane.showMessageDialog(guiUtil.getWindow(this), Intl.intl("There must be at least one entry."), Intl.intl("Missing Entries"), 2);
            }
            return false;
        }
        RandomizedImpulseFunction1d f = this.saveValue(null);
        if (f.getNonZeroIntervals().isEmpty()) {
            if (allowModify) {
                this.d_table.requestFocusInWindow();
            }
            if (showWarn) {
                JOptionPane.showMessageDialog(guiUtil.getWindow(this), Intl.intl("There must be at least one positive flowrate interval."), Intl.intl("Validation Error"), 0);
            }
            return false;
        }
        for (int m = 0; m < intervals.size() - 1; ++m) {
            Pair<Integer, RandomizedImpulseFunction1d.Interval> i1 = intervals.get(m);
            Pair<Integer, RandomizedImpulseFunction1d.Interval> i2 = intervals.get(m + 1);
            if (!((RandomizedImpulseFunction1d.Interval)i1.v2).x.add(((RandomizedImpulseFunction1d.Interval)i1.v2).duration).gt(((RandomizedImpulseFunction1d.Interval)i2.v2).x, 1.0E-12)) continue;
            if (allowModify) {
                this.d_table.clearSelection();
                this.d_table.addRowSelectionInterval((Integer)i1.v1, (Integer)i1.v1);
                this.d_table.addRowSelectionInterval((Integer)i2.v1, (Integer)i2.v1);
                this.d_table.requestFocusInWindow();
            }
            if (showWarn) {
                JOptionPane.showMessageDialog(guiUtil.getWindow(this), String.format(Intl.intl("The interval on row %1$d overlaps the interval on row %2$d."), (Integer)i1.v1 + 1, (Integer)i2.v1 + 1), Intl.intl("Overlapping Intervals"), 2);
            }
            return false;
        }
        return true;
    }

    public List<Pair<Integer, RandomizedImpulseFunction1d.Interval>> getSortedIntervals() {
        List result = this.getIntervals().collect(Collectors.toCollection(() -> new ArrayList()));
        Collections.sort(result, (i1, i2) -> ((RandomizedImpulseFunction1d.Interval)i1.v2).x.compareTo(((RandomizedImpulseFunction1d.Interval)i2.v2).x));
        return result;
    }

    public Stream<Pair<Integer, RandomizedImpulseFunction1d.Interval>> getIntervals() {
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        int rows = model.getRowCount();
        return IntStream.range(0, rows).mapToObj(row -> {
            UnitDouble x = (UnitDouble)model.getValueAt(row, 0);
            UnitDouble duration = (UnitDouble)model.getValueAt(row, 1);
            Integer count = (Integer)model.getValueAt(row, 2);
            return x != null && duration != null && count != null ? new Pair<Integer, RandomizedImpulseFunction1d.Interval>(row, new RandomizedImpulseFunction1d.Interval(x, duration, new UnitDouble(count.intValue(), Unit.ONE).divide(duration))) : null;
        }).filter(ud -> ud != null);
    }

    @Override
    protected void loadValue(RandomizedImpulseFunction1d var) {
        if (!this.d_valLock.tryAcquire()) {
            return;
        }
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        this.d_table.clearRows();
        this.d_dist.setSelectedItem(null);
        if (var != null) {
            model.setNumRows(var.intervals.size());
            int row = 0;
            for (RandomizedImpulseFunction1d.Interval entry : var.intervals) {
                UnitDouble duration = entry.duration.isInfinite() ? new UnitDouble(3600.0, SI.SECOND) : entry.duration;
                int numOccs = (int)Math.round(duration.multiply(entry.rate).get(Unit.ONE));
                model.setValueAt(entry.x, row, 0);
                model.setValueAt(duration, row, 1);
                model.setValueAt(numOccs, row, 2);
                ++row;
            }
            this.d_dist.setSelectedItem((Object)var.dist);
        }
        super.setValue(var);
        this.d_valueDirty = false;
        this.setModified(false);
        this.d_valLock.release();
    }

    @Override
    protected RandomizedImpulseFunction1d saveValue(Mediator mediator) {
        List intervals = this.getSortedIntervals().stream().map(p -> (RandomizedImpulseFunction1d.Interval)p.v2).collect(Collectors.toCollection(() -> new ArrayList()));
        RandomizedImpulseFunction1d.Distribution dist = this.d_dist.getSelectedItem();
        return new RandomizedImpulseFunction1d(dist, intervals);
    }
}

