/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.stat;

import java.util.function.UnaryOperator;
import merlin.Intl;
import merlin.data.stat.CurveUtil;
import merlin.gui.guiUtil;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.UrnUtil;

public class guiCurveUtil {
    public static String format(IDistributedVal<UnitDouble> curve) {
        return guiCurveUtil.format(curve, -1);
    }

    public static String format(IDistributedVal<UnitDouble> curve, int unitType) {
        if (curve instanceof IUrn) {
            UrnUtil.UrnStats urnStats = CurveUtil.getUrnStats((IUrn)curve, unitType);
            return String.format("[%s, %s] ", guiUtil.format(urnStats.min, unitType), guiUtil.format(urnStats.max, unitType)) + Intl.intl("discrete");
        }
        if (curve != null) {
            int[] nArray;
            if (unitType != -1) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = unitType;
            } else {
                nArray = new int[]{};
            }
            int[] unitTypeHints = nArray;
            return curve.format(MerlinUtil.getDisplayUnitSupplier(unitTypeHints));
        }
        return "";
    }

    public static String format(IDistributedVal<UnitDouble> curve, UnaryOperator<Unit> getUnit) {
        if (curve instanceof IUrn) {
            UrnUtil.UrnStats urnStats = CurveUtil.getUrnStats((IUrn)curve, 11);
            return String.format("[%s, %s] ", guiUtil.format(urnStats.min, getUnit), guiUtil.format(urnStats.max, getUnit)) + Intl.intl("discrete");
        }
        if (curve != null) {
            return curve.format(getUnit);
        }
        return "";
    }
}

