/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.stat;

import java.util.function.Predicate;
import java.util.function.Supplier;
import merlin.Intl;
import merlin.gui.MerlinValueFields;
import merlin.unitsystem.SIUS;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.stat.LogNormCurve;

public class LogNormEditor
extends AValEditor<LogNormCurve> {
    private static final long serialVersionUID = 4544543790625726703L;
    private ValueField<UnitDouble> d_min;
    private ValueField<UnitDouble> d_max;
    private ValueField<UnitDouble> d_logMean;
    private ValueField<UnitDouble> d_logStDev;

    public LogNormEditor(int unitType) {
        this(unitType, UnitDoubleVR.above(0.0, SIUS.unit(unitType), true));
    }

    public LogNormEditor(int unitType, UnitDoubleVR range) {
        super(LogNormCurve.class);
        Supplier<ValueField> fieldFactory = () -> this.registerEd(MerlinValueFields.udFld(SIUS.newud(0.0, unitType), (Predicate<UnitDouble>)range, unitType));
        this.d_min = fieldFactory.get();
        this.d_max = fieldFactory.get();
        this.d_logMean = fieldFactory.get();
        this.d_logStDev = fieldFactory.get();
        guiLabel location = new guiLabel(Intl.intl("Location (\u03bc):"));
        location.setToolTipText("<html>" + Intl.intl("Location parameter (\u03bc) is the mean of the natural logarithm of the distribution.") + "<br>" + Intl.intl("To calculate location based on the mean and standard deviation of the distribution (X), use the following formula:") + "<br>\u03bc = ln(\u03bc<sub>x</sub><sup>2</sup> / \u221a(\u03bc<sub>x</sub><sup>2</sup> + \u03c3<sub>x</sub><sup>2</sup>))</html>");
        guiLabel scale = new guiLabel(Intl.intl("Scale (\u03c3):"));
        scale.setToolTipText("<html>" + Intl.intl("Scale parameter (\u03c3) is the standard deviation of the natural logarithm of the distribution - it must be positive or zero.") + "<br>" + Intl.intl("To calculate scale based on the mean and standard deviation of the distribution (X), use the following formula:") + "<br>\u03c3 = \u221a( ln(1 + \u03bc<sub>x</sub><sup>2</sup> / \u03c3<sub>x</sub><sup>2</sup>))</html>");
        GridBagHelper gb = new GridBagHelper(this, false);
        gb.addRow(Intl.intl("Min:"), this.d_min, Intl.intl("Max:"), this.d_max);
        gb.addRow(location, this.d_logMean, scale, this.d_logStDev);
        gb.finalizeRows();
    }

    @Override
    public boolean isLive() {
        return true;
    }

    @Override
    public String formatNonLiveValue() {
        return "";
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.add(this, 1.0);
    }

    @Override
    public void loadValue(LogNormCurve lnc) {
        this.d_min.setValue(lnc.getMin());
        this.d_max.setValue(lnc.getMax());
        this.d_logMean.setValue(lnc.getAvg());
        this.d_logStDev.setValue(lnc.getStdDev());
    }

    @Override
    public LogNormCurve saveValue(Mediator mediator) {
        return new LogNormCurve((UnitDouble)this.d_min.getValue(), (UnitDouble)this.d_max.getValue(), (UnitDouble)this.d_logMean.getValue(), (UnitDouble)this.d_logStDev.getValue());
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        UnitDouble max;
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        UnitDouble min = (UnitDouble)this.d_min.getValue();
        if (min.sub(max = (UnitDouble)this.d_max.getValue()).getValueNoUnit() > 0.0) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("Req: Min <= Max"));
            }
            return false;
        }
        UnitDouble stdDev = (UnitDouble)this.d_logStDev.getValue();
        if (stdDev.getValueNoUnit() < 0.0) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("Req: Location parameter >= 0"));
            }
            return false;
        }
        return true;
    }
}

