/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.scripting;

import javax.swing.Action;
import javax.swing.JFrame;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.NewObject;
import merlin.data.MerlinData;
import merlin.data.scripting.ScriptGroup;
import merlin.data.scripting.ScriptObj;
import merlin.gui.ManagerDlg;
import merlin.gui.NewActionListener;
import merlin.gui.NewDlg;
import merlin.gui.scripting.ScriptEditorPanel;
import merlin.unitsystem.UnitSystem;
import thunderheadeng.gui.IEditor;

public class ScriptDlg
extends ManagerDlg<ScriptObj, ManagerDlg.IManager<ScriptObj>> {
    private static final long serialVersionUID = 7239630731851277402L;
    private static final int s_newActionIx = 0;
    private static final int s_renameActionIx = 1;
    private static final int s_deleteActionIx = 2;
    private static final int s_overridesActionIx = 3;
    private final IEditor<ScriptObj> d_editor = new ScriptEditorPanel(this.getMgrOverrideCallback());
    private ManagerDlg.IManager<ScriptObj> d_mgr;

    public ScriptDlg(JFrame owner, UnitSystem uSys) {
        super(owner, Intl.intl("Edit Custom Scripts"), ScriptObj.class);
        String newMsg = Intl.intl("New Custom Script");
        this.d_actions = new Action[]{this.newAction(new NewActionListener<ScriptObj, NewDlg>(new NewObject<ScriptObj, NewDlg>(ScriptObj.class, md -> md.customScripts, md -> md.customScriptNameGen, NewDlg::new, (mgr, obj) -> {
            ScriptDlg dlg = new ScriptDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
            dlg.init(MerlinApp.getApp().getData(), (ManagerDlg.IManager<ScriptObj>)mgr, (ScriptObj)obj);
            dlg.doModal();
        }, newMsg, ScriptObj.PROP_NAME, ScriptGroup.class, md -> new ScriptObj(), (md, base) -> (ScriptObj)base.clone(), true))), new ManagerDlg.RenameAction(ScriptObj.PROP_NAME, newMsg, md -> md.customScripts), new ManagerDlg.DeleteAction(), this.d_overrideAction};
        this.updateActions();
    }

    @Override
    protected boolean validateEditor(IEditor<ScriptObj> editor, boolean showWarn, boolean allowModify) {
        boolean modified = this.d_editor.isModified();
        if (!super.validateEditor(editor, showWarn, allowModify)) {
            return false;
        }
        if (modified) {
            int ix = this.getList().getSelectedIx();
            ScriptObj prof = (ScriptObj)this.getList().getItem(ix);
            if (prof != null && !this.validateScript(prof, showWarn, allowModify)) {
                return false;
            }
        }
        return true;
    }

    protected boolean validateScript(ScriptObj prof, boolean showWarn, boolean allowModify) {
        return true;
    }

    @Override
    public void updateActions() {
        this.updateActionEnabled(0, this.shouldEnableNew());
        this.updateActionEnabled(1, this.shouldEnableRename());
        this.updateActionEnabled(2, this.shouldEnableDelete());
        this.updateActionEnabled(3, this.shouldEnableOverride());
    }

    public void init(MerlinData md, ManagerDlg.IManager<ScriptObj> mgr, ScriptObj init) {
        this.d_mgr = mgr;
        super.init(md, this.d_mgr, this.d_editor, this.d_actions);
        this.updateActions();
        if (init != null) {
            this.getList().select(init);
        }
    }
}

