/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.labels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.MerlinOpImpl;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.data.property.PropertyDefs;
import merlin.data.scenario.ScenarioUtil;
import merlin.gui.guiUtil;
import merlin.gui.labels.IScenarioLabelGenerator;
import merlin.gui.labels.WrappedComp;
import thunderheadeng.gui.ContextMenuListener;
import thunderheadeng.gui.ContextMenuModel;
import thunderheadeng.gui.framework.property.IDisplayProp;

public class ScenarioComp<T extends JComponent>
extends WrappedComp<T>
implements ContextMenuModel {
    private static final long serialVersionUID = 1L;
    private static final String MSG_ENABLE_CUSTOMIZED = Intl.intl("Customize property for active scenario");
    private static final String MSG_DISABLE_CUSTOMIZED = Intl.intl("Remove property customization for active scenario");
    private static final Object ACTIVATE_ACTION_KEY = "Activate";
    private static final Object DEACTIVATE_ACTION_KEY = "Deactivate";
    private final MerlinData d_md;
    private final IScenarioLabelGenerator d_callback;
    public Set<Object> d_props = null;
    private boolean d_showPhantom = false;

    public ScenarioComp(T baseComp, IScenarioLabelGenerator callback, Set<Object> props) {
        this(baseComp, callback, true, props);
    }

    public ScenarioComp(T baseComp, final IScenarioLabelGenerator callback, final boolean showTooltip, final Set<Object> props) {
        super((LayoutManager)new FlowLayout(0, 4, 0), baseComp);
        ActionMap actionMap = this.getActionMap();
        Function<Boolean, Action> showPhantom = show -> new AbstractAction((Boolean)show){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ Boolean val$show;
            {
                this.val$show = bl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ScenarioComp.this.setShowPhantom(this.val$show);
            }
        };
        actionMap.put(ACTIVATE_ACTION_KEY, showPhantom.apply(true));
        actionMap.put(DEACTIVATE_ACTION_KEY, showPhantom.apply(false));
        this.d_md = MerlinApp.getAppData();
        this.d_callback = callback;
        this.d_props = props;
        JComponent colorComp = new JComponent((JComponent)baseComp){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ JComponent val$baseComp;
            {
                this.val$baseComp = jComponent;
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                Boolean state = ScenarioComp.this.d_callback.getState(ScenarioComp.this.d_props);
                boolean isMixed = state == null;
                boolean isCustomized = !isMixed && state != false;
                String tooltip = null;
                Color aColor = guiUtil.getActiveColor();
                g.setColor(aColor);
                if (!isMixed && isCustomized) {
                    int rH = 16;
                    int yPos = this.getSize().height / 2 - rH / 2;
                    g.fillRect(0, yPos, this.getSize().width, rH);
                    if (showTooltip) {
                        tooltip = String.format(Intl.intl("Property is customized in scenario: %s."), ScenarioComp.this.d_md.scenarios.getActive().getName());
                    }
                } else if (isMixed) {
                    int rH = 16;
                    int yPos = this.getSize().height / 2 - rH / 2;
                    if (!this.val$baseComp.isEnabled() || ScenarioComp.this.d_showPhantom) {
                        int disabledColor = guiUtil.DISABLED_FILTER.filterRGB(0, 0, aColor.getRGB());
                        aColor = new Color(disabledColor);
                        g.setColor(aColor);
                        g.fillRect(0, yPos, this.getSize().width, rH);
                    } else {
                        g.setColor(aColor);
                        rH = this.getSize().width;
                        yPos = 8 - rH / 2;
                        g.fillRect(0, yPos, this.getSize().width, rH);
                    }
                    if (showTooltip) {
                        tooltip = String.format(Intl.intl("Selection contains mixed customizations for this property in scenario: %s."), ScenarioComp.this.d_md.scenarios.getActive().getName());
                    }
                } else if (!isCustomized && ScenarioComp.this.d_showPhantom && !ScenarioComp.this.d_md.scenarios.getActive().isDefault()) {
                    int disabledColor = guiUtil.DISABLED_FILTER.filterRGB(0, 0, aColor.getRGB());
                    aColor = new Color(disabledColor);
                    g.setColor(aColor);
                    int rH = 16;
                    int yPos = this.getSize().height / 2 - rH / 2;
                    g.fillRect(0, yPos, this.getSize().width, rH);
                }
                if (!Objects.equals(tooltip, this.getToolTipText())) {
                    this.setToolTipText(tooltip);
                }
            }
        };
        colorComp.setPreferredSize(new Dimension(4, new JCheckBox().getPreferredSize().height));
        colorComp.setBorder(BorderFactory.createEmptyBorder());
        this.add(colorComp);
        this.add((Component)baseComp);
        this.setBorder(BorderFactory.createEmptyBorder());
        ((Component)baseComp).addMouseListener(new ContextMenuListener(this));
        ((Component)baseComp).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                if (ScenarioComp.this.d_props == null || ScenarioComp.this.d_md.scenarios.getActive().isDefault()) {
                    return;
                }
                Set<IDisplayProp<Object>> supportedProps = ScenarioUtil.getSupportedScenarioProps(ScenarioComp.this.d_callback.getSelection(), PropertyDefs.ScenarioProps.ALL);
                if (!supportedProps.containsAll(ScenarioComp.this.d_props)) {
                    return;
                }
                ScenarioComp.this.registerKeyboard(true);
                if (e.isShiftDown()) {
                    ScenarioComp.this.d_showPhantom = true;
                    ScenarioComp.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                ScenarioComp.this.d_showPhantom = false;
                ScenarioComp.this.registerKeyboard(false);
                ScenarioComp.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ScenarioComp.this.d_props == null) {
                    return;
                }
                if (e.isShiftDown() && !ScenarioComp.this.d_md.scenarios.getActive().isDefault()) {
                    Boolean state = callback.getState(props);
                    boolean isMixed = state == null;
                    boolean isCustomized = !isMixed && state != false;
                    ScenarioComp.this.applyOverrideHelper(props, callback, !isCustomized);
                } else {
                    super.mouseClicked(e);
                }
            }
        });
    }

    private void registerKeyboard(boolean mouseOver) {
        KeyStroke shiftDown = KeyStroke.getKeyStroke(16, 64, false);
        KeyStroke shiftUp = KeyStroke.getKeyStroke(16, 0, true);
        InputMap inputMap = this.getInputMap(2);
        if (mouseOver) {
            inputMap.put(shiftDown, ACTIVATE_ACTION_KEY);
            inputMap.put(shiftUp, DEACTIVATE_ACTION_KEY);
        } else {
            inputMap.remove(shiftDown);
            inputMap.remove(shiftUp);
        }
    }

    private static void repaintWindowAncestor(Component c) {
        Window parent = SwingUtilities.getWindowAncestor(c);
        if (parent != null) {
            parent.repaint();
        } else {
            c.repaint();
        }
    }

    public void setShowPhantom(boolean showPhantom) {
        if (this.d_showPhantom != showPhantom) {
            this.d_showPhantom = showPhantom;
            this.repaint();
        }
    }

    @Override
    public JPopupMenu getContextMenu(MouseEvent e) {
        if (!this.isEnabled() || !this.d_callback.getInteractable() || this.d_md.scenarios.getActive().isDefault() || this.d_props == null) {
            return null;
        }
        ArrayList hooks = new ArrayList();
        Boolean state = this.d_callback.getState(this.d_props);
        boolean isMixed = state == null;
        boolean isCustomized = !isMixed && state != false;
        Set<IDisplayProp<Object>> supportedProps = ScenarioUtil.getSupportedScenarioProps(this.d_callback.getSelection(), PropertyDefs.ScenarioProps.ALL);
        if (!supportedProps.containsAll(this.d_props)) {
            return null;
        }
        BiConsumer<Boolean, String> addHook = (override, label) -> hooks.add(new UIHook(new MerlinOpImpl((app, md) -> this.applyOverrideHelper((Collection<Object>)this.d_props, this.d_callback, (boolean)override)), (String)label));
        if (isMixed) {
            addHook.accept(true, MSG_ENABLE_CUSTOMIZED);
            addHook.accept(false, MSG_DISABLE_CUSTOMIZED);
        } else if (isCustomized) {
            addHook.accept(false, MSG_DISABLE_CUSTOMIZED);
        } else {
            addHook.accept(true, MSG_ENABLE_CUSTOMIZED);
        }
        JPopupMenu ctxMenu = new JPopupMenu();
        for (UIHook hook : hooks) {
            if (hook == null) continue;
            ctxMenu.add(hook);
        }
        return ctxMenu;
    }

    private void applyOverrideHelper(Collection<Object> props, IScenarioLabelGenerator callback, boolean setCustomized) {
        HashSet dispProps = new HashSet();
        props.forEach(p -> {
            if (p instanceof IDisplayProp) {
                IDisplayProp dp = (IDisplayProp)p;
                dispProps.add(dp);
            }
        });
        Set<IDisplayProp<?>> storageProps = ScenarioUtil.toStorage(dispProps);
        Set<? extends IDisplayProp<?>> relatedProps = ScenarioUtil.getRelatedStorageProps(callback.getSelection(), storageProps);
        callback.applyOverride(relatedProps, setCustomized);
        ScenarioComp.repaintWindowAncestor(this);
    }
}

