/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.filter;

import java.awt.Component;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.ObjsFilter;
import merlin.gui.SetChooser;
import merlin.gui.filter.ObjRestrictionEditorComponents;
import merlin.gui.guiUtil;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.util.Predicates;

public class ObjsFilterEditorComponents<T>
extends ObjRestrictionEditorComponents<ObjsFilter.Mode, T> {
    public static <DataT extends IMerlinObj> SetChooser<DataT> newChooser(MerlinData md, String typeDesc, Class<DataT> type, Composite<? super DataT> objsRoot) {
        return ObjRestrictionEditorComponents.newChooser(md, typeDesc, type, objsRoot, Predicates.alwaysTrue());
    }

    public ObjsFilterEditorComponents(String typeDesc, Class<T> type, IValEditor<Set<T>> chooser) {
        super((Component)ObjsFilterEditorComponents.formatDescLabel(typeDesc), type, chooser, (ModeT mode) -> guiUtil.encodeToHtmlLabel(mode.name, mode.desc), ObjsFilter.Mode.FROM_LIST, ObjsFilter.Mode.values());
    }

    public ObjsFilterEditorComponents(String typeDesc, Function<String, ? extends Component> lblBuilder, Class<T> type, IValEditor<Set<T>> chooser) {
        super(lblBuilder.apply(ObjsFilterEditorComponents.formatDescString(typeDesc)), type, chooser, (ModeT mode) -> guiUtil.encodeToHtmlLabel(mode.name, mode.desc), ObjsFilter.Mode.FROM_LIST, ObjsFilter.Mode.values());
    }

    private static guiLabel formatDescLabel(String s) {
        String formattedStr = ObjsFilterEditorComponents.formatDescString(s);
        if (formattedStr != null) {
            return new guiLabel(formattedStr);
        }
        return null;
    }

    private static String formatDescString(String s) {
        if (s != null) {
            return String.format(Intl.intl("Allowed %s:"), s);
        }
        return null;
    }

    public void setValue(ObjsFilter<T> attrRestr) {
        if (attrRestr == null) {
            this.load(null, true, Collections.emptySet());
            return;
        }
        this.load(attrRestr.mode, !attrRestr.rejected, attrRestr.objects);
    }

    public ObjsFilter<T> getValue() {
        return ObjsFilterEditorComponents.constructValue(this.save());
    }

    public ObjsFilter<T> commitValue(Mediator domain) {
        return ObjsFilterEditorComponents.constructValue(this.commit(domain));
    }

    private static <T> ObjsFilter<T> constructValue(ObjRestrictionEditorComponents.Data<ObjsFilter.Mode, T> data) {
        return data == null ? null : new ObjsFilter((ObjsFilter.Mode)((Object)data.mode), !data.accepted, data.objs);
    }

    public String formatNonLiveValue() {
        return this.formatNonLiveValue(data -> {
            ObjsFilter strVal = ObjsFilterEditorComponents.constructValue(data);
            return strVal.format(Integer.MAX_VALUE);
        });
    }
}

