/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import merlin.Intl;
import merlin.unitsystem.UnitSystem;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.theUtil;

public class SetZDialog
extends guiDialog {
    private static final long serialVersionUID = -1067617725256271244L;
    public static final IPropertySet.Prop<MoveOption> PROP_MOVE_OPTION = new IPropertySet.Prop<MoveOption>(0, MoveOption.MOVE_ABS);
    public static final IPropertySet.Prop<Boolean> PROP_FLATTEN = new IPropertySet.Prop<Boolean>(1, false);
    public static final IPropertySet.Prop<UnitDouble> PROP_MOVE_TO_LOCATION = new IPropertySet.Prop<UnitDouble>(2, new UnitDouble(0.0, SI.METER));
    public static final IPropertySet.Prop<UnitDouble> PROP_OFFSET_LOCATION = new IPropertySet.Prop<UnitDouble>(3, new UnitDouble(0.0, SI.METER));
    public static final IPropertySet.Prop<UnitDouble> PROP_MULTIPLE_OFFSET = new IPropertySet.Prop<UnitDouble>(4, new UnitDouble(0.0, SI.METER));
    public static final IPropertySet.Prop<UnitDouble> PROP_MULTIPLE_SCALE = new IPropertySet.Prop<UnitDouble>(5, new UnitDouble(0.0, SI.METER));
    private final boolean d_anyHeight;
    private final ValueField<UnitDouble> d_boundsMinZ;
    private final ValueField<UnitDouble> d_boundsMaxZ;
    private final guiComboBox<MoveOption> d_moveChoices;
    private final guiCheckBox d_flattenCB;
    private final ValueField<UnitDouble> d_absZ;
    private final ValueField<UnitDouble> d_relZ;
    private final ValueField<UnitDouble> d_multipleOffset;
    private final ValueField<UnitDouble> d_multipleScale;

    public SetZDialog(Window owner, UnitDouble boundsMinZ, UnitDouble boundsMaxZ, boolean anyHasHeight) {
        super(owner, Intl.intl("Set Z"), 9);
        this.d_anyHeight = true;
        IUnitSrc lunit = UnitSystem.getType(0, true);
        this.d_boundsMinZ = ValueFields.udFld(boundsMinZ, lunit);
        this.d_boundsMinZ.setEnabled(false);
        this.d_boundsMaxZ = ValueFields.udFld(boundsMaxZ, lunit);
        this.d_boundsMaxZ.setEnabled(false);
        this.d_flattenCB = new guiCheckBox(Intl.intl("Flatten Objects"));
        this.d_flattenCB.setToolTipText(Intl.intl("Whether to flatten the geometry of the selected objects."));
        this.d_flattenCB.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.updateChoices();
            }
        });
        this.d_moveChoices = new guiComboBox();
        this.d_moveChoices.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = -5109338203680122774L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                MoveOption choice = (MoveOption)((Object)value);
                this.setText(choice.desc);
                this.setToolTipText(SetZDialog.this.d_flattenCB.isSelected() ? choice.flattenTT : choice.unflattenTT);
                return c;
            }
        });
        this.d_moveChoices.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.updateTooltip();
            }
        });
        this.d_absZ = ValueFields.udFld(lunit);
        this.d_relZ = ValueFields.udFld(lunit);
        this.d_multipleOffset = ValueFields.udFld(lunit);
        this.d_multipleScale = ValueFields.udFld(lunit);
        guiPanel moveToPnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(moveToPnl);
        gb.addRow(Intl.intl("Z = "), this.d_absZ, 0);
        gb.finalizeRows();
        guiPanel offsetPnl = new guiPanel();
        gb = new GridBagHelper(offsetPnl);
        gb.addRow(Intl.intl("Z Distance:"), this.d_relZ, 0);
        gb.finalizeRows();
        guiPanel multiplePnl = new guiPanel();
        gb = new GridBagHelper(multiplePnl);
        gb.addRow(Intl.intl("Z Offset:"), this.d_multipleOffset, 0);
        gb.addRow(Intl.intl("Z Multiplier:"), this.d_multipleScale, 0);
        gb.finalizeRows();
        Function<guiPanel, guiPanel> addSep = pnl -> pnl;
        CardLayout choiceDataLyt = new CardLayout();
        guiPanel choiceDataPnl = new guiPanel(choiceDataLyt);
        choiceDataPnl.add((Component)addSep.apply(moveToPnl), MoveOption.MOVE_ABS.name());
        choiceDataPnl.add((Component)addSep.apply(offsetPnl), MoveOption.MOVE_REL.name());
        choiceDataPnl.add((Component)addSep.apply(multiplePnl), MoveOption.MOVE_TO_MULTIPLE.name());
        this.d_moveChoices.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                choiceDataLyt.show(choiceDataPnl, ((MoveOption)((Object)((Object)e.getItem()))).name());
            }
        });
        guiPanel dlgPanel = this.getDialogPane();
        gb = new GridBagHelper(dlgPanel);
        gb.addFilledRow(new TitleSeparator(Intl.intl("Selection Bounds")));
        guiPanel boundsPnl = new guiPanel();
        GridBagHelper gb2 = new GridBagHelper(boundsPnl);
        gb2.addRow(Intl.intl("Min. Z:"), this.d_boundsMinZ, 0);
        gb2.addRow(Intl.intl("Max. Z:"), this.d_boundsMaxZ, 0);
        gb2.finalizeRows();
        gb.indent();
        gb.addFilledRow(boundsPnl);
        gb.unindent();
        if (this.d_anyHeight) {
            gb.addRow(this.d_flattenCB, 0);
        }
        gb.addRow(Intl.intl("Move to:"), this.d_moveChoices, 0);
        gb.indent();
        gb.addFilledRow(choiceDataPnl);
        gb.unindent();
        gb.finalizeRows();
        GridBagUtil.addGlue(dlgPanel);
        this.updateChoices();
    }

    public void load(IPropertySet props) {
        this.d_moveChoices.setSelectedItem((Object)props.get(PROP_MOVE_OPTION));
        this.d_flattenCB.setSelected(props.get(PROP_FLATTEN));
        this.d_absZ.setValue(props.get(PROP_MOVE_TO_LOCATION));
        this.d_relZ.setValue(props.get(PROP_OFFSET_LOCATION));
        this.d_multipleOffset.setValue(props.get(PROP_MULTIPLE_OFFSET));
        this.d_multipleScale.setValue(props.get(PROP_MULTIPLE_SCALE));
        this.updateChoices();
        this.updateTooltip();
    }

    public IPropertySet save() {
        PropertySet result = new PropertySet();
        result.set(PROP_MOVE_OPTION, this.d_moveChoices.getSelectedItem());
        boolean flatten = this.d_anyHeight ? this.d_flattenCB.isSelected() : false;
        result.set(PROP_FLATTEN, flatten);
        result.set(PROP_MOVE_TO_LOCATION, (UnitDouble)this.d_absZ.getValue());
        result.set(PROP_OFFSET_LOCATION, (UnitDouble)this.d_relZ.getValue());
        result.set(PROP_MULTIPLE_OFFSET, (UnitDouble)this.d_multipleOffset.getValue());
        result.set(PROP_MULTIPLE_SCALE, (UnitDouble)this.d_multipleScale.getValue());
        return result;
    }

    private void updateTooltip() {
        MoveOption choice = this.d_moveChoices.getSelectedItem();
        String tt = this.d_flattenCB.isSelected() ? choice.flattenTT : choice.unflattenTT;
        this.d_moveChoices.setToolTipText(tt);
    }

    private void updateChoices() {
        MoveOption currOption = this.d_moveChoices.getSelectedItem();
        if (this.d_flattenCB.isSelected()) {
            this.d_moveChoices.setItems((MoveOption[])MoveOption.values());
            this.d_moveChoices.setSelectedItem((Object)currOption);
        } else {
            IFilteredCollection<MoveOption> newOptions = theUtil.filter(Arrays.asList(MoveOption.values()), c -> !c.flattenOnly);
            this.d_moveChoices.setItems((Collection<MoveOption>)newOptions);
            if (!newOptions.contains((Object)currOption)) {
                currOption = (MoveOption)((Object)newOptions.iterator().next());
            }
            this.d_moveChoices.setSelectedItem((Object)currOption);
        }
    }

    public static enum MoveOption {
        MOVE_ABS(false, Intl.intl("Absolute Z"), Intl.intl("Moves all flattened objects to an absolute Z location."), Intl.intl("Moves the bottom of all objects to an absolute Z location.")),
        MOVE_REL(false, Intl.intl("Z Offset"), Intl.intl("Moves each object by a Z distance.")),
        MOVE_TO_MULTIPLE(false, Intl.intl("Z Multiple"), Intl.intl("Moves each flattened object to the nearest multiple of a Z location."), Intl.intl("Moves the bottom of each object to the nearest multiple of a Z location."));

        public final boolean flattenOnly;
        public final String desc;
        public final String flattenTT;
        public final String unflattenTT;

        private MoveOption(boolean flattenOnly, String desc, String tt) {
            this(flattenOnly, desc, tt, tt);
        }

        private MoveOption(boolean flattenOnly, String desc, String flattenTT, String unflattenTT) {
            this.flattenOnly = flattenOnly;
            this.desc = desc;
            this.flattenTT = flattenTT;
            this.unflattenTT = unflattenTT;
        }
    }
}

