/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import inferno.sim.Engine;
import inferno.sim.Param;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.RunInferno;
import merlin.gui.ScrollingConsole;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.CrashCatcher;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiField;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.IPropertySet;

public class RunSimDlg
extends guiDialog {
    private static final long serialVersionUID = 8942847620837494893L;
    private static final Logger LOGGER = Logger.getLogger(RunSimDlg.class.getSimpleName());
    public static final String PREF_SHOW_RESULTS = "RunSimDlg_show_results";
    public static final String PREF_PAUSE_IF_STUCK = "RunSimDlg_pause_if_stuck";
    private static final String STR_PAUSE = Intl.intl(" Pause ");
    private static final String STR_RESUME = Intl.intl("Resume");
    private static final String STR_OK = Intl.intl("OK");
    private static final String STR_CANCEL = Intl.intl("Cancel");
    private static final String STR_RESULTS = Intl.intl("Results");
    private static final String STR_LOG = Intl.intl("Save Log...");
    private static final String STR_SHOW_VIS = Intl.intl("Debug");
    private static final DecimalFormat FMT_DBL = new DecimalFormat("#######0.0");
    private JButton d_btOK;
    private JButton d_btPause;
    private JButton d_btResults;
    private JButton d_btSaveLog;
    private JButton d_btShowVis;
    private guiLabel d_labSimTime;
    private guiLabel d_labRunTime;
    private guiLabel d_labOccsRem;
    private guiLabel d_labOccsTotal;
    private guiLabel d_labDTGMax;
    private guiLabel d_labDTGAvg;
    private guiField d_fldSimTime;
    private guiField d_fldRunTime;
    private guiField d_fldOccsRem;
    private guiField d_fldOccsTotal;
    private guiField d_fldDTGMax;
    private guiField d_fldDTGAvg;
    private guiCheckBox d_ckShowResults;
    private guiCheckBox d_ckPauseIfStuck;
    private guiLabel d_stuckLbl;
    private Timer d_runTime;
    private ScrollingConsole d_log;
    private List<DlgListener> d_listeners;
    private boolean d_anyCompleted;
    private int d_simulationsRemaining;
    private int d_variationsRemaining;
    private RunInferno.RunState d_state = null;
    private DlgListener d_runApiListener = null;
    private RunInferno.IRunApi d_runApi = null;
    private boolean d_lastStuckStatus = false;

    public RunSimDlg(JFrame parent) {
        super((Window)parent, Intl.intl("Run Simulation"), 1);
        this.setResizable(true);
        this.d_anyCompleted = false;
        this.d_btOK = this.getButton(1);
        this.d_btOK.setText(STR_CANCEL);
        this.d_btOK.setEnabled(false);
        this.d_btPause = new JButton(STR_PAUSE);
        this.d_btResults = new JButton(STR_RESULTS);
        this.d_btSaveLog = new JButton(STR_LOG);
        this.d_btShowVis = new JButton(STR_SHOW_VIS);
        JComponent[] buttons = new JButton[]{this.d_btShowVis, this.d_btResults, this.d_btPause, this.d_btOK};
        this.setButtons(buttons);
        this.d_log = new ScrollingConsole();
        this.d_log.setPreferredSize(new Dimension(450, 150));
        this.getDialogPane().setLayout(new BorderLayout());
        this.getDialogPane().add((Component)this.getFieldPanel(), "North");
        this.getDialogPane().add((Component)this.d_log, "Center");
        this.getDialogPane().add((Component)this.getLowerPanel(), "South");
        this.d_listeners = new Vector<DlgListener>();
        this.connectToEvent(this.d_btOK, new EventOK());
        this.connectToEvent(this.d_btSaveLog, new EventLog());
        this.connectToEvent(this.d_btResults, new EventResults());
        this.connectToEvent(this.d_btShowVis, new ShowVisAction());
        this.d_btPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunSimDlg.this.d_btPause.setEnabled(false);
                if (RunSimDlg.this.d_btPause.getText().equals(STR_PAUSE)) {
                    RunSimDlg.this.fireEvent(new EventPause());
                } else if (RunSimDlg.this.d_btPause.getText().equals(STR_RESUME)) {
                    RunSimDlg.this.fireEvent(new EventResume());
                } else assert (false);
            }
        });
        final WallClockTimerListener wctl = new WallClockTimerListener();
        this.d_runTime = new Timer(100, wctl){
            private static final long serialVersionUID = -8329484171124712280L;

            @Override
            public void start() {
                super.start();
                wctl.start();
            }

            @Override
            public void stop() {
                super.stop();
                wctl.stop();
            }

            @Override
            public void restart() {
                super.restart();
                wctl.restart();
            }
        };
        this.d_runTime.setInitialDelay(1000);
        this.setSimTime(0.0);
        this.setRunTime(0.0);
        this.setOccsRem(0);
        this.setOccsTotal(0);
        this.setDTGMax(0.0);
        this.setDTGAvg(0.0);
    }

    public RunInferno.IRunCallback prepareRunCallback() {
        final RunSimDlg dlg = this;
        return new RunInferno.IRunCallback(){

            @Override
            public void nextSim(String filename, int currentSim, int simCount, int variationIndex, int variationCount, Engine engine) {
                Param param = engine.getKB().getParams();
                String scenario = param.scenario;
                int totOccs = engine.getAgentCount();
                RunSimDlg.invokeOnEventQueue(() -> {
                    dlg.setTitleFromPath(filename, scenario, variationIndex, variationCount, currentSim, simCount);
                    dlg.setOccsTotal(totOccs);
                    dlg.printToLog("running simulation");
                });
            }

            @Override
            public void setState(RunInferno.RunState state) {
                RunSimDlg.invokeOnEventQueue(() -> dlg.setState(state));
            }

            @Override
            public void setSimulationsRemaining(int simulationsRemaining, int variationsRemaining) {
                RunSimDlg.invokeOnEventQueue(() -> dlg.setSimulationsRemaining(simulationsRemaining, variationsRemaining));
            }

            @Override
            public void report(Throwable e) {
                Throwable exc = e.getCause() != null ? e.getCause() : e;
                Thread.UncaughtExceptionHandler handler = Thread.getDefaultUncaughtExceptionHandler();
                if (!(handler instanceof CrashCatcher)) {
                    throw new RuntimeException(exc);
                }
                RunInferno.logExceptionChain(e);
                String title = String.format(Intl.intl("An error occurred during the simulation."), new Object[0]);
                ((CrashCatcher)handler).report(dlg, title, Thread.currentThread(), exc);
            }

            @Override
            public void completed() {
                RunSimDlg.invokeOnEventQueue(dlg::markCompleted);
            }

            @Override
            public void finished() {
            }

            @Override
            public void update(IPropertySet meta) {
                double t = meta.get(Engine.META_TIME_SIM);
                int occs = meta.get(Engine.META_OCCS_REM);
                int occsTotal = meta.get(Engine.META_OCCS_TOTAL);
                double maxDTG = meta.get(Engine.META_DTG_MAX);
                double avgDTG = meta.get(Engine.META_DTG_AVG);
                double minDTG = meta.get(Engine.META_DTG_MIN);
                boolean stuck = meta.get(Engine.META_STUCK_STATUS);
                RunSimDlg.invokeOnEventQueue(() -> {
                    dlg.setSimTime(t);
                    dlg.setOccsRem(occs);
                    dlg.setOccsTotal(occsTotal);
                    dlg.setDTGMax(maxDTG);
                    dlg.setDTGAvg(avgDTG);
                    dlg.setDTGMin(minDTG);
                    dlg.setStuckStatus(stuck);
                });
            }
        };
    }

    public void connect(final RunInferno.IRunApi api, boolean closeOnFinish, final Runnable showResults) {
        if (this.d_runApiListener != null) {
            this.deleteListener(this.d_runApiListener);
            this.d_runApiListener = null;
        }
        this.d_runApi = api;
        this.d_runApiListener = new DlgListener(){

            @Override
            public void actionOK(RunSimDlg dlg) {
            }

            @Override
            public void changeState(RunSimDlg dlg, int newState) {
            }

            @Override
            public void actionResults(RunSimDlg dlg) {
                showResults.run();
            }

            @Override
            public void actionClearQueue(RunSimDlg dlg) {
                api.clearQueue();
            }

            @Override
            public void actionClearVariations(RunSimDlg dlg) {
                api.clearVariations();
            }

            @Override
            public void actionCancel(RunSimDlg dlg) {
                api.cancel();
            }

            @Override
            public void actionStop(RunSimDlg dlg) {
                api.stop();
            }

            @Override
            public void actionPause(RunSimDlg dlg) {
                api.pause();
            }

            @Override
            public void actionResume(RunSimDlg dlg) {
                api.resume();
            }

            @Override
            public void actionShowVis(RunSimDlg dlg) {
                api.showDebugView(dlg);
            }
        };
        this.addListener(this.d_runApiListener);
        new Thread(() -> {
            api.join(0L);
            RunSimDlg.invokeOnEventQueue(() -> {
                if (!this.isShowing()) {
                    return;
                }
                if (this.getResultsOnFinish() && this.anyCompleted()) {
                    showResults.run();
                }
                if (closeOnFinish) {
                    this.setVisible(false);
                }
            });
        }).start();
    }

    private static void invokeOnEventQueue(Runnable op) {
        if (SwingUtilities.isEventDispatchThread()) {
            op.run();
        } else {
            EventQueue.invokeLater(op);
        }
    }

    public void setTitleFromPath(String pthFilePath, String scenario, int variationIndex, int variationCount, int runIndex, int runCount) {
        if (variationCount <= 1) {
            this.setTitle(String.format(Intl.intl("Run Simulation - %3$d/%4$d %2$s - %1$s"), RunSimDlg.getName(pthFilePath), scenario, runIndex + 1, runCount));
        } else {
            this.setTitle(String.format(Intl.intl("Run Simulation - %4$d/%5$d %2$s - Variation %3$d - %1$s"), RunSimDlg.getName(pthFilePath), scenario, variationIndex + 1, runIndex + 1, runCount));
        }
    }

    private static String getName(String filename) {
        return new File(filename).getName();
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this.isVisible() && !this.okCancel()) {
            return;
        }
        super.setVisible(visible);
    }

    private boolean okCancel() {
        if (this.d_btOK.getText().equals(STR_OK)) {
            this.fireEvent(new EventOK());
        } else {
            if (this.d_btOK.getText().equals(STR_CANCEL)) {
                if (this.d_simulationsRemaining > 1) {
                    CancelSimulationDialog dialog = new CancelSimulationDialog((Window)this, this.d_simulationsRemaining, this.d_variationsRemaining);
                    int choice = dialog.doModal();
                    if (choice == 1) {
                        switch (dialog.getChoice().ordinal()) {
                            case 0: {
                                this.fireEvent(new EventClearQueue());
                                break;
                            }
                            case 1: {
                                this.fireEvent(new EventClearVariations());
                                break;
                            }
                        }
                        if (dialog.choseSaveSnapshot()) {
                            this.fireEvent(new EventStop());
                        } else {
                            this.fireEvent(new EventCancel());
                        }
                        boolean canceledAll = switch (dialog.getChoice().ordinal()) {
                            default -> throw new MatchException(null, null);
                            case 0 -> true;
                            case 1 -> {
                                if (this.d_simulationsRemaining == this.d_variationsRemaining) {
                                    yield true;
                                }
                                yield false;
                            }
                            case 2 -> this.d_simulationsRemaining == 1;
                        };
                        return canceledAll && !this.anyCompleted();
                    }
                    return false;
                }
                String msg = Intl.intl("Save simulation progress (enables resume)?");
                int choice = JOptionPane.showConfirmDialog(this, msg, Intl.intl("Cancel"), 1);
                if (choice == 1) {
                    this.fireEvent(new EventStop());
                    this.d_runTime.stop();
                    return !this.anyCompleted();
                }
                if (choice == 0) {
                    this.fireEvent(new EventCancel());
                    this.d_runTime.stop();
                    return !this.anyCompleted();
                }
                return false;
            }
            assert (false);
        }
        return true;
    }

    private void connectToEvent(JButton bt, final EventOp op) {
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunSimDlg.this.fireEvent(op);
            }
        });
    }

    public void writeLogText(PrintStream ps) {
        this.d_log.writeText(ps);
    }

    private guiPanel getFieldPanel() {
        guiPanel fields = new guiPanel(new GridBagLayout());
        this.d_labSimTime = new guiLabel(Intl.intl("Sim Time (s):"));
        this.d_labRunTime = new guiLabel(Intl.intl("Run Time (s):"));
        this.d_labOccsRem = new guiLabel(Intl.intl("Occs Rem:"));
        this.d_labOccsTotal = new guiLabel(Intl.intl("Occs Total:"));
        this.d_labDTGMax = new guiLabel(Intl.intl("DTG Max (m):"));
        this.d_labDTGAvg = new guiLabel(Intl.intl("DTG Avg (m):"));
        this.d_fldSimTime = new guiTextField();
        this.d_fldRunTime = new guiTextField();
        this.d_fldOccsRem = new guiIntField();
        this.d_fldOccsTotal = new guiIntField();
        this.d_fldDTGMax = new guiTextField();
        this.d_fldDTGAvg = new guiTextField();
        this.fixField(this.d_fldSimTime);
        this.fixField(this.d_fldRunTime);
        this.fixField(this.d_fldOccsRem);
        this.fixField(this.d_fldOccsTotal);
        this.fixField(this.d_fldDTGMax);
        this.fixField(this.d_fldDTGAvg);
        GridBagUtil.add(fields, this.d_labSimTime, 0, 0, 1, 1, 0, 0, 12, 12);
        GridBagUtil.add(fields, this.d_fldSimTime, 1, 0, 1, 1, 0, 0, 12, 24);
        GridBagUtil.add(fields, this.d_labRunTime, 2, 0, 1, 1, 0, 0, 12, 12);
        GridBagUtil.add(fields, this.d_fldRunTime, 3, 0, 1, 1, 0, 0, 12, 0);
        GridBagUtil.add(fields, this.d_labOccsRem, 0, 1, 1, 1, 0, 0, 12, 12);
        GridBagUtil.add(fields, this.d_fldOccsRem, 1, 1, 1, 1, 0, 0, 12, 24);
        GridBagUtil.add(fields, this.d_labOccsTotal, 2, 1, 1, 1, 0, 0, 12, 12);
        GridBagUtil.add(fields, this.d_fldOccsTotal, 3, 1, 1, 1, 0, 0, 12, 0);
        GridBagUtil.add(fields, this.d_labDTGMax, 0, 2, 1, 1, 0, 0, 12, 12);
        GridBagUtil.add(fields, this.d_fldDTGMax, 1, 2, 1, 1, 0, 0, 12, 24);
        GridBagUtil.add(fields, this.d_labDTGAvg, 2, 2, 1, 1, 0, 0, 12, 12);
        GridBagUtil.add(fields, this.d_fldDTGAvg, 3, 2, 1, 1, 0, 0, 12, 0);
        GridBagUtil.addGlue(fields);
        return fields;
    }

    public guiPanel getLowerPanel() {
        guiPanel panel = new guiPanel(new GridBagLayout());
        this.d_ckShowResults = new guiCheckBox(Intl.intl("Show results when finished"));
        RunSimDlg.bindToPref(this.d_ckShowResults, PREF_SHOW_RESULTS, true);
        this.d_ckPauseIfStuck = new guiCheckBox(Intl.intl("Pause if occupants appear to be stuck"));
        this.d_ckPauseIfStuck.setSelected(true);
        this.d_stuckLbl = new guiLabel(Intl.intl("Warning: Occupants appear to be stuck."));
        this.d_stuckLbl.setForeground(Color.RED);
        GridBagUtil.add(panel, this.d_ckShowResults, 0, 0, 4, 1, 12, 0, 0, 0);
        GridBagUtil.add(panel, this.d_ckPauseIfStuck, 0, 1, 4, 1, 6, 0, 0, 0);
        GridBagUtil.add(panel, this.d_stuckLbl, 0, 2, 4, 1, 6, 0, 0, 0);
        GridBagUtil.addGlue(panel);
        panel.setPreferredSize(panel.getPreferredSize());
        this.d_stuckLbl.setVisible(false);
        return panel;
    }

    public static void bindToPref(final JToggleButton bt, final String prefKey, boolean def) {
        if (Application.getApp() == null) {
            bt.setSelected(def);
            return;
        }
        String strPref = Application.getApp().getPreference(prefKey);
        boolean initState = strPref == null ? def : Boolean.parseBoolean(strPref);
        Application.getApp().setPreference(prefKey, Boolean.toString(initState));
        bt.setSelected(initState);
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Application.getApp().setPreference(prefKey, Boolean.toString(bt.isSelected()));
            }
        });
    }

    public boolean anyCompleted() {
        return this.d_anyCompleted;
    }

    public void markCompleted() {
        this.d_anyCompleted = true;
    }

    public boolean getResultsOnFinish() {
        return this.d_ckShowResults.isSelected();
    }

    public void setState(RunInferno.RunState state) {
        Objects.requireNonNull(state);
        if (state == this.d_state) {
            return;
        }
        this.d_state = state;
        switch (state) {
            case SIM_PRE: {
                this.d_btResults.setEnabled(false);
                this.d_btPause.setText(STR_PAUSE);
                this.d_btPause.setEnabled(false);
                this.d_btOK.setText(STR_CANCEL);
                this.d_btOK.setEnabled(false);
                this.d_runTime.stop();
                break;
            }
            case SIM_RUNNING: {
                this.d_btResults.setEnabled(true);
                this.d_btPause.setText(STR_PAUSE);
                this.d_btPause.setEnabled(true);
                this.d_btOK.setText(STR_CANCEL);
                this.d_btOK.setEnabled(true);
                this.d_runTime.start();
                break;
            }
            case SIM_PAUSED: {
                this.d_btResults.setEnabled(true);
                this.d_btPause.setText(STR_RESUME);
                this.d_btPause.setEnabled(true);
                this.d_btOK.setText(STR_CANCEL);
                this.d_btOK.setEnabled(true);
                this.d_runTime.stop();
                break;
            }
            case SIM_FINISHED: {
                this.d_btResults.setEnabled(true);
                this.d_btPause.setText(STR_PAUSE);
                this.d_btPause.setEnabled(false);
                this.d_btShowVis.setEnabled(false);
                this.d_btOK.setText(STR_OK);
                this.d_btOK.setEnabled(true);
                this.d_runTime.stop();
                break;
            }
            case SIM_NEXT: {
                this.d_btResults.setEnabled(true);
                this.d_btPause.setText(STR_PAUSE);
                this.d_btPause.setEnabled(false);
                this.d_btOK.setText(STR_CANCEL);
                this.d_btOK.setEnabled(false);
                this.d_runTime.restart();
            }
        }
    }

    private void fixField(guiField gf) {
        gf.setEditable(false);
        gf.setHorizontalAlignment(4);
        gf.setFocusable(false);
    }

    public void printToLog(String str) {
        this.d_log.addLine(str);
    }

    public Handler createLogHandler() {
        return new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (record.getLevel().intValue() < this.getLevel().intValue()) {
                    return;
                }
                AttributeSet style = record.getLevel().intValue() >= Level.WARNING.intValue() ? ScrollingConsole.STYLE_WARN : ScrollingConsole.STYLE_DEFAULT;
                RunSimDlg.this.d_log.addLine(style, record.getMessage());
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
    }

    public void setSimTime(double val) {
        this.d_fldSimTime.setText(FMT_DBL.format(val));
    }

    public void setStuckStatus(boolean stuck) {
        this.d_stuckLbl.setVisible(stuck);
        if (!this.d_lastStuckStatus && stuck && this.d_ckPauseIfStuck.isSelected()) {
            this.d_lastStuckStatus = stuck;
            this.fireEvent(new EventPause());
            JOptionPane.showMessageDialog(MerlinApp.getApp().getMainFrame(), Intl.intl("The occupants appear to be stuck. Simulation paused.\n\nPlease help us prevent this problem in the future by\ncontacting support@thunderheadeng.com and explaining\nthe situation prior to this error or sharing your model."), Intl.intl("Simulation Stuck"), 2);
        } else {
            this.d_lastStuckStatus = stuck;
        }
    }

    public void setRunTime(double val) {
        this.d_fldRunTime.setText(FMT_DBL.format(val));
    }

    public void setOccsRem(int val) {
        this.d_fldOccsRem.setText(Integer.toString(val));
    }

    public void setOccsTotal(int val) {
        this.d_fldOccsTotal.setText(Integer.toString(val));
    }

    public void setDTGMax(double val) {
        this.d_fldDTGMax.setText(FMT_DBL.format(val));
    }

    public void setDTGAvg(double val) {
        this.d_fldDTGAvg.setText(FMT_DBL.format(val));
    }

    public void setDTGMin(double val) {
    }

    private void fireEvent(EventOp op) {
        for (DlgListener dl : this.d_listeners) {
            op.fire(dl);
        }
    }

    public void deleteListener(DlgListener listener) {
        this.d_listeners.remove(listener);
    }

    public void addListener(DlgListener listener) {
        this.d_listeners.add(listener);
    }

    public void setSimulationsRemaining(int simulationsRemaining, int variationsRemaining) {
        this.d_simulationsRemaining = simulationsRemaining;
        this.d_variationsRemaining = variationsRemaining;
    }

    public static interface DlgListener {
        public void actionOK(RunSimDlg var1);

        public void actionClearQueue(RunSimDlg var1);

        public void actionClearVariations(RunSimDlg var1);

        public void actionCancel(RunSimDlg var1);

        public void actionStop(RunSimDlg var1);

        public void actionPause(RunSimDlg var1);

        public void actionResume(RunSimDlg var1);

        public void actionResults(RunSimDlg var1);

        public void actionShowVis(RunSimDlg var1);

        public void changeState(RunSimDlg var1, int var2);
    }

    private class EventOK
    implements EventOp {
        private EventOK() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionOK(RunSimDlg.this);
        }
    }

    private static interface EventOp {
        public void fire(DlgListener var1);
    }

    private class EventLog
    implements EventOp {
        private EventLog() {
        }

        @Override
        public void fire(DlgListener dl) {
            guiJFXFileChooser chooser = new guiJFXFileChooser("log.txt", null, null, (Boolean)false, (Boolean)false, (Boolean)true, FileFilters.EXT_FILTER_TEXT);
            File f = chooser.showSaveDialog();
            if (f == null) {
                return;
            }
            if (Application.getApp() != null) {
                Application.getApp().setWorkingDir(f.getPath());
            }
            try (PrintStream ps = new PrintStream(f, StandardCharsets.UTF_8);){
                RunSimDlg.this.writeLogText(ps);
            }
            catch (IOException e) {
                TeciLogging.log(LOGGER, e);
            }
        }
    }

    private class EventResults
    implements EventOp {
        private EventResults() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionResults(RunSimDlg.this);
        }
    }

    private class ShowVisAction
    implements EventOp {
        private ShowVisAction() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionShowVis(RunSimDlg.this);
        }
    }

    private class WallClockTimerListener
    implements ActionListener {
        private long totalTime = 0L;
        private long lastStart = System.currentTimeMillis();

        private WallClockTimerListener() {
        }

        public void start() {
            this.lastStart = System.currentTimeMillis();
        }

        public void stop() {
            this.totalTime += System.currentTimeMillis() - this.lastStart;
        }

        public void restart() {
            this.totalTime = 0L;
            this.start();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            long t = System.currentTimeMillis() - this.lastStart + this.totalTime;
            double runTime = (double)t / 1000.0;
            RunSimDlg.this.setRunTime(runTime);
        }
    }

    private static class CancelSimulationDialog
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        private final guiCheckBox d_saveSnaphshotCB;
        private final guiButtonGroup d_cancelAllGroup;
        private final guiRadioButton d_cancelAllRB;
        private final guiRadioButton d_cancelVariationsRB;
        private final guiRadioButton d_cancelOneRB;

        public CancelSimulationDialog(Window owner, int simulationCount, int variationCount) {
            super(owner, Intl.intl("Cancel Simulation"), 9);
            this.d_cancelAllRB = new guiRadioButton(String.format(Intl.intl("Cancel all %d remaining simulations."), simulationCount), true);
            this.d_cancelOneRB = new guiRadioButton(Intl.intl("Cancel only current simulation."));
            if (variationCount > 1) {
                this.d_cancelVariationsRB = new guiRadioButton(String.format(Intl.intl("Cancel %d remaining variations of the current scenario."), variationCount));
                this.d_cancelAllGroup = new guiButtonGroup(this.d_cancelAllRB, this.d_cancelVariationsRB, this.d_cancelOneRB);
            } else {
                this.d_cancelVariationsRB = null;
                this.d_cancelAllGroup = new guiButtonGroup(this.d_cancelAllRB, this.d_cancelOneRB);
            }
            this.d_saveSnaphshotCB = new guiCheckBox(Intl.intl("Save simulation progress (enables resume)?"), false);
            GridBagHelper gbh = new GridBagHelper(this.getDialogPane());
            gbh.addRow(Intl.intl("Cancel all simulations?"), 0);
            gbh.indent();
            gbh.addRow(this.d_cancelAllRB, 0);
            if (variationCount > 1) {
                gbh.addRow(this.d_cancelVariationsRB, 0);
            }
            gbh.addRow(this.d_cancelOneRB, 0);
            gbh.unindent();
            gbh.addRow(this.d_saveSnaphshotCB);
            gbh.finalizeRows();
        }

        public boolean choseSaveSnapshot() {
            return this.d_saveSnaphshotCB.isSelected();
        }

        public CancellationChoice getChoice() {
            if (this.d_cancelAllRB.isSelected()) {
                return CancellationChoice.CANCEL_ALL;
            }
            if (this.d_cancelVariationsRB != null && this.d_cancelVariationsRB.isSelected()) {
                return CancellationChoice.CANCEL_VARIATIONS;
            }
            return CancellationChoice.CANCEL_ONE;
        }

        public static enum CancellationChoice {
            CANCEL_ALL,
            CANCEL_VARIATIONS,
            CANCEL_ONE;

        }
    }

    private class EventClearQueue
    implements EventOp {
        private EventClearQueue() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionClearQueue(RunSimDlg.this);
        }
    }

    private class EventClearVariations
    implements EventOp {
        private EventClearVariations() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionClearVariations(RunSimDlg.this);
        }
    }

    private class EventStop
    implements EventOp {
        private EventStop() {
        }

        @Override
        public void fire(DlgListener listener) {
            listener.actionStop(RunSimDlg.this);
        }
    }

    private class EventCancel
    implements EventOp {
        private EventCancel() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionCancel(RunSimDlg.this);
        }
    }

    private class EventPause
    implements EventOp {
        private EventPause() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionPause(RunSimDlg.this);
        }
    }

    private class EventResume
    implements EventOp {
        private EventResume() {
        }

        @Override
        public void fire(DlgListener dl) {
            dl.actionResume(RunSimDlg.this);
        }
    }
}

