/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.geom.Geometry;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;

public class PointListEditor
extends guiPanel {
    private static final long serialVersionUID = -2007366814300379640L;
    private final guiDefaultTableModel d_model;
    private final guiTable d_table;
    private final boolean d_autoWrap;
    private final boolean d_showZ;
    private final UnitDouble d_defaultZ = new UnitDouble(0.0, MerlinApp.getApp().getUnitSystem().getLength());

    public PointListEditor(boolean autoWrap, boolean showZ, int options, boolean canAddRow) {
        this(autoWrap, showZ, options, canAddRow, Collections.emptyList());
    }

    public PointListEditor(boolean autoWrap, boolean showZ, int options, boolean canAddRow, List<Function<guiTable, guiTable.TableCommand>> customCommands) {
        super(new GridBagLayout());
        String[] stringArray;
        Class[] classArray;
        this.setMinimumSize(new Dimension(100, 100));
        this.d_autoWrap = autoWrap;
        this.d_showZ = showZ;
        if (this.d_showZ) {
            Class[] classArray2 = new Class[3];
            classArray2[0] = UnitDouble.class;
            classArray2[1] = UnitDouble.class;
            classArray = classArray2;
            classArray2[2] = UnitDouble.class;
        } else {
            Class[] classArray3 = new Class[2];
            classArray3[0] = UnitDouble.class;
            classArray = classArray3;
            classArray3[1] = UnitDouble.class;
        }
        Class[] clazzes = classArray;
        if (this.d_showZ) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = Intl.intl("X");
            stringArray2[1] = Intl.intl("Y");
            stringArray = stringArray2;
            stringArray2[2] = Intl.intl("Z");
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = Intl.intl("X");
            stringArray = stringArray3;
            stringArray3[1] = Intl.intl("Y");
        }
        String[] headers = stringArray;
        guiTableEditor editor = canAddRow ? new guiTableEditor(guiTableUtil.fixedColumnTable(headers, clazzes), options, customCommands) : new guiTableEditor(guiTableUtil.fixedColumnTable(headers, clazzes, 0), options, customCommands);
        this.d_table = editor.getTable();
        guiTable.UnitDoubleEditor cellEditor = new guiTable.UnitDoubleEditor(MerlinApp.getApp().getUnitSystem().getLength());
        this.d_table.getColumnModel().getColumn(0).setCellEditor(cellEditor);
        this.d_table.getColumnModel().getColumn(1).setCellEditor(cellEditor);
        if (this.d_showZ) {
            this.d_table.getColumnModel().getColumn(2).setCellEditor(cellEditor);
        }
        this.d_table.setPreferredScrollableViewportSize(new Dimension(200, 120));
        editor.setPreferredSize(new Dimension(350, 100));
        this.d_table.setNullValuesAllowed(false);
        this.d_model = (guiDefaultTableModel)this.d_table.getModel();
        GridBagUtil.add(this, editor, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 18);
    }

    public boolean getShowZ() {
        return this.d_showZ;
    }

    public void markRows(int ... rows) {
        if (rows.length > 0) {
            this.d_table.getSelectionModel().clearSelection();
            for (int ix : rows) {
                this.d_table.getSelectionModel().addSelectionInterval(ix, ix);
            }
        }
    }

    public int getNumPoints() {
        return this.d_model.getRowCount();
    }

    public void load(Collection<Point3d> points) {
        this.d_model.setRowCount(points.size());
        int lastRowIdx = this.d_table.getRowCount() - 1;
        this.d_table.setValueAt(null, lastRowIdx, 0);
        this.d_table.setValueAt(null, lastRowIdx, 1);
        if (this.d_showZ) {
            this.d_table.setValueAt(null, lastRowIdx, 2);
        }
        int ix = 0;
        for (Point3d p : points) {
            this.setPoint(p, ix);
            ++ix;
        }
    }

    public void setPoint(Point3d point, int index) {
        Unit lu = MerlinApp.getApp().getUnitSystem().getLength();
        this.d_model.setValueAt(UnitDouble.from(point.x, Geometry.LENGTH_UNIT, lu), index, 0);
        this.d_model.setValueAt(UnitDouble.from(point.y, Geometry.LENGTH_UNIT, lu), index, 1);
        if (this.d_showZ) {
            this.d_model.setValueAt(UnitDouble.from(point.z, Geometry.LENGTH_UNIT, lu), index, 2);
        }
    }

    public void addPoint(Point3d newPoint, int index) {
        int nRows = this.d_model.getRowCount();
        for (int row = nRows - 1; row >= index; --row) {
            this.d_model.setValueAt(this.d_model.getValueAt(row, 0), row + 1, 0);
            this.d_model.setValueAt(this.d_model.getValueAt(row, 1), row + 1, 1);
            if (!this.d_showZ) continue;
            this.d_model.setValueAt(this.d_model.getValueAt(row, 2), row + 1, 2);
        }
        this.setPoint(newPoint, index);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify) || !this.d_table.validateData(showWarn, allowModify)) {
            return false;
        }
        if (allowModify) {
            ArrayList<Integer> remRows = new ArrayList<Integer>();
            Point3d first = null;
            Tuple3d prev = null;
            for (int row = 0; row < this.d_model.getRowCount(); ++row) {
                UnitDouble z;
                UnitDouble x = (UnitDouble)this.d_model.getValueAt(row, 0);
                UnitDouble y = (UnitDouble)this.d_model.getValueAt(row, 1);
                UnitDouble unitDouble = z = this.d_showZ ? (UnitDouble)this.d_model.getValueAt(row, 2) : this.d_defaultZ;
                assert (x != null && y != null && z != null);
                Point3d p = new Point3d(x.getValue(Geometry.LENGTH_UNIT), y.getValue(Geometry.LENGTH_UNIT), z.getValue(Geometry.LENGTH_UNIT));
                if (first == null) {
                    first = p;
                }
                if (p.equals(prev)) {
                    remRows.add(row);
                }
                prev = p;
            }
            if (this.d_autoWrap && prev != null && prev.equals(first)) {
                remRows.add(this.d_model.getRowCount() - 1);
            }
            if (!remRows.isEmpty()) {
                int option = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Points table contains duplicate entries. Would you like to remove the duplicates?"), Intl.intl("Duplicate Points"), 1);
                if (option == 0) {
                    for (int m = remRows.size() - 1; m >= 0; --m) {
                        this.d_model.removeRow((Integer)remRows.get(m));
                    }
                } else if (option != 1) {
                    return false;
                }
            }
        }
        return true;
    }

    public List<Point3d> save() {
        ArrayList<Point3d> points = new ArrayList<Point3d>();
        for (int row = 0; row < this.d_model.getRowCount(); ++row) {
            UnitDouble z;
            UnitDouble x = (UnitDouble)this.d_model.getValueAt(row, 0);
            UnitDouble y = (UnitDouble)this.d_model.getValueAt(row, 1);
            UnitDouble unitDouble = z = this.d_showZ ? (UnitDouble)this.d_model.getValueAt(row, 2) : this.d_defaultZ;
            if (x == null || y == null || z == null) continue;
            Point3d p = new Point3d(x.getValue(Geometry.LENGTH_UNIT), y.getValue(Geometry.LENGTH_UNIT), z.getValue(Geometry.LENGTH_UNIT));
            points.add(p);
        }
        return points;
    }

    public TableModel getModel() {
        return this.d_model;
    }

    public guiTable getTable() {
        return this.d_table;
    }

    public void removePoint(int index) {
        if (index > this.d_model.getRowCount()) {
            return;
        }
        int nRows = this.d_model.getRowCount();
        for (int row = index; row < nRows - 1; ++row) {
            this.d_model.setValueAt(this.d_model.getValueAt(row + 1, 0), row, 0);
            this.d_model.setValueAt(this.d_model.getValueAt(row + 1, 1), row, 1);
            if (!this.d_showZ) continue;
            this.d_model.setValueAt(this.d_model.getValueAt(row + 1, 2), row, 2);
        }
        this.d_model.removeRow(nRows - 1);
    }

    public void selectRow(int index) {
        if (index > this.d_model.getRowCount()) {
            return;
        }
        this.d_table.setRowSelectionInterval(index, index);
        if (!this.d_showZ) {
            this.d_table.setColumnSelectionInterval(0, 1);
        } else {
            this.d_table.setColumnSelectionInterval(0, 2);
        }
    }

    public void clearSelection() {
        this.d_table.clearSelection();
    }

    public ListSelectionModel getSelectionModel() {
        return this.d_table.getSelectionModel();
    }

    public int[] getSelectedRows() {
        return this.d_table.getSelectedRows();
    }
}

