/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import javafx.stage.FileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.Delete;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.VehicleShape;
import merlin.gui.guiUtil;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.io.MerlinOOS;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.ALibraryDlg;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.io.FilenameManager;

public class LibraryDlg
extends ALibraryDlg<OccProfile> {
    private static final long serialVersionUID = 4159924215120436555L;
    private static final String libExtension = "plib";
    private static final String pthExtension = "pth";
    private final String d_predefinedLibInstallPath;
    private final String d_predefinedLibAppDataPath;
    private List<OccProfile> d_libModel;
    private final List<OccProfile> d_curModel;
    private final MerlinData d_md;
    private final Runnable d_updateMgr;
    private final MerlinApp d_app;

    public LibraryDlg(JFrame owner, MerlinApp app, MerlinData md) {
        this(owner, app, md, null);
    }

    public LibraryDlg(JFrame owner, MerlinApp app, MerlinData md, Runnable updateMgr) {
        super(owner, app, Intl.intl("Profile Libraries"), libExtension);
        this.d_app = app;
        this.d_md = md;
        this.d_updateMgr = updateMgr;
        Collection<OccProfile> profiles = this.d_md.profiles.flatten(OccProfile.class);
        this.d_curModel = new ArrayList<OccProfile>();
        this.d_curModel.addAll(profiles);
        this.d_libModel = new ArrayList<OccProfile>();
        this.d_predefinedLibInstallPath = new File(this.d_app.getInstallDir(), "lib/profiles").getPath();
        this.d_predefinedLibAppDataPath = new File(this.d_app.getAppDataDir(), "profiles").getPath();
        this.loadList(this.d_curModel, this.d_modelObjs, OccProfile.class);
        this.init(MerlinPrefs.LIB_DLG_LAST_LIB, MerlinPrefs.LIB_DLG_OPEN_DIR_PREF, OccProfile.class);
    }

    @Override
    protected File serialize(List<OccProfile> profiles) {
        guiJFXFileChooser chooser = new guiJFXFileChooser(String.format("%s.%s", FilenameManager.splitFilename(this.d_currentLib)[0], libExtension), MerlinPrefs.get(MerlinPrefs.LIB_DLG_OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, new FileChooser.ExtensionFilter(Intl.intl("Pathfinder Library"), "*.plib"));
        File f = chooser.showSaveDialog();
        if (f == null) {
            return null;
        }
        MerlinData tempmd = new MerlinData(false);
        tempmd.profiles.clear();
        tempmd.profiles.addAll(profiles);
        tempmd.setUnitSystem(this.d_app.getUnitSystem());
        try (MerlinOOS oos = new MerlinOOS(new BufferedOutputStream(new FileOutputStream(f)));){
            oos.writeObject(tempmd);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.getParent(), e.getLocalizedMessage(), Intl.intl("Error"), 2);
            e.printStackTrace();
        }
        return f;
    }

    @Override
    protected List<OccProfile> deserialize(String filename, boolean showWarnings) {
        try {
            MerlinIO io = new MerlinIO();
            MerlinIO.OpenResult result = io.openModel(this, filename, (tp, task) -> {}, MerlinOIS.DM_DEFAULT);
            this.d_libModel = new ArrayList<OccProfile>(result.data.profiles.flatten(OccProfile.class));
            return this.d_libModel;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            if (showWarnings) {
                JOptionPane.showMessageDialog(this.getParent(), String.format(Intl.intl("The file \"%s\" could not be read."), filename));
            }
            return null;
        }
    }

    @Override
    protected void saveToLibrary() {
        this.d_app.beginWaitCursor();
        if (!this.copyListSelection(this.d_modelObjs, this.d_libObjs, this.d_libModel).isEmpty()) {
            this.d_libUnsaved = true;
        }
        this.d_app.endWaitCursor();
    }

    @Override
    protected void loadFromLibrary() {
        this.d_app.beginWaitCursor();
        List<OccProfile> added = this.copyListSelection(this.d_libObjs, this.d_modelObjs, this.d_curModel);
        if (!added.isEmpty()) {
            this.d_md.pauseUpdates();
            Undo.begin(Intl.intl("New Profile"));
            AddObject.add(this.d_md, this.d_md.profiles, this.d_md.profiles.flatten().size(), added);
            for (OccProfile prof : added) {
                OccProfile.OccShape occShape = (OccProfile.OccShape)prof.get(OccProfile.PROP_SHAPE);
                if (!occShape.type.equals(VehicleShape.ShapeType.POLYGON)) continue;
                VehicleShape vs = occShape.vehicleShape;
                String newName = this.getNewName(vs, this.d_md.vehicleShapes.flatten(VehicleShape.class));
                VehicleShape newVs = (VehicleShape)vs.clone();
                if (!newName.equals(vs.getName())) {
                    newVs.setName(newName);
                }
                occShape = occShape.modifyVehicleShape(newVs);
                prof.set(OccProfile.PROP_SHAPE, occShape);
                AddObject.add((MerlinData)this.d_md, (Composite)this.d_md.vehicleShapes, (int)this.d_md.vehicleShapes.flatten().size(), (IMerlinObj[])new VehicleShape[]{newVs});
            }
            Undo.end(this.d_md);
            this.d_md.resumeUpdates();
        }
        this.d_app.endWaitCursor();
    }

    public List<OccProfile> copyListSelection(JList<OccProfile> jlistBeingCopied, JList<OccProfile> jlistCopiedTo, List<OccProfile> containerCopiedTo) {
        List<OccProfile> objsToCopy = jlistBeingCopied.getSelectedValuesList();
        if (objsToCopy.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<OccProfile, OccProfile> replacements = new LinkedHashMap<OccProfile, OccProfile>();
        for (OccProfile prof : objsToCopy) {
            String newName = this.getNewName(prof, containerCopiedTo);
            OccProfile newProf = prof.clone();
            if (!newName.equals(prof.getName())) {
                newProf.setName(newName);
            }
            replacements.put(prof, newProf);
        }
        for (OccProfile prof : replacements.keySet()) {
            int replIndex = objsToCopy.indexOf(prof);
            objsToCopy.remove(replIndex);
            objsToCopy.add(replIndex, (OccProfile)replacements.get(prof));
        }
        containerCopiedTo.addAll(objsToCopy);
        this.loadList(containerCopiedTo, jlistCopiedTo, OccProfile.class);
        return objsToCopy;
    }

    private String getNewName(IMerlinObj namedObj, Collection<? extends IMerlinObj> containerCopiedTo) {
        boolean alreadyExists;
        String baseName = namedObj.getName();
        Object newName = baseName;
        int i = 1;
        do {
            alreadyExists = false;
            for (IMerlinObj iMerlinObj : containerCopiedTo) {
                if (!iMerlinObj.getName().equals(newName)) continue;
                alreadyExists = true;
                break;
            }
            if (!alreadyExists) continue;
            newName = baseName + " (" + i++ + ")";
        } while (alreadyExists);
        return newName;
    }

    @Override
    protected void decorateCells(ALibraryDlg.ManagerRenderer r, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        guiUtil.decorateCellRenderer(this.d_md, list::repaint, MerlinUtil::getName, value, r, isSelected, cellHasFocus, true, true);
        OccProfile obj = (OccProfile)value;
        r.setText(obj.getName());
    }

    @Override
    protected void deleteModObjs() {
        final List objs = this.d_modelObjs.getSelectedValuesList();
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                Delete.uiDelete(LibraryDlg.this.d_app, md, new HashSet(objs), true);
                LibraryDlg.this.d_curModel.clear();
                LibraryDlg.this.d_curModel.addAll(LibraryDlg.this.d_md.profiles.flatten(OccProfile.class));
                LibraryDlg.this.loadList(LibraryDlg.this.d_curModel, LibraryDlg.this.d_modelObjs, OccProfile.class);
                if (LibraryDlg.this.d_updateMgr != null) {
                    LibraryDlg.this.d_updateMgr.run();
                }
            }
        };
        UIHook.run(this, "LibraryDlg.DeleteAction.actionPerformed", op, 0);
    }

    @Override
    protected void deleteLibObjs() {
        if (this.deleteObjs(this.d_libObjs, this.d_libModel)) {
            this.d_libUnsaved = true;
        }
    }

    private boolean deleteObjs(JList<OccProfile> jlist, List<OccProfile> domain) {
        List<OccProfile> objs = jlist.getSelectedValuesList();
        if (objs.isEmpty()) {
            return false;
        }
        domain.removeAll(objs);
        this.loadList(domain, jlist, OccProfile.class);
        return true;
    }

    @Override
    protected List<OccProfile> getLibModel() {
        return this.d_libModel;
    }

    @Override
    protected void resetLibModel() {
        this.d_libModel = new ArrayList<OccProfile>();
    }

    @Override
    protected FileChooser.ExtensionFilter[] getFileFilter() {
        return new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(Intl.intl("Pathfinder Profile Library"), "*.plib"), new FileChooser.ExtensionFilter(Intl.intl("Pathfinder Model File (Read-only)"), "*.pth")};
    }

    @Override
    protected String getPredefinedPath() {
        return this.d_predefinedLibInstallPath;
    }

    @Override
    protected String getAppDataPath() {
        return this.d_predefinedLibAppDataPath;
    }

    @Override
    protected Mediator getDomain() {
        return this.d_md;
    }
}

