/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import merlin.Intl;
import merlin.MerlinPrefs;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiFrame;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.FileFilters;

public class InfernoProgressFrm
extends guiFrame {
    private static final long serialVersionUID = 4289922581861435291L;
    private final JTextPane d_textPane = new JTextPane();
    private final JScrollPane d_textScrollPane = new JScrollPane(this.d_textPane);
    private final Rectangle d_viewport;
    private final JButton d_stopBtn;
    private final JButton d_saveLogBtn;
    private final Process d_infernoProcess;
    private final TextMonitor d_outMonitor;
    private final TextMonitor d_errMonitor;
    private boolean d_isRunning;

    public InfernoProgressFrm(Process infernoProcess) {
        super(Intl.intl("Inferno Simulation"));
        this.d_textPane.setEditable(false);
        this.d_textScrollPane.setAutoscrolls(true);
        this.d_viewport = new Rectangle();
        this.d_stopBtn = new JButton(Intl.intl("Stop"));
        this.d_saveLogBtn = new JButton(Intl.intl("Save Log"));
        this.d_stopBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InfernoProgressFrm.this.stopSimulation();
            }
        });
        this.d_saveLogBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InfernoProgressFrm.this.saveLog();
            }
        });
        Container mainPanel = this.getContentPane();
        mainPanel.setLayout(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(mainPanel, this.d_textScrollPane, 0, row, 1, 1, 12, 12, 0, 12, 1, 1.0, 1.0, 10);
        guiPanel buttonPanel = new guiPanel(new FlowLayout(1, 6, 0));
        buttonPanel.add(this.d_stopBtn);
        buttonPanel.add(this.d_saveLogBtn);
        GridBagUtil.add(mainPanel, buttonPanel, 0, ++row, 1, 1, 12, 0, 12, 12, 2, 1.0, 0.0, 10);
        this.setSize(400, 350);
        this.setResizable(true);
        this.setVisible(true);
        final StyledDocument doc = this.d_textPane.getStyledDocument();
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                InfernoProgressFrm.this.d_textPane.setCaretPosition(doc.getLength());
            }
        });
        this.d_isRunning = true;
        final Thread destroyer = new Thread(){

            @Override
            public void run() {
                InfernoProgressFrm.this.stopSimulation();
            }
        };
        Runtime.getRuntime().addShutdownHook(destroyer);
        this.d_infernoProcess = infernoProcess;
        Object lock = new Object();
        this.d_outMonitor = new TextMonitor(lock, doc, infernoProcess.getInputStream(), Color.BLUE);
        this.d_errMonitor = new TextMonitor(lock, doc, infernoProcess.getErrorStream(), Color.RED);
        this.d_outMonitor.setPriority(1);
        this.d_errMonitor.setPriority(1);
        this.d_outMonitor.startMonitoring();
        this.d_errMonitor.startMonitoring();
        new Thread(){

            @Override
            public void run() {
                try {
                    InfernoProgressFrm.this.d_infernoProcess.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                InfernoProgressFrm.this.d_stopBtn.setEnabled(false);
                InfernoProgressFrm.this.d_isRunning = false;
                Runtime.getRuntime().removeShutdownHook(destroyer);
            }
        }.run();
    }

    public boolean isRunning() {
        return this.d_isRunning;
    }

    @Override
    public boolean close() {
        if (this.isRunning()) {
            String msg = Intl.intl("Are you sure you want to close and terminate the simulation?");
            String title = Intl.intl("Simulation in Progress");
            int options = 2;
            if (JOptionPane.showConfirmDialog(this, msg, title, 2) != 0) {
                return false;
            }
        }
        this.stopSimulation();
        return super.close();
    }

    private void stopSimulation() {
        this.d_outMonitor.stopMonitoring();
        this.d_errMonitor.stopMonitoring();
        this.d_infernoProcess.destroy();
    }

    private void saveLog() {
        guiJFXFileChooser chooser = new guiJFXFileChooser(null, MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)true, FileFilters.EXT_FILTER_LOG);
        File f = chooser.showSaveDialog();
        if (f == null) {
            return;
        }
        try {
            PrintWriter writer = new PrintWriter(new FileOutputStream(f));
            this.d_textPane.write(writer);
            writer.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, Intl.intl("An error occurred writing the log file."), Intl.intl("Error Writing File"), 0);
        }
    }

    private static class TextMonitor
    extends Thread {
        private static final String nl = System.getProperty("line.separator");
        private final Document d_document;
        private final InputStream d_stream;
        private final AttributeSet d_textAttrs;
        private volatile boolean d_running = true;
        private final Object d_lock;

        public TextMonitor(Object lock, Document doc, InputStream stream, Color textColor) {
            this.d_lock = lock;
            this.d_document = doc;
            this.d_stream = stream;
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setForeground(attrs, textColor);
            this.d_textAttrs = attrs;
        }

        public synchronized void startMonitoring() {
            this.d_running = true;
            this.start();
        }

        public synchronized void stopMonitoring() {
            this.d_running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader read = new BufferedReader(new InputStreamReader(this.d_stream));
            String line = null;
            try {
                while (this.d_running && (line = read.readLine()) != null) {
                    this.println(line);
                    Thread.yield();
                }
                read.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.d_running = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void println(String text) {
            Object object = this.d_lock;
            synchronized (object) {
                block5: {
                    try {
                        String textln = text + nl;
                        this.d_document.insertString(this.d_document.getLength(), textln, this.d_textAttrs);
                    }
                    catch (BadLocationException e) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError();
                    }
                }
            }
        }
    }
}

