/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.ScenarioSetupAction;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.egress.agents.OccProfile;
import merlin.data.montecarlo.MonteCarlo;
import merlin.data.montecarlo.VariationOccFilter;
import merlin.data.montecarlo.VariationPositionDistribution;
import merlin.data.montecarlo.VariationProfileRule;
import merlin.data.montecarlo.VariationRoomRule;
import merlin.data.scenario.Scenario;
import merlin.data.scenario.ScenarioUtil;
import merlin.gui.DistributionEditor;
import merlin.gui.MonteCarloOccFilterPnl;
import merlin.gui.ScenarioSetupDlg;
import merlin.gui.guiUtil;
import merlin.gui.labels.ILabelGenerator;
import merlin.gui.labels.IScenarioLabelGenerator;
import merlin.gui.labels.WrappedComp;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.framework.property.IDisplayProp;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.InfiniteUrn;
import thunderheadeng.util.theUtil;

public class EditMonteCarloDlg
extends guiDialog {
    private static final long serialVersionUID = 1L;
    private final MerlinData d_md;
    private ScenarioUtil.MixedOverrideState d_overrides = ScenarioUtil.MixedOverrideState.EMPTY;
    private JButton d_overrideBtn;
    private final ValueField<Integer> d_variationCountFld;
    private final WrappedComp<guiMultiStateCheckBox> d_ckRandomizePositions;
    private final WrappedComp<guiMultiStateCheckBox> d_ckRandomizeProperties;
    private final WrappedComp<guiMultiStateCheckBox> d_ckRandomizeProfiles;
    private final guiComboBox<VariationProfileRule> d_cbProfileRule;
    private final DistributionEditor<OccProfile> d_edProfileDist;
    private final HTMLBtn d_occFilterBtn;
    private List<VariationOccFilter> d_occFilterData;
    private final guiComboBox<VariationRoomRule> d_cbRoomRule;
    private final guiComboBox<VariationPositionDistribution> d_cbPositionDistribution;
    private final ValueField<Long> d_randomizationSeedFld;

    public EditMonteCarloDlg(Window owner, MerlinData md) {
        super(owner, Intl.intl("Monte Carlo Parameters"), 9);
        this.d_md = md;
        ILabelGenerator labels = EditMonteCarloDlg.getLabels(this);
        WrappedComp<guiLabel> labVariationCount = labels.lbl(MonteCarlo.VARIATION_COUNT);
        this.d_variationCountFld = ValueFields.intFld(IntVR.above(1, true));
        this.d_ckRandomizePositions = labels.checkbox(MonteCarlo.RANDOMIZE_POSITIONS);
        ((guiMultiStateCheckBox)this.d_ckRandomizePositions.comp).addActionListener(e -> this.updatePanel());
        this.d_ckRandomizeProperties = labels.checkbox(MonteCarlo.RANDOMIZE_PROPERTIES);
        ((guiMultiStateCheckBox)this.d_ckRandomizeProperties.comp).addActionListener(e -> this.updatePanel());
        this.d_ckRandomizeProfiles = labels.checkbox(MonteCarlo.RANDOMIZE_PROFILES);
        ((guiMultiStateCheckBox)this.d_ckRandomizeProfiles.comp).addActionListener(e -> this.updatePanel());
        this.d_cbProfileRule = guiUtil.newEnumCombo(VariationProfileRule.class);
        this.d_cbProfileRule.addActionListener(e -> this.updatePanel());
        this.d_edProfileDist = new DistributionEditor<OccProfile>(md, MonteCarlo.PROFILE_DIST.name, md.profiles, OccProfile.class, null, data -> Set.of(md.profiles.NO_CHANGE));
        WrappedComp<guiLabel> labTargetProfiles = labels.lbl(MonteCarlo.PROFILE_DIST);
        guiPanel profilePanel = new guiPanel(new MigLayout("insets 0"));
        profilePanel.add(this.d_cbProfileRule);
        profilePanel.add(this.d_edProfileDist);
        this.d_occFilterData = Collections.emptyList();
        WrappedComp<guiLabel> labOccFilters = labels.lbl(MonteCarlo.OCC_FILTERS);
        this.d_occFilterBtn = new HTMLBtn(guiUtil.escapeHTML(Intl.intl("<none>")));
        this.d_occFilterBtn.setPreferredSize(new Dimension(160, this.d_occFilterBtn.getPreferredSize().height));
        this.d_occFilterBtn.addActionListener(e -> {
            MonteCarloOccFilterPnl editorPnl = new MonteCarloOccFilterPnl(md);
            editorPnl.load(this.d_occFilterData);
            Window parent = SwingUtilities.getWindowAncestor(this);
            String title = String.format(Intl.intl("Edit Occupant Filters"), new Object[0]);
            guiDialog dlg = new guiDialog(parent, title, 9);
            dlg.setResizable(true);
            guiPanel c = dlg.getDialogPane();
            c.setLayout(new BorderLayout());
            c.add((Component)editorPnl, "Center");
            if (dlg.doModal() == 1 && dlg.isModified()) {
                this.d_occFilterData = editorPnl.save();
                this.updatePanel();
                this.setModified(true);
            }
        });
        WrappedComp<guiLabel> labRoomRuleBox = labels.lbl(MonteCarlo.ROOM_RULE);
        this.d_cbRoomRule = guiUtil.newEnumCombo(VariationRoomRule.class);
        WrappedComp<guiLabel> labPositionDistribution = labels.lbl(MonteCarlo.POSITION_DISTRIBUTION);
        this.d_cbPositionDistribution = guiUtil.newEnumCombo(VariationPositionDistribution.class);
        WrappedComp<guiLabel> labRandomizationSeed = labels.lbl(MonteCarlo.RANDOMIZATION_SEED);
        this.d_randomizationSeedFld = ValueFields.fld(Long.class);
        this.d_overrideBtn = new JButton(new ScenarioSetupAction(e -> {
            MonteCarlo obj = this.d_md.monteCarlo;
            ScenarioSetupDlg dlg = new ScenarioSetupDlg((Window)this, 0, false);
            List<IDisplayProp<?>> supportedProps = ScenarioUtil.getSortedAvailableDisplayProps(obj);
            dlg.setAvailObjs(supportedProps);
            dlg.setObjectSelectionState(this.d_overrides.toDisplay(supportedProps));
            if (dlg.doModal() == 1) {
                this.applyNewOverrideState(dlg.getObjectSelectionState().toStorage());
            }
            this.repaint();
        }));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                SwingUtilities.invokeLater(() -> EditMonteCarloDlg.this.requestFocusInWindow());
            }
        });
        GridBagHelper gbh = new GridBagHelper(this.getDialogPane());
        gbh.addRow(labVariationCount, this.d_variationCountFld);
        gbh.addRow(labRandomizationSeed, this.d_randomizationSeedFld);
        gbh.addTitle(Intl.intl("Occupant Selection"));
        gbh.indent();
        gbh.addFilledRow(this.d_ckRandomizePositions);
        gbh.addFilledRow(this.d_ckRandomizeProperties);
        gbh.addFilledRow(this.d_ckRandomizeProfiles);
        gbh.addRow(labOccFilters, this.d_occFilterBtn);
        gbh.unindent();
        gbh.addTitle(Intl.intl("Options"));
        gbh.indent();
        gbh.addRow(labTargetProfiles, profilePanel);
        gbh.addRow(labRoomRuleBox, this.d_cbRoomRule);
        gbh.addRow(labPositionDistribution, this.d_cbPositionDistribution);
        gbh.unindent();
        gbh.finalizeRows();
        guiPanel southPnl = new guiPanel(new GridBagLayout());
        GridBagUtil.add(southPnl, this.d_overrideBtn, 0, 0, 1, 1, 6, 12, 0, 12, 0, 0.0, 0.0);
        GridBagUtil.add(southPnl, Box.createGlue(), 1, 0, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0);
        GridBagUtil.add(southPnl, this.getButtonPanel(), 2, 0, 1, 1, 0, 12, 0, 0, 0, 0.0, 0.0);
        this.getRootPane().getContentPane().add((Component)southPnl, "South");
    }

    public void applyNewOverrideState(ScenarioUtil.MixedOverrideState newOverrides) {
        MonteCarlo tempObj = new MonteCarlo(this.d_md.profiles.NO_CHANGE);
        this.store(this.d_md, tempObj, true);
        Set<IDisplayProp<?>> newSelectedState = newOverrides.overrides();
        for (IDisplayProp<?> prop : this.d_overrides.overrides()) {
            PropValue<?> getProp;
            if (newSelectedState.contains(prop) || !(getProp = this.d_md.scenarios.getDefault().getObjValue(this.d_md.monteCarlo, prop)).isSupported()) continue;
            tempObj.set(prop.asProp(), getProp.get());
        }
        this.load(tempObj, this.d_md.scenarios.getActive(), true);
        this.d_overrides = newOverrides;
        this.setModified(true);
    }

    public void load(MonteCarlo mc, Scenario activeScenario, boolean loadFromTemp) {
        if (!loadFromTemp) {
            this.d_overrides = ScenarioUtil.getScenarioOverrideState(activeScenario, Collections.singleton(mc));
        }
        this.d_overrideBtn.setEnabled(!activeScenario.isDefault());
        this.d_variationCountFld.setTypedValue(mc.get(MonteCarlo.VARIATION_COUNT));
        ((guiMultiStateCheckBox)this.d_ckRandomizePositions.comp).setSelected(mc.get(MonteCarlo.RANDOMIZE_POSITIONS));
        ((guiMultiStateCheckBox)this.d_ckRandomizeProperties.comp).setSelected(mc.get(MonteCarlo.RANDOMIZE_PROPERTIES));
        ((guiMultiStateCheckBox)this.d_ckRandomizeProfiles.comp).setSelected(mc.get(MonteCarlo.RANDOMIZE_PROFILES));
        this.d_cbProfileRule.setSelectedItem(mc.get(MonteCarlo.PROFILE_RULE));
        this.d_edProfileDist.setValue((OccProfile)((Object)mc.get(MonteCarlo.PROFILE_DIST)));
        this.d_occFilterData = mc.get(MonteCarlo.OCC_FILTERS);
        this.d_cbRoomRule.setSelectedItem(mc.get(MonteCarlo.ROOM_RULE));
        this.d_cbPositionDistribution.setSelectedItem(mc.get(MonteCarlo.POSITION_DISTRIBUTION));
        this.d_randomizationSeedFld.setValue(mc.get(MonteCarlo.RANDOMIZATION_SEED));
        this.setModified(loadFromTemp);
        this.updatePanel();
    }

    public void store(MerlinData md, MonteCarlo mc, boolean isTemp) {
        assert (isTemp == (mc.getDomain() == null));
        if (!isTemp) {
            Undo.insertUndoEntry_restore(md, mc);
            Scenario activeScenario = md.scenarios.getActive();
            if (!activeScenario.isDefault()) {
                ScenarioUtil.applyScenarioOverrideState(md, activeScenario, Collections.singleton(mc), this.getOverrideStateCopy());
            }
        }
        mc.set(MonteCarlo.VARIATION_COUNT, (Integer)this.d_variationCountFld.getValue());
        mc.set(MonteCarlo.RANDOMIZE_POSITIONS, ((guiMultiStateCheckBox)this.d_ckRandomizePositions.comp).isSelected());
        mc.set(MonteCarlo.RANDOMIZE_PROPERTIES, ((guiMultiStateCheckBox)this.d_ckRandomizeProperties.comp).isSelected());
        mc.set(MonteCarlo.RANDOMIZE_PROFILES, ((guiMultiStateCheckBox)this.d_ckRandomizeProfiles.comp).isSelected());
        mc.set(MonteCarlo.PROFILE_RULE, this.d_cbProfileRule.getSelectedItem());
        VariationProfileRule variationProfileRule = this.d_cbProfileRule.getSelectedItem();
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"NEW_DISTRIBUTION", "SHUFFLE_EXISTING"}, (VariationProfileRule)variationProfileRule, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                mc.set(MonteCarlo.PROFILE_DIST, (IUrn)this.d_edProfileDist.getValue());
                break;
            }
            case 1: {
                mc.set(MonteCarlo.PROFILE_DIST, new InfiniteUrn<OccProfile>(md.profiles.NO_CHANGE));
                break;
            }
            case -1: {
                mc.set(MonteCarlo.PROFILE_DIST, new InfiniteUrn<OccProfile>(md.profiles.NO_CHANGE));
            }
        }
        mc.set(MonteCarlo.OCC_FILTERS, this.d_occFilterData);
        mc.set(MonteCarlo.ROOM_RULE, this.d_cbRoomRule.getSelectedItem());
        mc.set(MonteCarlo.POSITION_DISTRIBUTION, this.d_cbPositionDistribution.getSelectedItem());
        mc.set(MonteCarlo.RANDOMIZATION_SEED, (Long)this.d_randomizationSeedFld.getValue());
    }

    private void updatePanel() {
        int numFilters = this.d_occFilterData.size();
        int numGroups = this.d_md.agents.flatten(EgressAgentComp.class).size();
        if (numFilters < 1) {
            this.d_occFilterBtn.setText(guiUtil.escapeHTML(Intl.intl("<none>")));
        } else {
            this.d_occFilterBtn.setText(guiUtil.escapeHTML(String.format(Intl.intl("<%d filter(s)>"), numFilters)));
        }
        this.d_occFilterBtn.setEnabled(numGroups > 0);
        boolean positionsRandomized = this.anyPositionsRandomized();
        boolean profilesRandomized = this.anyProfilesRandomized();
        this.d_cbProfileRule.setEnabled(profilesRandomized);
        this.d_edProfileDist.setEnabled(profilesRandomized);
        this.d_cbRoomRule.setEnabled(positionsRandomized);
        this.d_cbPositionDistribution.setEnabled(positionsRandomized);
        this.d_edProfileDist.setVisible(this.d_cbProfileRule.getSelectedItem() == VariationProfileRule.NEW_DISTRIBUTION);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        boolean anyRandomized;
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if ((Integer)this.d_variationCountFld.getValue() <= 1) {
            return true;
        }
        boolean positionsRandomized = this.anyPositionsRandomized();
        boolean propertiesRandomized = this.anyPropertiesRandomized();
        boolean profilesRandomized = this.anyProfilesRandomized();
        VariationProfileRule variationProfileRule = this.d_cbProfileRule.getSelectedItem();
        int n = 0;
        boolean profilesIdentical = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"SHUFFLE_EXISTING", "NEW_DISTRIBUTION"}, (VariationProfileRule)variationProfileRule, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> false;
            case 1 -> this.profileDistrubtionNoChange();
            case -1 -> false;
        };
        boolean bl = anyRandomized = positionsRandomized || propertiesRandomized || profilesRandomized && !profilesIdentical;
        if (!anyRandomized) {
            String msg = Intl.intl("The specified conditions will result in all variations being identical.\nWould you like to continue?");
            int choice = JOptionPane.showConfirmDialog(MerlinApp.getApp().getActiveFrame(), msg, Intl.intl("Identical Variations"), 0);
            return choice == 0;
        }
        return true;
    }

    private boolean anyPositionsRandomized() {
        return ((guiMultiStateCheckBox)this.d_ckRandomizePositions.comp).isSelected() || this.d_occFilterData.stream().anyMatch(VariationOccFilter::randomizePositions);
    }

    private boolean anyPropertiesRandomized() {
        return ((guiMultiStateCheckBox)this.d_ckRandomizeProperties.comp).isSelected() || this.d_occFilterData.stream().anyMatch(VariationOccFilter::randomizeProperties);
    }

    private boolean anyProfilesRandomized() {
        return ((guiMultiStateCheckBox)this.d_ckRandomizeProfiles.comp).isSelected() || this.d_occFilterData.stream().anyMatch(VariationOccFilter::randomizeProfiles);
    }

    private boolean profileDistrubtionNoChange() {
        if (this.d_edProfileDist == null || this.d_edProfileDist.getValue() == null || ((IUrn)this.d_edProfileDist.getValue()).getWeights() == null || !((IUrn)this.d_edProfileDist.getValue()).getWeights().containsKey(this.d_md.profiles.NO_CHANGE)) {
            return false;
        }
        return theUtil.eq(((IUrn)this.d_edProfileDist.getValue()).getWeights().get(this.d_md.profiles.NO_CHANGE), 1.0, 0.001);
    }

    public ScenarioUtil.MixedOverrideState getOverrideStateCopy() {
        return this.d_overrides.toStorage();
    }

    private static ILabelGenerator getLabels(final EditMonteCarloDlg dlg) {
        return new IScenarioLabelGenerator(){
            MerlinData d_md = MerlinApp.getAppData();

            @Override
            public Collection<? extends IMerlinObj> getSelection() {
                return List.of(this.d_md.monteCarlo);
            }

            @Override
            public Boolean getState(Collection<Object> props) {
                return dlg.getOverrideStateCopy().overrides().containsAll(props);
            }

            @Override
            public void applyOverride(Collection<? extends IDisplayProp<?>> props, boolean setCustomized) {
                ScenarioUtil.MixedOverrideState tempState = dlg.getOverrideStateCopy();
                if (setCustomized) {
                    tempState.overrides().addAll(props);
                } else {
                    tempState.overrides().removeAll(props);
                }
                dlg.applyNewOverrideState(tempState.toStorage());
                dlg.repaint();
            }
        };
    }
}

