/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Window;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.animation.AAnimationClip;
import merlin.data.animation.AnimDirection;
import merlin.data.animation.AnimRetargetMode;
import merlin.data.animation.AnimType;
import merlin.data.animation.Animation;
import merlin.data.animation.IdleAnimationClip;
import merlin.data.animation.MoveAnimationClip;
import merlin.data.animation.PivotAnimationClip;
import merlin.gui.AnimationsPanel;
import merlin.gui.INewDlg;
import merlin.gui.MerlinComboBox;
import merlin.gui.StrTagsField;
import merlin.gui.guiUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Sets;

public class AnimationNewDlg
extends guiDialog
implements INewDlg<Animation> {
    private static final long serialVersionUID = 1L;
    private final AnimationsPanel.NameField d_nameFld;
    private final guiCheckBox d_baseObjCheckBox;
    private final MerlinComboBox<Animation> d_baseCB;
    private final guiComboBox<AnimType> d_typeCB;
    private final StrTagsField d_tagsFld;
    private final AnimationsPanel.FileChooserField d_clipFld;
    private final AnimationsPanel.FileChooserField d_basePoseFld;
    private final guiCheckBox d_animationHasBasePoseCB;

    public AnimationNewDlg(Window owner, MerlinData md, String title, String suggestedName, Animation suggestedBasedOn) {
        this(owner, md, title, suggestedName, null, suggestedBasedOn);
    }

    public AnimationNewDlg(Window owner, MerlinData md, String title, String suggestedName, File importFile, Animation suggestedBasedOn) {
        super(owner, title, 9);
        this.d_nameFld = new AnimationsPanel.NameField(suggestedName);
        this.d_baseObjCheckBox = new guiCheckBox(Intl.intl("Based On:"));
        this.d_baseCB = new MerlinComboBox(md, Animation.class, (IMerlinObj[])new Animation[0]);
        this.d_typeCB = guiUtil.newCombo(type -> new Pair<String, String>(type.displayName, type.description), Arrays.stream(AnimType.values()).filter(type -> type != AnimType.PIVOT).collect(Collectors.toList()));
        this.d_tagsFld = new StrTagsField();
        this.d_tagsFld.setEmptyAllowed(false);
        this.d_tagsFld.setNullAllowed(false);
        guiLabel clipLbl = guiUtil.lblProp(AAnimationClip.FILE.name, AAnimationClip.FILE.desc);
        this.d_clipFld = AnimationsPanel.newClipField();
        guiLabel basePoseLbl = guiUtil.lblProp(AAnimationClip.RETARGET_SOURCE.name, AAnimationClip.RETARGET_SOURCE.desc);
        this.d_basePoseFld = AnimationsPanel.newBasePoseField();
        guiLabel tagsLbl = guiUtil.lblProp(Animation.TAGS.name, Animation.TAGS.desc);
        this.d_animationHasBasePoseCB = AnimationsPanel.newAnimHasBasePoseCheckbox();
        if (importFile != null) {
            this.d_clipFld.setSelectedFile(importFile.getAbsolutePath());
        }
        LinkStatus.link((AbstractButton)this.d_baseObjCheckBox, this.d_baseCB);
        LinkStatus.link2((AbstractButton)this.d_baseObjCheckBox, true, this.d_typeCB, tagsLbl, this.d_tagsFld, clipLbl, this.d_clipFld, this.d_animationHasBasePoseCB, basePoseLbl, this.d_basePoseFld);
        LinkStatus.link2((AbstractButton)this.d_animationHasBasePoseCB, true, basePoseLbl, this.d_basePoseFld);
        if (suggestedBasedOn != null && importFile == null) {
            this.d_baseObjCheckBox.setSelected(true);
            this.d_baseCB.setSelectedItem(suggestedBasedOn);
        }
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        gb.addRow(Intl.intl("Name:"), this.d_nameFld, 1.0);
        if (importFile == null) {
            gb.addRow(this.d_baseObjCheckBox, this.d_baseCB, 1.0);
        }
        gb.addRow(guiUtil.lblProp(Animation.TYPE.getDisplayName(), Animation.TYPE.getDisplayDesc()), this.d_typeCB, 1.0);
        gb.addRow(tagsLbl, this.d_tagsFld, 1.0);
        gb.addRow(clipLbl, this.d_clipFld, 1.0);
        gb.addRow(this.d_animationHasBasePoseCB, 0);
        gb.addRow(basePoseLbl, this.d_basePoseFld, 1.0);
        gb.finalizeRows();
        this.d_baseObjCheckBox.setSelected(false);
        this.d_baseObjCheckBox.requestFocusInWindow();
        this.d_nameFld.selectAll();
    }

    @Override
    public String getName() {
        return (String)this.d_nameFld.getValue();
    }

    @Override
    public Animation getBaseObject() {
        if (this.d_baseObjCheckBox.isSelected()) {
            return (Animation)this.d_baseCB.getSelectedItem();
        }
        Animation anim = new Animation();
        anim.setType(this.d_typeCB.getSelectedItem());
        anim.setTags((Set)this.d_tagsFld.getValue());
        Consumer<PropertySet> initClip = clip -> {
            clip.set(AAnimationClip.FILE, this.d_clipFld.getSelectedFile());
            AnimRetargetMode retargetMode = this.d_animationHasBasePoseCB.isSelected() ? AnimRetargetMode.SELF : AnimRetargetMode.OTHER;
            clip.set(AAnimationClip.RETARGET_MODE, retargetMode);
            if (!this.d_animationHasBasePoseCB.isSelected()) {
                clip.set(AAnimationClip.RETARGET_SOURCE, this.d_basePoseFld.getSelectedFile());
            }
        };
        switch (anim.getType()) {
            case IDLE: {
                PropertySet vals = anim.getIdleClip().getValues();
                initClip.accept(vals);
                anim.setIdleClip(new IdleAnimationClip(vals));
                break;
            }
            case MOVE: {
                anim.setDirections(Sets.fromArrayHS(AnimDirection.FORWARD));
                PropertySet vals = MoveAnimationClip.getDefaults();
                initClip.accept(vals);
                vals.set(MoveAnimationClip.NATURAL_SPEED, new UnitDouble(1.0, SI.METER.divide(SI.SECOND)));
                vals.set(MoveAnimationClip.TOP_SPEED, new UnitDouble(Double.POSITIVE_INFINITY, SI.METER.divide(SI.SECOND)));
                MoveAnimationClip clip2 = new MoveAnimationClip(vals);
                anim.setMoveClips(List.of(clip2));
                break;
            }
            case PIVOT: {
                anim.setDirections(Sets.fromArrayHS(AnimDirection.RIGHT));
                PropertySet vals = PivotAnimationClip.getDefaults();
                initClip.accept(vals);
                PivotAnimationClip clip3 = new PivotAnimationClip(vals);
                anim.setPivotClips(List.of(clip3));
                break;
            }
        }
        return anim;
    }
}

