/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.value;

import inferno.sim.occsource.AUCOccSourceFlowrate;
import inferno.sim.occsource.IOccSourceFlowrate;
import java.io.Serializable;
import java.util.Collections;
import java.util.function.UnaryOperator;
import merlin.data.property.Function1dProp;
import merlin.data.value.IFunction1d;
import merlin.data.value.ImpulseFunction1d;
import merlin.data.value.PiecewiseFunction1d;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;

public class ConstFunction1d
implements IFunction1d,
Serializable {
    static final long serialVersionUID = 1L;
    public final UnitDouble val;

    public ConstFunction1d(UnitDouble val) {
        this.val = val;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ConstFunction1d && ((ConstFunction1d)obj).val.equals(this.val);
    }

    public int hashCode() {
        return 0xF88D83EF ^ this.val.hashCode();
    }

    @Override
    public String format(UnaryOperator<Unit> getDisplayUnit) {
        return Global.format(this.val, (Unit)getDisplayUnit.apply(this.val.getUnit()), 3);
    }

    @Override
    public inferno.data2.value.IFunction1d toInfernoFunction(Unit xUnit, Unit yUnit) {
        ConstFunction1d cfunc = this;
        double val = cfunc.val.get(yUnit);
        return new inferno.data2.value.ConstFunction1d(val);
    }

    @Override
    public IOccSourceFlowrate toInfernoOccSourceFlowrate(long occSourceSeed) {
        return new AUCOccSourceFlowrate(this.toInfernoFunction(SI.SECOND, Unit.ONE.divide(SI.SECOND)));
    }

    @Override
    public PiecewiseFunction1d toPiecewise(Function1dProp prop) {
        Unit xUnit = SIUS.unit(prop.x.unitType);
        return PiecewiseFunction1d.newFunction(new UnitDouble(0.0, xUnit), this.val, new UnitDouble(1.0, xUnit), this.val);
    }

    @Override
    public ConstFunction1d toConstant(Function1dProp prop) {
        return this;
    }

    @Override
    public ImpulseFunction1d toImpulse(Function1dProp prop) {
        Unit xUnit = SIUS.unit(prop.x.unitType);
        return new ImpulseFunction1d(new UnitDouble(0.0, this.val.getUnit()), Collections.singletonList(new ImpulseFunction1d.Pulse(new UnitDouble(0.0, xUnit), new UnitDouble(Double.POSITIVE_INFINITY, xUnit), this.val)));
    }
}

