/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.stat;

import java.util.Collections;
import merlin.data.stat.AutoCurve;
import merlin.data.stat.DisabledCurve;
import merlin.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.LogNormCurve;
import thunderheadeng.util.stat.StdNormCurve;
import thunderheadeng.util.stat.UniformCurve;
import thunderheadeng.util.stat.UrnUtil;

public class CurveUtil {
    public static ConstantCurve toConstantCurve(IDistributedVal<UnitDouble> val, int unitType) {
        if (val == null || val instanceof DisabledCurve || val instanceof AutoCurve) {
            return new ConstantCurve(SIUS.newud(0.0, unitType));
        }
        if (val instanceof ConstantCurve) {
            return (ConstantCurve)val;
        }
        if (val instanceof UniformCurve) {
            UniformCurve uc = (UniformCurve)val;
            return new ConstantCurve(uc.getMax().add(uc.getMin()).scale(0.5));
        }
        if (val instanceof StdNormCurve) {
            return new ConstantCurve(((StdNormCurve)val).getAvg());
        }
        if (val instanceof LogNormCurve) {
            return new ConstantCurve(((LogNormCurve)val).getAvg());
        }
        if (val instanceof IUrn) {
            return new ConstantCurve(CurveUtil.getUrnStats((IUrn<UnitDouble>)((IUrn)val), (int)unitType).avg);
        }
        throw new RuntimeException("No conversion exists for type " + val.getClass().getName());
    }

    public static UniformCurve toUniformCurve(IDistributedVal<UnitDouble> val, int unitType) {
        if (val == null || val instanceof DisabledCurve || val instanceof AutoCurve) {
            return new UniformCurve(SIUS.newud(0.0, unitType), SIUS.newud(0.0, unitType));
        }
        if (val instanceof ConstantCurve) {
            ConstantCurve cc = (ConstantCurve)val;
            return new UniformCurve(cc.getMax(), cc.getMax());
        }
        if (val instanceof UniformCurve) {
            return (UniformCurve)val;
        }
        if (val instanceof StdNormCurve) {
            StdNormCurve snc = (StdNormCurve)val;
            return new UniformCurve(snc.getMin(), snc.getMax());
        }
        if (val instanceof LogNormCurve) {
            LogNormCurve lc = (LogNormCurve)val;
            return new UniformCurve(lc.getMin(), lc.getMax());
        }
        if (val instanceof IUrn) {
            UrnUtil.UrnStats urnStats = CurveUtil.getUrnStats((IUrn)val, unitType);
            return new UniformCurve(urnStats.min, urnStats.max);
        }
        throw new RuntimeException("No conversion exists for type " + val.getClass().getName());
    }

    public static StdNormCurve toStdNormCurve(IDistributedVal<UnitDouble> val, int unitType) {
        if (val == null || val instanceof DisabledCurve || val instanceof AutoCurve) {
            UnitDouble zero = SIUS.newud(0.0, unitType);
            return new StdNormCurve(zero, zero, zero, zero);
        }
        if (val instanceof ConstantCurve) {
            ConstantCurve cc = (ConstantCurve)val;
            return new StdNormCurve(cc.getMax(), cc.getMax(), cc.getMax(), SIUS.newud(0.0, unitType));
        }
        if (val instanceof UniformCurve) {
            UniformCurve uc = (UniformCurve)val;
            return new StdNormCurve(uc.getMin(), uc.getMax(), uc.getMax().add(uc.getMin()).scale(0.5), uc.getMax().sub(uc.getMin()).scale(0.16666666666666666));
        }
        if (val instanceof StdNormCurve) {
            return (StdNormCurve)val;
        }
        if (val instanceof LogNormCurve) {
            LogNormCurve lc = (LogNormCurve)val;
            return new StdNormCurve(lc.getMin(), lc.getMax(), lc.getAvg(), lc.getStdDev());
        }
        if (val instanceof IUrn) {
            UrnUtil.UrnStats urnStats = CurveUtil.getUrnStats((IUrn)val, unitType);
            return new StdNormCurve(urnStats.min, urnStats.max, urnStats.max.add(urnStats.min).scale(0.5), urnStats.max.sub(urnStats.min).scale(0.16666666666666666));
        }
        throw new RuntimeException("No conversion exists for type " + val.getClass().getName());
    }

    public static LogNormCurve toLogNormCurve(IDistributedVal<UnitDouble> val, int unitType) {
        if (val == null || val instanceof DisabledCurve || val instanceof AutoCurve) {
            UnitDouble zero = SIUS.newud(0.0, unitType);
            return new LogNormCurve(zero, zero, zero, zero);
        }
        if (val instanceof ConstantCurve) {
            ConstantCurve cc = (ConstantCurve)val;
            return new LogNormCurve(cc.getMax(), cc.getMax(), cc.getMax(), SIUS.newud(0.0, unitType));
        }
        if (val instanceof UniformCurve) {
            UniformCurve uc = (UniformCurve)val;
            return new LogNormCurve(uc.getMin(), uc.getMax(), uc.getMax().add(uc.getMin()).scale(0.5), uc.getMax().sub(uc.getMin()).scale(0.16666666666666666));
        }
        if (val instanceof StdNormCurve) {
            StdNormCurve sc = (StdNormCurve)val;
            return new LogNormCurve(sc.getMin(), sc.getMax(), sc.getAvg(), sc.getStdDev());
        }
        if (val instanceof LogNormCurve) {
            return (LogNormCurve)val;
        }
        if (val instanceof IUrn) {
            UrnUtil.UrnStats urnStats = CurveUtil.getUrnStats((IUrn)val, unitType);
            return new LogNormCurve(urnStats.min, urnStats.max, urnStats.max.add(urnStats.min).scale(0.5), urnStats.max.sub(urnStats.min).scale(0.16666666666666666));
        }
        throw new RuntimeException("No conversion exists for type " + val.getClass().getName());
    }

    public static IUrn<UnitDouble> toDiscreteCurve(IDistributedVal<UnitDouble> val, int unit) {
        if (val instanceof IUrn) {
            return (IUrn)val;
        }
        ConstantCurve cc = CurveUtil.toConstantCurve(val, unit);
        return UrnUtil.newUrn(Collections.singletonMap(cc.getAvg(), 1.0));
    }

    public static UrnUtil.UrnStats getUrnStats(IUrn<UnitDouble> urn, int unitType) {
        return UrnUtil.getUrnStats(urn, () -> new UrnUtil.UrnStats(SIUS.newud(0.0, unitType), SIUS.newud(0.0, unitType), SIUS.newud(0.0, unitType)));
    }
}

