/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.scenario;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import merlin.actions.InfernoUtil;
import merlin.data.scenario.ScenarioUtil;
import thunderheadeng.gui.Application;

public class SimOutputDir {
    private final SimOutputDesc d_desc;
    public final ResolvedOutputDir current;
    public final List<ResolvedOutputDir> legacies;

    public SimOutputDir(String pthFileName, String scenarioName, int scenarioCount, int variationIndex, int variationCount) throws IOException {
        try {
            this.d_desc = new SimOutputDesc(pthFileName, scenarioName, scenarioCount, variationIndex, variationCount);
            Path kbOutputDir = Path.of(Application.getTempAppDataDir(), new String[0]);
            this.current = SimOutputDir.resolve2025_1Output(this.d_desc, kbOutputDir);
            ArrayList legacyDirs = new ArrayList();
            Consumer<BiFunction> tryLegacyDir = resolver -> {
                ResolvedOutputDir resolved = (ResolvedOutputDir)resolver.apply(this.d_desc, kbOutputDir);
                if (resolved != null) {
                    legacyDirs.add(resolved);
                }
            };
            tryLegacyDir.accept(SimOutputDir::resolve2024_2Output);
            tryLegacyDir.accept(SimOutputDir::resolvePre2024_2Output);
            this.legacies = Collections.unmodifiableList(legacyDirs);
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    public String pthFileName() {
        return this.d_desc.pthFileName;
    }

    public String scenarioName() {
        return this.d_desc.scenarioName;
    }

    public int scenarioCount() {
        return this.d_desc.scenarioCount;
    }

    public int variationIndex() {
        return this.d_desc.variationIndex;
    }

    public int variationCount() {
        return this.d_desc.variationCount;
    }

    private static ResolvedOutputDir resolve2025_1Output(SimOutputDesc desc, Path kbOutputDir) {
        Path pthParentPath = Paths.get(desc.pthFileName, new String[0]).getParent();
        Path pthBaseName = Path.of(InfernoUtil.rootFn(desc.pthFileName), new String[0]);
        String scenarioDirName = ScenarioUtil.scenarioDirectoryName(desc.scenarioName);
        Path scenarioDir = desc.scenarioCount > 1 ? pthParentPath.resolve(pthBaseName).resolve(String.format("%s_%s", pthBaseName, scenarioDirName)) : pthParentPath.resolve(pthBaseName);
        Path variationDir = desc.variationCount > 1 ? scenarioDir.resolve(String.format("%s_%s_%d", pthBaseName, scenarioDirName, desc.variationIndex + 1)) : scenarioDir;
        Path visFilePath = scenarioDir.resolve(scenarioDir.getFileName().toString() + ".pfrv");
        return new ResolvedOutputDir(variationDir, variationDir.getFileName(), scenarioDir.getFileName(), visFilePath, kbOutputDir);
    }

    private static ResolvedOutputDir resolve2024_2Output(SimOutputDesc desc, Path kbOutputDir) {
        if (desc.variationCount > 1) {
            return null;
        }
        Path pthParentPath = Paths.get(desc.pthFileName, new String[0]).getParent();
        Path pthBaseName = Path.of(InfernoUtil.rootFn(desc.pthFileName), new String[0]);
        String scenarioDirName = ScenarioUtil.scenarioDirectoryName(desc.scenarioName);
        Path scenarioDir = desc.scenarioCount > 1 ? pthParentPath.resolve(pthBaseName).resolve(scenarioDirName) : pthParentPath.resolve(pthBaseName);
        Path visFilePath = scenarioDir.resolve(String.valueOf(pthBaseName) + ".pfrv");
        return new ResolvedOutputDir(scenarioDir, pthBaseName, pthBaseName, visFilePath, kbOutputDir);
    }

    private static ResolvedOutputDir resolvePre2024_2Output(SimOutputDesc desc, Path kbOutputDir) {
        if (desc.scenarioCount > 1 || desc.variationCount > 1) {
            return null;
        }
        Path outpurDir = Paths.get(desc.pthFileName, new String[0]).getParent();
        Path outputFileBasename = Paths.get(InfernoUtil.rootFn(desc.pthFileName), new String[0]);
        Path visFilePath = outpurDir.resolve(String.valueOf(outputFileBasename) + ".pfrv");
        return new ResolvedOutputDir(outpurDir, outputFileBasename, outputFileBasename, visFilePath, kbOutputDir);
    }

    private record SimOutputDesc(String pthFileName, String scenarioName, int scenarioCount, int variationIndex, int variationCount) {
    }

    public record ResolvedOutputDir(Path outputDir, Path outputFileBasename, Path sharedOutputFileBasename, Path visualizationFile, Path kbOutputDir) {
        public Path getFilePath(Path suffix) {
            return this.outputDir.resolve(this.outputFileBasename.toString() + suffix.toString());
        }

        public Path getSnapshotFile() {
            return this.getFilePath(Path.of(".snapshot", new String[0]));
        }

        public Path getResultsFile() {
            return this.getFilePath(Path.of(".pfr", new String[0]));
        }

        public Path getKBPath() {
            return this.kbOutputDir.resolve(this.outputFileBasename.toString() + ".kb");
        }

        public Path getEquivalentPthFile() {
            return this.outputDir.getParent().resolve(this.outputDir.getFileName().toString() + ".pth");
        }
    }
}

