/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.scenario;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.data.scenario.Scenario;
import merlin.data.scenario.ScenarioUtil;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.framework.UndoFramework;
import thunderheadeng.gui.framework.property.CompositeProp;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.IDisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;

public class ScenarioRoot
extends Composite<Scenario>
implements IDirectDependent<MerlinData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<ScenarioRoot> LOCAL_PROPS = PropertyDefs.defsInheritStorageAndProps(ScenarioRoot.class, null, Composite.PROP_TYPES);
    static final TypedProp<Set<IMerlinObj>> CHILDREN = Composite.CHILDREN;
    public static final DisplayProp<Scenario> ACTIVE_SCENARIO = ((TeciDisplayProps.Builder)DisplayProps.build((Object)"ACTIVE_SCENARIO", Scenario.class, null, Intl.intl("Active Scenario"), Intl.intl("Specifies the active scenario")).attrFormatValue(s -> s.getName())).attrStoreAsPlainOldData(LOCAL_PROPS).attrSetter(ScenarioRoot::setActive, (obj, val) -> {
        obj.d_activeScenario = val;
    }).attrGetter(ScenarioRoot::getActive, Stream.empty()).attrCloneValue((obj, val) -> null).attrRestoreValue((obj, val) -> val).attrDependency(prop -> Dependencies.newDependency(prop, DLink.WEAK, Scenario.class, (md, src, scenario) -> Stream.of(scenario), Predicates.alwaysTrue(), (md, src, val, old, replacement) -> {
        assert (old == src.d_activeScenario);
        return replacement != null ? replacement : src.d_default;
    })).attrFinish();
    static final TypedProp<Scenario> DEFAULT_SCENARIO = TypedProps.build((Object)"ScenarioRoot.DEFAULT_SCENARIO", Scenario.class).attrStoreAsPlainOldData(LOCAL_PROPS).attrGetter(obj -> obj.d_default, Stream.empty()).attrSetter((obj, val) -> {
        obj.d_default = val;
    }, null).attrCloneValue((obj, val) -> null).attrRestoreValue((obj, val) -> val).attrFinish();
    @SkipDep
    private Scenario d_default;
    @SkipDep
    private Scenario d_activeScenario;
    private transient boolean d_updateLock = false;
    private static final Predicate<IMerlinObj> s_filter = new TypeFilter<IMerlinObj>(Scenario.class);

    public ScenarioRoot() {
        super(Intl.intl("Scenarios"));
        this.setActive(this.addDefault());
    }

    public ScenarioRoot(String name) {
        super(name);
    }

    @Override
    public boolean getScenariosSupported() {
        return false;
    }

    public <ObjT extends IMerlinObj, ValT> PropValue<ValT> getDefaultScenarioValue(ObjT obj, IDisplayProp<ValT> prop) {
        PropValue<ValT> val;
        if (!this.d_activeScenario.isDefault() && (val = this.d_default.getObjValue(obj, prop)).isSupported()) {
            return val;
        }
        PropValue<ValT> optVal = obj.getWithDetails(prop.asProp());
        if (optVal.isEmpty()) {
            return PropValue.unsupported();
        }
        return optVal;
    }

    public <ObjT extends IMerlinObj, ValT> PropValue<ScenarioValue<ValT>> getScenarioValue(Scenario scenario, ObjT obj, IDisplayProp<ValT> prop) {
        if (scenario.isDefault()) {
            PropValue<ValT> val = this.getDefaultScenarioValue(obj, prop);
            if (!val.isSupported()) {
                return PropValue.unsupported();
            }
            return PropValue.of(new ScenarioValue<ValT>(true, val.get()));
        }
        if (!scenario.isOverridden(obj, prop)) {
            PropValue<ScenarioValue<ValT>> defVal = this.getScenarioValue(this.getDefault(), obj, prop);
            return defVal.isSupported() ? PropValue.of(new ScenarioValue(false, defVal.get().value)) : PropValue.unsupported();
        }
        PropValue<ValT> val = scenario.getObjValue(obj, prop);
        return val.isSupported() ? PropValue.of(new ScenarioValue<ValT>(true, val.get())) : PropValue.unsupported();
    }

    public <ObjT extends IMerlinObj, ValT> void setDefaultScenarioValue(ObjT obj, IDisplayProp<ValT> prop, ValT value) {
        if (!this.d_activeScenario.isDefault() && this.d_activeScenario.isOverridden(obj, prop)) {
            this.d_default.setObjValue(obj, prop, value);
            return;
        }
        obj.set(prop.asProp(), value);
    }

    public <ObjT extends IMerlinObj, ValT> boolean setScenarioValue(Scenario scenario, ObjT obj, IDisplayProp<ValT> prop, ValT value) {
        if (!scenario.isDefault() && !scenario.isOverridden(obj, prop)) {
            return false;
        }
        if (scenario.isDefault()) {
            this.setDefaultScenarioValue(obj, prop, value);
            return true;
        }
        scenario.setObjValue(obj, prop, value);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(Scenario scenario) {
        if (this.d_activeScenario == scenario) {
            return;
        }
        this.pauseUpdates();
        assert (!this.d_updateLock);
        this.d_updateLock = true;
        try {
            this.d_activeScenario = scenario;
            this.changedEvt(ACTIVE_SCENARIO);
            if (scenario.isDefault()) {
                for (IMerlinObj obj : scenario.getCustomizedObjects()) {
                    scenario.streamCustomVals(obj).forEach(entry -> obj.set(entry.prop().asProp(), entry.val()));
                }
                scenario.clearAllObjValues();
            } else {
                record ObjPropVal(IMerlinObj obj, IDisplayProp prop, Object val) {
                }
                ArrayList moveToDefault = new ArrayList();
                for (IMerlinObj obj : scenario.getCustomizedObjects()) {
                    scenario.streamCustomVals(obj).forEach(entry -> {
                        PropValue objVal;
                        IDisplayProp prop = entry.prop();
                        if (!this.d_default.isObjValueDefined(obj, prop) && (objVal = obj.getWithDetails(prop.asProp())).isPresent()) {
                            Object toStore = objVal.get();
                            moveToDefault.add(new ObjPropVal(obj, prop, toStore));
                        }
                    });
                }
                ArrayList clearFromDefault = new ArrayList();
                for (IMerlinObj obj : this.d_default.getCustomizedObjects()) {
                    this.d_default.streamCustomVals(obj).forEach(entry -> {
                        IDisplayProp prop = entry.prop();
                        if (!scenario.isObjValueDefined(obj, prop)) {
                            obj.set(prop.asProp(), entry.val());
                            clearFromDefault.add(new Pair(obj, prop));
                        }
                    });
                }
                clearFromDefault.stream().forEach(p -> this.d_default.clearObjValue((IMerlinObj)p.v1, (IDisplayProp)p.v2));
                moveToDefault.forEach(v -> this.d_default.setObjValue(v.obj, v.prop, v.val));
                for (IMerlinObj obj : scenario.getCustomizedObjects()) {
                    scenario.streamCustomVals(obj).forEach(entry -> {
                        IDisplayProp prop = entry.prop();
                        obj.set(prop.asProp(), entry.val());
                    });
                }
            }
        }
        finally {
            this.d_updateLock = false;
            this.resumeUpdates();
        }
    }

    public Scenario getActive() {
        return this.d_activeScenario;
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return LOCAL_PROPS;
    }

    public void notifyObjModified(IMerlinObj obj, Object[] changes) {
        boolean isGenericChange;
        if (this.d_updateLock || this.d_activeScenario.isDefault()) {
            return;
        }
        if (!this.d_activeScenario.isOverridden(obj)) {
            return;
        }
        BiConsumer<IDisplayProp, Boolean> updateProp = (overrideProp, expectPresent) -> {
            Object toStore;
            PropValue objVal = obj.getWithDetails(overrideProp.asProp());
            if (objVal.isPresent()) {
                toStore = objVal.get();
            } else {
                assert (!expectPresent.booleanValue()) : String.format("The property, %s, was customized in scenario %s, but isn't supported by %s.", overrideProp.asProp().key, this.d_activeScenario.getName(), obj.getClass().getSimpleName());
                toStore = overrideProp.asProp().defVal;
            }
            this.d_activeScenario.setObjValue(obj, overrideProp, toStore);
        };
        boolean bl = isGenericChange = changes.length == 0 || Stream.of(changes).anyMatch(c -> c == EventChannel.EVT_GENERAL);
        if (isGenericChange) {
            this.d_activeScenario.streamCustomProps(obj).toList().forEach(prop -> updateProp.accept((IDisplayProp)prop, false));
        } else {
            Stream.of(changes).map(change -> ScenarioUtil.asScenarioProp(change)).filter(sprop -> sprop.isPresent()).map(sprop -> (IDisplayProp)sprop.get()).filter(sprop -> this.d_activeScenario.isOverridden(obj, sprop)).forEach(prop -> updateProp.accept((IDisplayProp)prop, true));
        }
    }

    public Stream<? extends IDisplayProp<?>> streamActiveOverrides(IMerlinObj obj) {
        return this.d_activeScenario.streamCustomProps(obj);
    }

    public boolean anyOverriden(Collection<? extends IDomainObject> objs) {
        Collection<Scenario> scenarios = this.flatten(Scenario.class);
        Collection<IMerlinObj> flattenedObjs = MerlinUtil.flatten(objs, IMerlinObj.class);
        return scenarios.stream().filter(scenario -> !scenario.isDefault()).anyMatch(scenario -> flattenedObjs.stream().anyMatch(scenario::isOverridden));
    }

    public boolean setOverrides(MerlinData md, IMerlinObj obj, Collection<? extends IDisplayProp<?>> overrides) {
        if (this.d_activeScenario.isDefault()) {
            return false;
        }
        this.setOverrides(md, obj, Map.of(this.d_activeScenario, overrides));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverrides(MerlinData md, IMerlinObj obj, Map<Scenario, ? extends Collection<? extends IDisplayProp<?>>> scenarioOverrides) {
        assert (scenarioOverrides.values().stream().noneMatch(prop -> prop instanceof CompositeProp));
        this.pauseUpdates();
        assert (!this.d_updateLock);
        this.d_updateLock = true;
        try {
            ArrayList<ScenarioChange> scenarioChanges = new ArrayList<ScenarioChange>();
            ArrayList newObjVals = new ArrayList();
            for (Map.Entry<Scenario, Collection<IDisplayProp<?>>> scenarioEntry : scenarioOverrides.entrySet()) {
                Scenario scenario = scenarioEntry.getKey();
                if (scenario.isDefault()) continue;
                Collection<IDisplayProp<?>> overrides = scenarioEntry.getValue();
                scenario.streamCustomProps(obj).forEach(prop -> {
                    PropValue defVal;
                    if (overrides.contains(prop)) {
                        return;
                    }
                    scenarioChanges.add(new ScenarioChange(scenario, (IDisplayProp<?>)prop, PropValue.unsupported()));
                    if (this.d_activeScenario == scenario && (defVal = this.d_default.getObjValue(obj, prop)).isSupported()) {
                        newObjVals.add(new Pair((IDisplayProp)prop, defVal.get()));
                        scenarioChanges.add(new ScenarioChange(this.d_default, (IDisplayProp<?>)prop, PropValue.unsupported()));
                    }
                });
                for (IDisplayProp<?> overrideProp : overrides) {
                    if (scenario.isObjValueDefined(obj, overrideProp)) continue;
                    PropValue<?> objVal = obj.getWithDetails(overrideProp.asProp());
                    PropValue<Object> newVal = PropValue.of(objVal.map(val -> val).orElse(overrideProp.asProp().defVal));
                    scenarioChanges.add(new ScenarioChange(scenario, overrideProp, newVal));
                    if (this.d_activeScenario != scenario) continue;
                    scenarioChanges.add(new ScenarioChange(this.d_default, overrideProp, newVal));
                }
            }
            if (!scenarioChanges.isEmpty()) {
                Undo.insertEntry(md, new ApplyScenarioOverrides(obj, scenarioChanges).perform());
            }
            if (!newObjVals.isEmpty()) {
                List<TypedProp> toRestore = theUtil.map(newObjVals, p -> ((IDisplayProp)p.v1).asProp());
                Undo.insertUndoEntry_propRestore(md, obj, toRestore);
                newObjVals.stream().forEach(pair -> obj.set(((IDisplayProp)pair.v1).asProp(), pair.v2));
            }
        }
        finally {
            this.d_updateLock = false;
            this.resumeUpdates();
        }
    }

    public Scenario getDefault() {
        return this.d_default;
    }

    private Scenario addDefault() {
        Scenario def = new Scenario();
        this.add(def);
        assert (this.d_default == def);
        return def;
    }

    @Override
    public void clear() {
        this.pauseUpdates();
        this.d_default = null;
        this.d_activeScenario = null;
        super.clear();
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    @Override
    public boolean canRemove(IMerlinObj obj) {
        return obj != this.d_activeScenario;
    }

    @Override
    public boolean remove(IMerlinObj obj) {
        Scenario scenario;
        assert (obj != this.d_activeScenario) : "The active scenario must not be removed without using the dependency system.";
        if (obj instanceof Scenario && (scenario = (Scenario)obj).isDefault()) {
            if (scenario != this.d_default) {
                assert (false) : "Trying to remove a default scenario that is not currently the registered default.";
                return false;
            }
            this.d_default = null;
        }
        return super.remove(obj);
    }

    @Override
    public void add(IMerlinObj obj) {
        this.checkForAdd(obj);
        super.add(obj);
    }

    public void insert(Scenario[] objs, int[] insertPositions) {
        Stream.of(objs).forEach(this::checkForAdd);
        super.insert((IMerlinObj[])objs, insertPositions);
    }

    @Override
    public void insert(Collection<? extends IMerlinObj> objs, int insertPos) {
        objs.forEach(this::checkForAdd);
        super.insert(objs, insertPos);
    }

    private void checkForAdd(IMerlinObj obj) {
        Scenario scenario;
        if (obj instanceof Scenario && (scenario = (Scenario)obj).isDefault()) {
            assert (this.d_default == null || this.d_default == scenario) : "Trying to add a default scenario when there is already one defined.";
            this.d_default = scenario;
        }
    }

    @Override
    protected void restoreFromLoad(Composite<Scenario> restoreObj) {
        assert (restoreObj instanceof ScenarioRoot);
        if (restoreObj instanceof ScenarioRoot) {
            ScenarioRoot root = (ScenarioRoot)restoreObj;
            this.pauseUpdates();
            this.d_activeScenario = null;
            super.restoreFrom(restoreObj);
            this.d_default = root.d_default;
            this.d_activeScenario = root.d_activeScenario;
            this.changedEvt(ACTIVE_SCENARIO);
            this.resumeUpdates();
        }
    }

    @Override
    public Predicate<IMerlinObj> getFilter() {
        return s_filter;
    }

    @Override
    public boolean canAddGroup() {
        return false;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return new ScenarioRoot(name);
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Scenario Group");
    }

    @Override
    public void reset() {
        this.pauseUpdates();
        super.reset();
        this.setActive(this.addDefault());
        this.resumeUpdates();
    }

    public boolean purgeLegacyPropReferences(MerlinData md, Collection<? extends IMerlinObj> objs, IDisplayProp<?> prop) {
        boolean modelChanged = false;
        for (Scenario scenario : md.scenarios.flatten(Scenario.class)) {
            for (IMerlinObj iMerlinObj : objs) {
                modelChanged |= scenario.clearObjValue(iMerlinObj, prop);
            }
        }
        return modelChanged;
    }

    public record ScenarioValue<ValT>(boolean customized, ValT value) {
    }

    private record ScenarioChange(Scenario scenario, IDisplayProp<?> prop, PropValue<?> val) {
    }

    private record ApplyScenarioOverrides(IMerlinObj obj, List<ScenarioChange> scenarioChanges) implements UndoFramework.UndoOp
    {
        @Override
        public boolean isMajor() {
            return true;
        }

        @Override
        public UndoFramework.UndoOp perform() {
            List<ScenarioChange> restoreChanges = this.scenarioChanges.stream().map(scenarioChange -> {
                PropValue<?> restoreVal = scenarioChange.scenario.getObjValue(this.obj, scenarioChange.prop);
                return new ScenarioChange(scenarioChange.scenario, scenarioChange.prop, restoreVal);
            }).toList();
            for (ScenarioChange scenarioChange2 : this.scenarioChanges) {
                if (!scenarioChange2.val.isSupported()) {
                    scenarioChange2.scenario.clearObjValue(this.obj, scenarioChange2.prop);
                    continue;
                }
                scenarioChange2.scenario.setObjValue(this.obj, scenarioChange2.prop, scenarioChange2.val.get());
            }
            return new ApplyScenarioOverrides(this.obj, restoreChanges);
        }
    }
}

