/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.property;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.ObjsFilter;
import merlin.data.egress.Floor;
import merlin.data.egress.agents.IAvatar;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.material.Material;
import merlin.gui.MerlinComboBox;
import merlin.gui.ObjSources;
import merlin.gui.SetChooser;
import merlin.unitsystem.UnitSystem;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.framework.property.IPropComparisonEditorSupplier;
import thunderheadeng.gui.framework.property.ISimplePropComparisonEd;
import thunderheadeng.gui.framework.property.PropComparisonsFramework;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.value.IVariant;

public class PropComparisons
extends PropComparisonsFramework<MerlinData, IMerlinObj> {
    private static final PropComparisons s_instance = new PropComparisons();

    public static PropComparisons factory() {
        return s_instance;
    }

    public IPropComparisonEditorSupplier<MerlinData, IMerlinObj, UnitDouble> unitdouble(int unitType) {
        return this.unitdouble(() -> UnitSystem.getType(unitType, true));
    }

    public IPropComparisonEditorSupplier<MerlinData, IMerlinObj, UnitPoint3D> unitPoint3D(int unitType) {
        return this.unitPoint3D(() -> UnitSystem.getType(unitType, true));
    }

    public <RefT extends IMerlinObj> IPropComparisonEditorSupplier<MerlinData, IMerlinObj, RefT> singleObj(ObjSrcSupplier<RefT> source) {
        return this.singleObj(source, vd -> new MerlinComboBox((MerlinData)vd, source.get(vd)), this.getMultiChooser(source), null);
    }

    public <RefT extends IMerlinObj> IPropComparisonEditorSupplier<MerlinData, IMerlinObj, RefT> singleObj(ObjSrcSupplier<RefT> source, RefT nullOption) {
        return this.singleObj(source, vd -> new MerlinComboBox((MerlinData)vd, source.get(vd)), this.getMultiChooser(source), nullOption);
    }

    public <RefT> IPropComparisonEditorSupplier<MerlinData, IMerlinObj, Collection<? extends RefT>> multiObj(ObjSrcSupplier<RefT> source) {
        return this.multiObj(source, this.getMultiChooser(source));
    }

    public <RefT> Function<MerlinData, ? extends IValEditor<Set<RefT>>> getMultiChooser(ObjSrcSupplier<RefT> source) {
        return vd -> new SetChooser((MerlinData)vd, Intl.intl("Select Objects"), Intl.intl("Invalid Selection"), 1, source.get(vd));
    }

    public IPropComparisonEditorSupplier<MerlinData, IMerlinObj, IDistributedVal<UnitDouble>> curve(int unitType) {
        return this.curve(() -> UnitSystem.getType(unitType, true));
    }

    public IPropComparisonEditorSupplier<MerlinData, IMerlinObj, IDistributedVal<UnitDouble>> distributedValue(int unitType) {
        return this.distributedValue(() -> UnitSystem.getType(unitType, true));
    }

    public <RefT extends IMerlinObj> IPropComparisonEditorSupplier<MerlinData, IMerlinObj, IUrn<RefT>> objUrn(ObjSrcSupplier<RefT> source) {
        return this.objUrn(vd -> new MerlinComboBox((MerlinData)vd, source.get(vd)), () -> UnitSystem.getType(10, true));
    }

    public IPropComparisonEditorSupplier<MerlinData, IMerlinObj, IVariant<UnitDouble>> udVariant(int unitType) {
        return this.udVariant(() -> UnitSystem.getType(unitType, true));
    }

    public <RefT extends IMerlinObj> IPropComparisonEditorSupplier<MerlinData, IMerlinObj, ObjsFilter<RefT>> objsFilter(ObjSrcSupplier<RefT> source) {
        return (parent, md) -> new ObjsFilterCompare((MerlinData)md, source, new SetChooser((MerlinData)md, Intl.intl("Select Objects"), Intl.intl("None"), 1, source.get(md)));
    }

    public static ObjSrcSupplier<Floor> getFloorSrc(String nullName) {
        return vd -> ObjSources.getFloors(vd, nullName);
    }

    public static ObjSrcSupplier<IEgressOccupiable> getRoomSrc(String nullName) {
        return vd -> ObjSources.getRooms(vd, nullName);
    }

    public static ObjSrcSupplier<Material> getMaterialSrc(String nullName) {
        return vd -> ObjSources.getMaterials(vd, nullName);
    }

    public static ObjSrcSupplier<IAvatar> getAvatarSrc(ResourceAvatar.Type type, String nullName) {
        return vc -> ObjSources.getAvatars(type, nullName);
    }

    public static interface ObjSrcSupplier<RefT>
    extends PropComparisonsFramework.ObjSrcSupplier<MerlinData, RefT> {
    }

    private static class ObjsFilterCompare<RefT>
    extends guiPanel
    implements ISimplePropComparisonEd<IMerlinObj, ObjsFilter<RefT>> {
        private static final long serialVersionUID = 1L;
        protected final guiComboBox<Query> d_queryCb;
        private MerlinData d_md;
        private final ObjSrcSupplier<RefT> d_source;
        private final IValEditor<Set<RefT>> d_compareMulti;

        public ObjsFilterCompare(MerlinData md, ObjSrcSupplier<RefT> source, IValEditor<Set<RefT>> multiEd) {
            this.d_md = md;
            this.d_source = source;
            this.d_queryCb = guiUtil.newCombo(c -> new Pair<String, Object>(c.desc, null), Query.values());
            IValEditor<Set<RefT>> iValEditor = this.d_compareMulti = multiEd;
            if (iValEditor instanceof IEventObserver) {
                IEventObserver obs = (IEventObserver)((Object)iValEditor);
                md.getEvents().removeObserver(obs);
            }
            GridBagHelper gb = new GridBagHelper(this);
            gb.add(this.d_queryCb, this.d_compareMulti);
            gb.finalizeRows();
        }

        @Override
        public Predicate<? super ObjsFilter> getSimplePredicate() {
            if (this.d_queryCb.getSelectedItem() == Query.EXACTLY) {
                Set allObjs = this.d_source.get(this.d_md).getObjs().get().collect(Collectors.toSet());
                HashSet remainderObjs = new HashSet(allObjs);
                remainderObjs.removeAll((Collection)this.d_compareMulti.getValue());
                return filter -> {
                    if (filter.mode == ObjsFilter.Mode.ALL) {
                        return remainderObjs.isEmpty();
                    }
                    if (filter.mode == ObjsFilter.Mode.NONE) {
                        return this.d_compareMulti.getValue().isEmpty();
                    }
                    if (this.d_compareMulti.getValue().isEmpty()) {
                        return !filter.rejected && filter.objects.isEmpty() || filter.rejected && filter.objects.containsAll(allObjs);
                    }
                    return this.d_compareMulti.getValue().stream().allMatch(o -> filter.test(o)) && remainderObjs.stream().noneMatch(o -> filter.test(o));
                };
            }
            if (this.d_compareMulti.getValue().isEmpty()) {
                return Predicates.alwaysFalse();
            }
            Query query = this.d_queryCb.getSelectedItem();
            return filter -> query.test.test((ObjsFilter)filter, this.d_compareMulti.getValue());
        }

        @Override
        public guiPanel getUi() {
            return this;
        }

        @Override
        public void update(Events events) {
            IValEditor<Set<RefT>> iValEditor = this.d_compareMulti;
            if (iValEditor instanceof IEventObserver) {
                IEventObserver obsv = (IEventObserver)((Object)iValEditor);
                obsv.update(events);
            }
        }

        private static final class Query
        extends Enum<Query> {
            public static final /* enum */ Query EXACTLY = new Query(Intl.intl("accepts exactly"), (filter, stuff) -> {
                assert (false);
                return false;
            });
            public static final /* enum */ Query ANY = new Query(Intl.intl("accepts any"), (filter, stuff) -> filter.mode == ObjsFilter.Mode.ALL || stuff.stream().anyMatch(thing -> filter.test(thing)));
            public static final /* enum */ Query ALL = new Query(Intl.intl("accepts all"), (filter, stuff) -> filter.mode == ObjsFilter.Mode.ALL || stuff.stream().allMatch(thing -> filter.test(thing)));
            public static final /* enum */ Query NONE = new Query(Intl.intl("accepts none"), (filter, stuff) -> filter.mode == ObjsFilter.Mode.NONE || stuff.stream().noneMatch(thing -> filter.test(thing)));
            public final String desc;
            public final BiPredicate<ObjsFilter, Collection> test;
            private static final /* synthetic */ Query[] $VALUES;

            public static Query[] values() {
                return (Query[])$VALUES.clone();
            }

            public static Query valueOf(String name) {
                return Enum.valueOf(Query.class, name);
            }

            private Query(String desc, BiPredicate<ObjsFilter, Collection> test) {
                this.desc = desc;
                this.test = test;
            }

            private static /* synthetic */ Query[] $values() {
                return new Query[]{EXACTLY, ANY, ALL, NONE};
            }

            static {
                $VALUES = Query.$values();
            }
        }
    }
}

