/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.montecarlo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import merlin.Intl;
import merlin.data.AMerlinObj;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.egress.agents.OccProfile;
import merlin.data.montecarlo.VariationOccFilter;
import merlin.data.montecarlo.VariationPositionDistribution;
import merlin.data.montecarlo.VariationProfileRule;
import merlin.data.montecarlo.VariationRoomRule;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.util.Dependencies;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.framework.property.CompositeProp;
import thunderheadeng.gui.framework.property.CompositeProps;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.InfiniteUrn;

public class MonteCarlo
extends AMerlinObj
implements Serializable,
IDirectDependent<MerlinData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<MonteCarlo> PROPS = PropertyDefs.defsRoot(MonteCarlo.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
    }));
    public static final DisplayProp<Integer> VARIATION_COUNT = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"MonteCarlo.VARIATION_COUNT", 1, Intl.intl("Variation Count"), Intl.intl("The number of variations to generate.\nIf this is 1, no randomization will be performed.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROPS).attrFinish();
    public static final DisplayProp<Boolean> RANDOMIZE_POSITIONS = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"MonteCarlo.RANDOMIZE_POSITIONS", true, Intl.intl("Randomize Positions"), Intl.intl("Whether to randomize occupant positions by default.\nThis may be overridden by Occupant Filters.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROPS).attrFinish();
    public static final DisplayProp<Boolean> RANDOMIZE_PROPERTIES = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"MonteCarlo.RANDOMIZE_PROPERTIES", true, Intl.intl("Randomize Profile Properties"), Intl.intl("Whether to randomize occupant properties by default.\nThis may be overridden by Occupant Filters.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROPS).attrFinish();
    public static final DisplayProp<Boolean> RANDOMIZE_PROFILES = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"MonteCarlo.RANDOMIZE_PROFILES", true, Intl.intl("Randomize Profiles"), Intl.intl("Whether to randomize occupant profiles by default.\nThis may be overridden by Occupant Filters.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROPS).attrFinish();
    public static final DisplayProp<VariationProfileRule> PROFILE_RULE = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"MonteCarlo.PROFILE_RULE", VariationProfileRule.class, VariationProfileRule.SHUFFLE_EXISTING, Intl.intl("Profile Rule"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(VariationProfileRule::getName)).attrStoreAsPlainOldData(PROPS).attrFinish();
    public static final DisplayProp<IUrn<OccProfile>> PROFILE_DIST = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("MonteCarlo.PROFILE_DIST", IUrn.class, null, Intl.intl("Profile Distribution"), Intl.intl("The distribution of profiles for occupants whose profiles are randomized.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(dist -> dist.format2(OccProfile::getName))).attrStoreAsPlainOldData(PROPS).attrDependency(prop -> Dependencies.newDependency(prop, DLink.WEAK, OccProfile.class, (md, src, urn) -> urn.stream(), Predicates.alwaysTrue(), (md, src, urn, old, repl) -> {
        if (repl == null) {
            repl = md.profiles.NO_CHANGE;
        }
        return Dependencies.replaceUrnValue(urn, old, repl);
    })).attrFinish();
    public static final CompositeProp TARGET_PROFILES = (CompositeProp)((CompositeProps.CompositePropBuilder)CompositeProps.build(Intl.intl("Target Profiles"), "", PROFILE_RULE, PROFILE_DIST).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsComposite(PROPS).attrFinish();
    public static final DisplayProp<List<VariationOccFilter>> OCC_FILTERS = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("MonteCarlo.OCC_FILTERS", List.class, DisplayProps.emptyList(VariationOccFilter.class), Intl.intl("Occupant Filters"), Intl.intl("Filters that can be used to disable or enable randomization for specific groups of occupants.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v.isEmpty() ? Intl.intl("None") : v.stream().map(Record::toString).collect(Collectors.joining("; ")))).attrStoreAsPlainOldData(PROPS).attrDependency(prop -> Dependencies.newDependency(prop, DLink.WEAK, EgressAgentComp.class, (md, src, filters) -> filters.stream().flatMap(f -> Set.of(f.group()).stream()), Predicates.alwaysTrue(), (md, src, filters, old, repl) -> {
        ArrayList<VariationOccFilter> filterData = new ArrayList<VariationOccFilter>((Collection<VariationOccFilter>)filters);
        ArrayList<VariationOccFilter> toRemove = new ArrayList<VariationOccFilter>();
        for (int i = 0; i < filterData.size(); ++i) {
            if (((VariationOccFilter)filterData.get(i)).group() != old) continue;
            if (repl == null) {
                toRemove.add((VariationOccFilter)filterData.get(i));
                continue;
            }
            filterData.set(i, new VariationOccFilter((EgressAgentComp)repl, ((VariationOccFilter)filterData.get(i)).randomizePositions(), ((VariationOccFilter)filterData.get(i)).randomizeProperties(), ((VariationOccFilter)filterData.get(i)).randomizeProfiles()));
        }
        filterData.removeAll(toRemove);
        return filterData;
    })).attrFinish();
    public static final DisplayProp<VariationRoomRule> ROOM_RULE = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"MonteCarlo.ROOM_RULE", VariationRoomRule.class, VariationRoomRule.SAME, Intl.intl("Room Rule"), Intl.intl("Specifies which rooms occupants may be repositioned to.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(VariationRoomRule::getName)).attrStoreAsPlainOldData(PROPS).attrFinish();
    public static final DisplayProp<VariationPositionDistribution> POSITION_DISTRIBUTION = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"MonteCarlo.POSITION_DISTRIBUTION", VariationPositionDistribution.class, VariationPositionDistribution.RANDOM, Intl.intl("Position Distribution"), Intl.intl("Specifies how occupant positions are chosen.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(VariationPositionDistribution::getName)).attrStoreAsPlainOldData(PROPS).attrFinish();
    public static final DisplayProp<Long> RANDOMIZATION_SEED = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"MonteCarlo.RANDOMIZATION_SEED", 0L, Intl.intl("Randomization Seed"), Intl.intl("Initial seed for randomization.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROPS).attrFinish();
    private PropertySet d_props = new PropertySet();

    public MonteCarlo(OccProfile noChangeProfile) {
        this.set(PROFILE_DIST, new InfiniteUrn<OccProfile>(noChangeProfile));
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROPS;
    }

    @Override
    public String getName() {
        return Intl.intl("Monte Carlo");
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public boolean isSetNameSupported() {
        return false;
    }

    public void reset(OccProfile noChangeProfile) {
        this.restoreFrom(new MonteCarlo(noChangeProfile));
    }
}

