/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting.queues;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.geom.GeomUtil;
import merlin.geom.IMerlinDispProps;
import merlin.util.Dependencies;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.Urn;

public class QueueService
extends NamedMerlinObj
implements IQueueElement,
IEgressObj,
IDirectDependent<MerlinData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<QueueService> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(QueueService.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
    }), NamedMerlinObj.PROPS);
    public static final TypedProp<Point3d> PROP_LOC = TypedProps.build("QueueService.LOC", Point3d.class, new Point3d()).attrStoreAsPlainOldData(PROP_TYPES).attrFireEvents((prop, obj) -> obj.changedEvt(prop, MerlinData.TOPOLOGY)).attrFinish();
    public static final TypedProp<Vector3d> PROP_NORMAL = TypedProps.build("QueueService.NORMAL", Vector3d.class, GeomConstants.VEC3D_ZPOS).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<IDistributedVal<UnitDouble>> PROP_TIME = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("QueueService.TIME", IDistributedVal.class, new Urn<UnitDouble>((Collection<UnitDouble>)Collections.singleton(new UnitDouble(10.0, SI.SECOND))), Intl.intl("Service Time"), "").attrFormatValueWithToString()).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().distributedValue(1)).attrFinish();
    public static final TypedProp<IEgressOccupiable> PROP_ROOM = TypedProps.build((Object)"QueueService.ROOM", IEgressOccupiable.class).attrStoreAsTopologyDirect(PROP_TYPES).attrGetter(QueueService::getRoom, Stream.empty()).attrSetter(QueueService::setRoom, null).attrDependency(roomProp -> Dependencies.newDependencyContainedBy(IEgressOccupiable.class)).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = TagsUtil.newTagsProp(PROP_TYPES);
    public static DisplayProp<Boolean> VISIBILITY = PROP_TYPES.storeAsPlainOldData(MerlinData.VISIBILITY).attrGetter(QueueService::isVisible, Stream.empty()).attrSetter(QueueService::setVisible, null).attrSurrogateEquals(null).attrFinish();
    private PropertySet d_props = new PropertySet();
    private boolean d_visible;
    @SkipDep
    private transient IEgressOccupiable d_room;

    public QueueService(String name, Point3d loc, IDistributedVal<UnitDouble> wait, IEgressOccupiable room, Vector3d normal) {
        super(name);
        this.d_props.set(PROP_LOC, loc);
        this.d_props.set(PROP_TIME, wait);
        this.d_props.set(PROP_NORMAL, normal);
        this.d_visible = true;
        this.d_room = room;
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    public Point3d getLocation() {
        return this.get(PROP_LOC);
    }

    public void setLocation(Point3d loc) {
        this.set(PROP_LOC, loc);
    }

    public Vector3d getNormal() {
        return this.get(PROP_NORMAL);
    }

    public IDistributedVal getServiceTime() {
        return this.get(PROP_TIME);
    }

    public void setServiceTime(IDistributedVal time) {
        this.set(PROP_TIME, time);
    }

    public IEgressOccupiable getRoom() {
        return this.d_room;
    }

    private void setRoom(IEgressOccupiable room) {
        if (this.d_room != room) {
            this.d_room = room;
            this.changedEvt(PROP_ROOM);
        }
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof QueueServiceGeom) {
            QueueServiceGeom sgeom = (QueueServiceGeom)geom;
            this.setLocation(sgeom.location);
        } else if (geom instanceof Point) {
            Point point = (Point)geom;
            this.setLocation(point.loc);
        }
    }

    @Override
    public IGeomNode getGeom() {
        IGeom geom = this.getDomain() != null ? this.getSolidServiceGeom() : this.getHollowServiceGeom();
        return GeomNodeUtil.newNode(geom);
    }

    public IGeom getSolidServiceGeom() {
        return new QueueServiceGeom(this.getRoom(), this.getNormal(), this.getLocation(), true);
    }

    public IGeom getHollowServiceGeom() {
        return new QueueServiceGeom(this.getRoom(), this.getNormal(), this.getLocation(), false);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        if (!(props instanceof IMerlinDispProps)) {
            return DisplayGeom.EMPTY;
        }
        IMerlinDispProps globalProps = (IMerlinDispProps)props;
        IGeomNode geom = this.getGeom();
        PropsBuilder qsProps = new PropsBuilder();
        IPrimProps eprops = globalProps.getEdgeProps(this, IMerlinDispProps.EgressType.QUEUE_SERV, Color.BLACK, 1.0f);
        qsProps.add(eprops);
        if (this.getDomain() != null) {
            QueueObject parent = (QueueObject)((MerlinData)this.getDomain()).hierarchy.getParent(this);
            Color baseColor = parent.getColor();
            float opacity = parent.getOpacity();
            IPrimProps fprops = globalProps.getFaceProps(this, IMerlinDispProps.EgressType.QUEUE_SERV, null, baseColor, opacity);
            qsProps.add(fprops);
        }
        qsProps.add(new IPrimProps.Vertex(Color.BLACK, 8.0));
        return new DisplayGeom(geom, qsProps);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isVisible() != visible) {
            this.d_visible = visible;
            this.changedEvt(MerlinData.VISIBILITY);
        }
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        return this.d_room == null ? Collections.EMPTY_LIST : Arrays.asList(this.d_room);
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return this.d_room == null;
    }

    @Override
    public void disconnectFrom(IEgressObj conn) {
        if (conn == this.d_room) {
            try (IDomainObject.EventPause paused = this.openPause();){
                this.setRoom(null);
                this.set(PROP_NORMAL, GeomConstants.VEC3D_ZPOS);
            }
        }
    }

    @Override
    public void connectTo(IEgressObj conn) {
        if (conn instanceof IEgressOccupiable) {
            // empty if block
        }
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_room);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_room = (IEgressOccupiable)ois.readObject();
    }

    @Override
    public boolean updateTopo() {
        assert (this.d_room == null);
        GeomUtil.FindResult room = GeomUtil.findRoom((MerlinData)this.getDomain(), new Point3d(this.getLocation().x, this.getLocation().y, this.getLocation().z + 1.0E-6), new Point3d(this.getLocation().x, this.getLocation().y, this.getLocation().z - 1.0E-6), 1);
        if (room != null) {
            try (IDomainObject.EventPause paused = this.openPause();){
                this.setToPropertySet(PROP_LOC, room.p);
                this.set(PROP_NORMAL, room.faceNormal);
                this.setRoom(room.room);
            }
        }
        return true;
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return this.getLocation();
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return this.getLocation();
    }

    private static class QueueServiceGeom
    extends GeomUtil.ACircleGeometry {
        private static final long serialVersionUID = 6888058928107634877L;
        private final boolean d_solid;

        public QueueServiceGeom(IEgressOccupiable room, Vector3d normal, Point3d location, boolean solid) {
            super(room, normal, location, 0.25, solid, new IGeom[0]);
            this.d_solid = solid;
        }

        @Override
        protected IGeom constructTransformedGeom(GeomUtil.FindResult find, Point3d newLoc, double radius) {
            if (find == null) {
                return new QueueServiceGeom(null, GeomConstants.VEC3D_ZPOS, newLoc, this.d_solid);
            }
            return new QueueServiceGeom(find.room, find.faceNormal, newLoc, this.d_solid);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new GeomUtil.LocationHandle(this, GeomUtil.LocationHandle.GEOM_TYPE.AREA));
        }

        @Override
        public GeomUtil.ACircleGeometry getConstructedTransform(IEgressOccupiable room, Vector3d normal, Point3d location, double radius) {
            return new QueueServiceGeom(room, normal, location, this.d_solid);
        }
    }
}

