/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting.queues;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.MerlinApp;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.data.property.PropertyDefs;
import merlin.geom.GeomUtil;
import merlin.util.Dependencies;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;

public class QueuePathNode
extends NamedMerlinObj
implements IQueueElement,
IEgressObj,
IDirectDependent<MerlinData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<QueuePathNode> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(QueuePathNode.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
    }), NamedMerlinObj.PROPS);
    public static final TypedProp<Point3d> PROP_LOCATION = TypedProps.build("QueuePathNode.LOCATION", Point3d.class, new Point3d()).attrStoreAsPlainOldData(PROP_TYPES).attrFireEvents((prop, obj) -> obj.changedEvt(prop, MerlinData.TOPOLOGY)).attrFinish();
    public static final TypedProp<Vector3d> PROP_NORMAL = TypedProps.build("QueuePathNode.NORMAL", Vector3d.class, GeomConstants.VEC3D_ZPOS).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrFinish();
    public static DisplayProp<Boolean> VISIBILITY = PROP_TYPES.storeAsPlainOldData(MerlinData.VISIBILITY).attrGetter(QueuePathNode::isVisible, Stream.empty()).attrSetter(QueuePathNode::setVisible, null).attrSurrogateEquals(null).attrFinish();
    public static final TypedProp<IEgressOccupiable> PROP_ROOM = TypedProps.build("QueuePathNode.ROOM", IEgressOccupiable.class, null).attrStoreAsTopologyDirect(PROP_TYPES).attrGetter(QueuePathNode::getRoom, Stream.empty()).attrSetter(QueuePathNode::setRoom, null).attrDependency(roomProp -> Dependencies.newDependencyContainedBy(IEgressOccupiable.class)).attrSurrogateEquals(null).attrFinish();
    private PropertySet d_props = new PropertySet();
    private boolean d_visible;
    @SkipDep
    private transient IEgressOccupiable d_room;

    public QueuePathNode(String name, Point3d location, IEgressOccupiable room, Vector3d faceNormal) {
        super(name);
        this.d_props.set(PROP_LOCATION, location);
        this.d_props.set(PROP_NORMAL, faceNormal);
        this.d_visible = true;
        this.d_room = room;
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    public Point3d getLocation() {
        return this.get(PROP_LOCATION);
    }

    public void setLocation(Point3d loc) {
        this.set(PROP_LOCATION, loc);
    }

    public Vector3d getFaceNormal() {
        return this.get(PROP_NORMAL);
    }

    public IEgressOccupiable getRoom() {
        return this.d_room;
    }

    private void setRoom(IEgressOccupiable room) {
        if (this.d_room != room) {
            this.d_room = room;
            this.changedEvt(PROP_ROOM);
        }
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        this.pauseUpdates();
        if (geom instanceof PathNodeGeom) {
            PathNodeGeom nGeom = (PathNodeGeom)geom;
            this.setLocation(nGeom.loc);
        } else if (geom instanceof Point) {
            Point point = (Point)geom;
            this.setLocation(point.loc);
        }
        this.resumeUpdates();
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(new PathNodeGeom(this.getLocation()));
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode geom = this.getGeom();
        PropsBuilder qpnProps = new PropsBuilder();
        qpnProps.add(new IPrimProps.Vertex(Color.BLACK, 12.0));
        return new DisplayGeom(geom, qpnProps);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isVisible() != visible) {
            this.d_visible = visible;
            this.changedEvt(MerlinData.VISIBILITY);
        }
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        return this.d_room == null ? Collections.emptyList() : List.of(this.d_room);
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return this.d_room == null;
    }

    @Override
    public void disconnectFrom(IEgressObj conn) {
        if (conn == this.d_room) {
            this.setRoom(null);
        }
    }

    @Override
    public void connectTo(IEgressObj conn) {
        if (conn instanceof IEgressOccupiable) {
            // empty if block
        }
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_room);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.set(PROP_ROOM, (IEgressOccupiable)ois.readObject());
    }

    @Override
    public boolean updateTopo() {
        assert (this.d_room == null);
        GeomUtil.FindResult room = GeomUtil.findRoom((MerlinData)this.getDomain(), new Point3d(this.getLocation().x, this.getLocation().y, this.getLocation().z + 1.0E-6), new Point3d(this.getLocation().x, this.getLocation().y, this.getLocation().z - 1.0E-6), 1);
        if (room != null) {
            try (IDomainObject.EventPause paused = this.openPause();){
                this.setToPropertySet(PROP_LOCATION, room.p);
                this.set(PROP_NORMAL, room.faceNormal);
                this.setRoom(room.room);
            }
        }
        return true;
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return this.getLocation();
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return this.getLocation();
    }

    private static class PathNodeGeom
    extends Point {
        private static final long serialVersionUID = 7808890574273286294L;

        public PathNodeGeom(Point3d loc) {
            super(loc);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new PathNodeManipHandle(this));
        }
    }

    private static class PathNodeManipHandle
    implements IHandle {
        private PathNodeGeom geom;

        public PathNodeManipHandle(PathNodeGeom geom) {
            this.geom = geom;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof PathNodeManipHandle;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(this.geom);
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return null;
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public Object modify(IsectInfo constraintInfo, Point3d newLoc) throws ManipException {
            GeomUtil.FindResult room = GeomUtil.findRoom(MerlinApp.getApp().getData(), newLoc, 0);
            if (room == null) {
                throw new ManipException();
            }
            this.geom = new PathNodeGeom(newLoc);
            return this.geom;
        }

        @Override
        public Object end() {
            return this.geom;
        }
    }
}

