/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting.queues;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.IMerlinObj;
import merlin.data.IOpacity;
import merlin.data.MerlinData;
import merlin.data.ObjsFilter;
import merlin.data.Opacity;
import merlin.data.egress.SimError;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.scripting.queues.IGotoQueueDestination;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.data.egress.scripting.queues.QueuePath;
import merlin.data.egress.scripting.queues.QueueService;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.gui.ObjSources;
import merlin.mv.displays.MerlinDispProps;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.PropertyDefsFramework;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.util.Events;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class QueueObject
extends GeomComposite<IQueueElement>
implements IGotoQueueDestination,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<QueueObject> PROP_TYPES = PropertyDefs.defsInheritStorageAndProps(QueueObject.class, null, GeomComposite.PROP_TYPES);
    static final TypedProp<Set<IMerlinObj>> CHILDREN = Composite.CHILDREN;
    static final TypedProp<Boolean> STORED_VISIBILITY = GeomComposite.STORED_VISIBILITY;
    private static final DisplayProp<ObjsFilter<OccProfile>> RESTRICTED_PROFILES_PROP = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("QueuePath.RESTRICTED_PROFILES", ObjsFilter.class, new ObjsFilter(ObjsFilter.Mode.ALL, false, Collections.emptySet()), Intl.intl("Accepted Profiles"), "").attrFormatValueWithToString()).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrComparisonEditor(PropComparisons.factory().objsFilter(md -> ObjSources.getProfiles(md, null, false)))).attrToProp();
    public static final DisplayProp<ObjsFilter<OccProfile>> RESTRICTED_PROFILES = QueueObject.defineRestrictedProfiles(PROP_TYPES).attrGetter(QueueObject::getRestrictedProfiles, Stream.empty()).attrSetter(QueueObject::setRestrictedProfiles, (obj, val) -> {
        obj.d_restrictedProfiles = val;
    }).attrFinish();
    public static final DisplayProp<IOpacity> OPACITY = PROP_TYPES.storeAsPlainOldData(MerlinData.OPACITY).attrGetter(obj -> new Opacity(obj.getOpacity()), Stream.empty()).attrSetter((obj, val) -> obj.setOpacity(val.getValue()), null).attrFinish();
    public static final DisplayProp<Color> COLOR = PROP_TYPES.storeAsPlainOldData(MerlinData.COLOR).attrGetter(QueueObject::getColor, Stream.empty()).attrSetter(QueueObject::setColor, null).attrFinish();
    public static final DisplayProp<Color> SEARCH_COLOR = PROP_TYPES.storeAsReadOnly(MerlinData.SEARCH_COLOR).attrGetter(qo -> qo.get(COLOR), COLOR).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = TagsUtil.buildTagsProp(PROP_TYPES).attrGetter(QueueObject::getTags, Stream.empty()).attrSetter(QueueObject::setTags, null).attrFinish();
    private Set<Tag> d_tags;
    private Color d_color = theUtil.newRandomLightColor();
    private float d_transparency = 0.0f;
    @SkipDep
    private Object d_restrictedProfiles = new ObjsFilter(ObjsFilter.Mode.ALL, false, Collections.emptySet());
    private static final Predicate<IMerlinObj> s_filter = new TypeFilter<IMerlinObj>(QueuePath.class, QueueService.class);

    public static final <ObjT extends IMerlinObj> PropertyDefsFramework.AttributeBuilder<ObjsFilter<OccProfile>, DisplayProp<ObjsFilter<OccProfile>>> defineRestrictedProfiles(PropertyDefs<ObjT> defs) {
        return defs.storeAsPlainOldData(RESTRICTED_PROFILES_PROP).attrDependency(prop -> ObjsFilter.newDepCallback(prop, OccProfile.class));
    }

    public QueueObject(String name) {
        super(name);
        this.d_tags = Collections.emptySet();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_restrictedProfiles == null) {
            this.d_restrictedProfiles = new ObjsFilter(ObjsFilter.Mode.ALL, false, Collections.emptySet());
        }
        if (this.d_tags == null) {
            this.d_tags = Collections.emptySet();
        }
    }

    @Override
    public boolean cyclicEquals(Object obj, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        QueueObject qo = (QueueObject)obj;
        return super.cyclicEquals(qo, comparedSet) && theUtil.surrogateSetsEqual(this.getMembers(), qo.getMembers(), comparedSet);
    }

    public void setColor(Color c) {
        if (!Objects.equals(this.d_color, c)) {
            this.d_color = c;
            for (IQueueElement elem : this.getMembers(IQueueElement.class)) {
                elem.changedEvt(COLOR);
            }
            this.changedEvt(COLOR);
        }
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setOpacity(float opacity) {
        float trans = 1.0f - opacity;
        if (theUtil.eq(trans, this.d_transparency, 0.0)) {
            return;
        }
        this.d_transparency = trans;
        for (IQueueElement elem : this.getMembers(IQueueElement.class)) {
            elem.changedEvt(OPACITY);
        }
        this.changedEvt(OPACITY);
    }

    public float getOpacity() {
        return 1.0f - this.d_transparency;
    }

    public Color getDisplayColor() {
        return MerlinDispProps.applyAlpha(this.getColor(), this.getOpacity());
    }

    public void setRestrictedProfiles(ObjsFilter<OccProfile> profs) {
        if (Objects.equals(this.d_restrictedProfiles, profs)) {
            return;
        }
        this.d_restrictedProfiles = profs;
        this.changedEvt(RESTRICTED_PROFILES);
    }

    public ObjsFilter<OccProfile> getRestrictedProfiles() {
        return (ObjsFilter)this.d_restrictedProfiles;
    }

    @Deprecated
    public Set<OccProfile> getLegacyRestrictedProfiles() {
        return (Set)this.d_restrictedProfiles;
    }

    public List<String> getRestrictedProfiles_Strings() {
        return QueueObject.getRestrictedProfiles_Strings((MerlinData)this.getDomain(), this.getRestrictedProfiles());
    }

    protected static List<String> getRestrictedProfiles_Strings(MerlinData md, ObjsFilter<OccProfile> filterProfs) {
        Set<OccProfile> rejectedProfs;
        Set modelProfs;
        ArrayList<String> profs = new ArrayList<String>();
        Collection<Object> collection = modelProfs = md != null ? md.profiles.flatten(OccProfile.class) : Collections.emptySet();
        if (filterProfs.mode == ObjsFilter.Mode.ALL) {
            rejectedProfs = Collections.emptySet();
        } else if (filterProfs.mode == ObjsFilter.Mode.NONE) {
            rejectedProfs = modelProfs;
        } else if (filterProfs.rejected) {
            rejectedProfs = filterProfs.objects;
        } else {
            rejectedProfs = new LinkedHashSet(modelProfs);
            rejectedProfs.removeAll(filterProfs.objects);
        }
        for (OccProfile prof : rejectedProfs) {
            profs.add(prof.getName());
        }
        return profs;
    }

    public Set<Tag> getTags() {
        return this.d_tags;
    }

    public void setTags(Set<Tag> tags) {
        if (Objects.equals(tags, this.d_tags)) {
            return;
        }
        this.d_tags = tags;
        this.changedEvt(TAGS);
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public void add(IMerlinObj obj) {
        if (!this.getFilter().test(obj)) {
            return;
        }
        super.add(obj);
    }

    @Override
    public void addAll(Collection<? extends IMerlinObj> objs) {
        super.addAll(theUtil.filter(objs, IQueueElement.class));
    }

    @Override
    public Predicate<IMerlinObj> getFilter() {
        return s_filter;
    }

    @Override
    public boolean canAddGroup() {
        return false;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return null;
    }

    public static boolean testValidateDirty(Events events) {
        return EntryPointFactory.isModified(events, QueuePath.class) || EntryPointFactory.isModified(events, OccProfile.class);
    }

    public void validate(MerlinData md, SimError.Level errLevel, Consumer<? super SimError> errors) {
        QueueObject qo = this;
        if (qo.flatten(QueueService.class).isEmpty()) {
            errors.accept(new SimError(errLevel, Intl.intl("A Queue must contain at least one Service."), Intl.intl("Delete or add a Service."), this));
        }
        if (qo.flatten(QueuePath.class).isEmpty()) {
            errors.accept(new SimError(errLevel, Intl.intl("A Queue must contain at least one Path."), Intl.intl("Delete or add a Path."), qo));
        } else {
            ObjsFilter<OccProfile> qFilter = qo.getRestrictedProfiles();
            ObjsFilter<Object> allPathsFilter = new ObjsFilter(ObjsFilter.Mode.FROM_LIST, false, new HashSet());
            Set allAllowedProfiles = allPathsFilter.objects;
            for (QueuePath qp : qo.flatten(QueuePath.class)) {
                ObjsFilter<OccProfile> pathFilter = qp.getRestrictedProfiles();
                if (pathFilter.mode == ObjsFilter.Mode.ALL) {
                    allPathsFilter = new ObjsFilter(ObjsFilter.Mode.ALL, false, null);
                    break;
                }
                if (pathFilter.mode == ObjsFilter.Mode.NONE || pathFilter.rejected) continue;
                allAllowedProfiles.addAll(pathFilter.objects);
            }
            allPathsFilter = new ObjsFilter(allPathsFilter.mode, false, allAllowedProfiles);
            for (OccProfile prof : md.profiles.flatten(OccProfile.class)) {
                if (!qFilter.test(prof) || allPathsFilter.test(prof)) continue;
                errors.accept(new SimError(errLevel, Intl.intl("A Queue allows a profile that its Path(s) cannot accept."), Intl.intl("Change the Accepted Profiles in the Queue or Path"), qo));
            }
        }
    }
}

