/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.gui.ObjSources;
import merlin.util.ILabeledEnum;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.gui.framework.property.CompositeProp;
import thunderheadeng.gui.framework.property.CompositeProps;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.theUtil;

public class LookAt
extends NamedMerlinObj
implements IBehaviorAction,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<LookAt> PROP_TYPES = PropertyDefs.defsInheritPropsOnlyMultiple(LookAt.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
    }), List.of(NamedMerlinObj.PROPS, IBehaviorAction.PROP_TYPES), Filters.reject(NamedMerlinObj.NAME, NamedMerlinObj.STORED_NAME));
    public static final DisplayProp<Set<Tag>> PROP_TAGS = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("LookAt.TAGS ", Set.class, theUtil.emptySet(Tag.class), Intl.intl("Occupant Tags"), Intl.intl("Defines the tags used to find a target occupant.")).attrFormatValueWithToString()).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(TagsUtil::getTagCallback).attrComparisonEditor(PropComparisons.factory().multiObj(md -> ObjSources.getTags(md, null))).attrFinish();
    public static final DisplayProp<TagLogic> PROP_TAG_LOGIC = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"LookAt.TAG_LOGIC ", TagLogic.class, TagLogic.ALL, Intl.intl("Tag Logic"), Intl.intl("Defines how the tags are combined in order to find a target occupant.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(logic -> logic.name)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().options(TagLogic.values())).attrFinish();
    public static final DisplayProp<DistancePref> PROP_DIST_PREF = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"LookAt.DIST_PREF", DistancePref.class, DistancePref.RANDOM, Intl.intl("Distance Preference"), Intl.intl("Defines the occupant's preference for a target occupant based on the distance\nto the occupant.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v.name)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().options(DistancePref.values())).attrFinish();
    static final CompositeProp PROP_TAGS_COMPOSITE = (CompositeProp)((CompositeProps.CompositePropBuilder)CompositeProps.build(PROP_TAGS, PROP_TAG_LOGIC).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsComposite(PROP_TYPES).attrFinish();
    public static final DisplayProp<String> PROP_NAME = PROP_TYPES.storeAsReadOnly(NamedMerlinObj.NAME).attrGetter(obj -> LookAt.formatName(obj.get(PROP_TAG_LOGIC), TagsUtil.tagsAsStrings(obj.get(PROP_TAGS))), Stream.of(PROP_TAGS, PROP_TAG_LOGIC)).attrFinish();
    private PropertySet d_props = new PropertySet();

    public LookAt() {
        super(null);
    }

    @Deprecated
    public Set<String> getLegacyPre170Tags() {
        IPropertySet.Prop strTagsProp = new IPropertySet.Prop("LookAt.TAGS ", Collections.emptySet());
        return this.d_props.get(strTagsProp);
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    public static String formatName(TagLogic logic, Set<String> tagStrings) {
        return String.format(Intl.intl("Look at Occ %s"), logic.formatTags.apply(tagStrings));
    }

    @Override
    public boolean isSetNameSupported() {
        return false;
    }

    public static enum TagLogic implements ILabeledEnum,
    ILabeled
    {
        ALL(Intl.intl("All"), Intl.intl("The target occupant must have all the specified tags."), tags -> MerlinUtil.formatStrTags(tags, Intl.intl(" and "), 25)),
        ANY(Intl.intl("Any"), Intl.intl("The target occupant must have any of the specified tags."), tags -> MerlinUtil.formatStrTags(tags, Intl.intl(" or "), 25));

        public final String name;
        public final String desc;
        public final Function<Set<String>, String> formatTags;

        private TagLogic(String name, String desc, Function<Set<String>, String> formatTags) {
            this.name = name;
            this.desc = desc;
            this.formatTags = formatTags;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum DistancePref implements ILabeledEnum,
    ILabeled
    {
        RANDOM(Intl.intl("None"), Intl.intl("The occupant has no distance preference. A target occupant is chosen at random from those available.")),
        NEAREST(Intl.intl("Nearest"), Intl.intl("The nearest available occupant is chosen."));

        public final String name;
        public final String desc;

        private DistancePref(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

