/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.SimError;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.IUnreachable;
import merlin.data.egress.scripting.RoomLocationGeometry;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.geom.IMerlinDispProps;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.text.IDisplayableTextSrc;
import thunderheadeng.scene3d.text.RenderFont;
import thunderheadeng.scene3d.text.RenderString;
import thunderheadeng.scene3d.text.TextAttrs;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;

public class GotoWaypoint
extends NamedMerlinObj
implements IBehaviorAction,
IEgressObj,
IDestinationAction,
IDirectDependent<MerlinData>,
IDisplayableTextSrc {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<GotoWaypoint> PROP_TYPES = PropertyDefs.defsInheritPropsOnlyMultiple(GotoWaypoint.class, PropertyDefs.none(), List.of(NamedMerlinObj.PROPS, IBehaviorAction.PROP_TYPES), Filters.reject(NamedMerlinObj.NAME));
    public static final DisplayProp<Boolean> PROP_VISIBILITY = PROP_TYPES.storeAsPlainOldData(MerlinData.VISIBILITY).attrGetter(GotoWaypoint::isVisible, Stream.empty()).attrSetter(GotoWaypoint::setVisible, null).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Point3d> PROP_LOC = (DisplayProp)DisplayProps.build((Object)"WaypointGoal.LOC", Point3d.class, new Point3d(), Intl.intl("Location"), "").attrStoreAsPlainOldData(PROP_TYPES).attrGetter(GotoWaypoint::getLocation, Stream.empty()).attrSetter(GotoWaypoint::setLocation, null).attrComparisonEditor(PropComparisons.factory().convert(p -> new UnitPoint3D((Point3d)p, Geometry.LENGTH_UNIT), PropComparisons.factory().unitPoint3D(0))).attrFinish();
    public static final TypedProp<Vector3d> PROP_ROOM_NORMAL = TypedProps.build("WaypointGoal.NORMAL", Vector3d.class, new Vector3d()).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(GotoWaypoint::getRoomNorm, Stream.empty()).attrSetter((prop, obj, val) -> {
        if (!Objects.equals(obj.d_normal, val)) {
            obj.d_normal = val;
            obj.changedEvt(prop);
        }
    }, null).attrSurrogateEquals(null).attrFinish();
    public static final TypedProp<IEgressOccupiable> PROP_ROOM = TypedProps.build("WaypointGoal.ROOM", IEgressOccupiable.class, null).attrStoreAsTopologyDirect(PROP_TYPES).attrGetter(GotoWaypoint::getRoom, Stream.empty()).attrSetter((prop, obj, val) -> {
        if (obj.d_room != val) {
            obj.d_room = val;
            obj.changedEvt(prop);
        }
    }, null).attrDependency(prop -> Dependencies.newDependencyContainedBy(IEgressOccupiable.class)).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<UnitDouble> PROP_ARRIVE_RADIUS = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"WaypointGoal.ARRIVE_RADIUS", new UnitDouble(1.5, SI.METER), Intl.intl("Arrival Radius"), "", 0).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(GotoWaypoint::getArriveRadius, Stream.empty()).attrSetter(GotoWaypoint::setArriveRadius, null).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<String> PROP_NAME = GotoWaypoint.buildCustomNameProp(PROP_TYPES).attrGetter(obj -> {
        String name = obj.getStoredName();
        if (name == null) {
            name = String.format(Intl.intl("Goto %s"), GotoWaypoint.format(obj.d_location));
        }
        return name;
    }, Stream.of(NamedMerlinObj.STORED_NAME, PROP_LOC)).attrFinish();
    private boolean d_visible = true;
    private Point3d d_location;
    private UnitDouble d_arriveRadius;
    @SkipDep
    private transient IEgressOccupiable d_room;
    private Vector3d d_normal;
    private static final Color BASE_COLOR = Color.RED;
    private static final int[] TEXT_PADDING = new int[]{4, 4, 4, 4};
    private static final TextAttrs s_textAttrs = new TextAttrs(new RenderFont(12.0f, RenderFont.Mode.MODE_2D), true);

    public GotoWaypoint(String name, Point3d loc, IEgressOccupiable room, Vector3d roomNormal, UnitDouble arriveRad) {
        super(name);
        this.d_location = loc;
        this.d_room = room;
        this.d_normal = roomNormal;
        this.d_arriveRadius = arriveRad;
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    private static String format(Point3d p) {
        Unit su = Geometry.LENGTH_UNIT;
        Unit du = (Unit)MerlinUtil.getDisplayUnitSupplier(0).apply(Geometry.LENGTH_UNIT);
        return String.format("(%.1f, %.1f, %.1f) %s", UnitDouble.convert(p.x, su, du), UnitDouble.convert(p.y, su, du), UnitDouble.convert(p.z, su, du), du.toString());
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible != visible) {
            this.d_visible = visible;
            this.changedEvt(PROP_VISIBILITY);
        }
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return this.d_location;
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return this.d_location;
    }

    public boolean accept(MerlinData md, Composite<?> group) {
        return group instanceof Behavior;
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_room);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_room = (IEgressOccupiable)ois.readObject();
    }

    @Override
    public void connectTo(IEgressObj conn) {
        if (conn instanceof IEgressOccupiable) {
            // empty if block
        }
    }

    @Override
    public void disconnectFrom(IEgressObj conn) {
        if (conn == this.d_room) {
            this.d_room = null;
            this.d_normal = GeomConstants.VEC3D_ZPOS;
            this.changedEvt(PROP_ROOM);
        }
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        return this.d_room == null ? Collections.EMPTY_LIST : Arrays.asList(this.d_room);
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return this.d_room == null;
    }

    @Override
    public boolean updateTopo() {
        GeomUtil.FindResult room = GeomUtil.findRoom((MerlinData)this.getDomain(), new Point3d(this.d_location.x, this.d_location.y, this.d_location.z + 1.0E-6), new Point3d(this.d_location.x, this.d_location.y, this.d_location.z - 1.0E-6), 1);
        if (room != null) {
            this.d_room = room.room;
            this.d_normal = room.faceNormal;
            this.d_location = room.p;
            this.changedEvt(PROP_ROOM, PROP_ROOM_NORMAL, PROP_LOC);
        }
        return true;
    }

    @Override
    public IDestination getDestination() {
        return new Destination();
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    public Point3d getLocation() {
        return this.d_location;
    }

    public void setLocation(Point3d loc) {
        if (!this.d_location.equals(loc)) {
            this.pauseUpdates();
            this.d_location = loc;
            this.changedEvt(MerlinData.TOPOLOGY);
            this.changedEvt(PROP_LOC);
            this.resumeUpdates();
        }
    }

    protected void setLocation(IEgressOccupiable room, Vector3d roomNorm, Point3d loc) {
        this.d_location = loc;
        this.d_normal = roomNorm;
        if (room != this.d_room) {
            if (this.getDomain() != null) {
                if (this.d_room != null) {
                    this.d_room.disconnectFrom(this);
                    this.disconnectFrom(this.d_room);
                }
                if (room != null) {
                    room.connectTo(this);
                }
            }
            this.d_room = room;
        }
        this.changedEvt(PROP_ROOM, PROP_ROOM_NORMAL, PROP_LOC);
    }

    public IEgressOccupiable getRoom() {
        return this.d_room;
    }

    public Vector3d getRoomNorm() {
        return this.d_normal;
    }

    public UnitDouble getArriveRadius() {
        return this.d_arriveRadius;
    }

    public void setArriveRadius(UnitDouble arriveRad) {
        if (!this.d_arriveRadius.equals(arriveRad)) {
            this.d_arriveRadius = arriveRad;
            this.changedEvt(PROP_ARRIVE_RADIUS);
        }
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getWaypointGeom());
    }

    public IGeom getWaypointGeom() {
        return new RoomLocationGeometry(this.d_room, this.d_normal, this.d_location, this.d_arriveRadius.getValue(Geometry.LENGTH_UNIT));
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof RoomLocationGeometry) {
            RoomLocationGeometry wgeom = (RoomLocationGeometry)geom;
            this.pauseUpdates();
            this.setArriveRadius(new UnitDouble(wgeom.radius, Geometry.LENGTH_UNIT));
            this.setLocation(wgeom.room, wgeom.normal, wgeom.location);
            this.changedEvt(MerlinData.TOPOLOGY);
            this.resumeUpdates();
        } else if (geom instanceof Point) {
            Point p = (Point)geom;
            this.setLocation(p.loc);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode geom = this.getGeom();
        PropsBuilder gprops = new PropsBuilder();
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Face(BASE_COLOR, null, 0));
        gprops.add(new IPrimProps.Vertex(Color.BLACK, 8.0));
        return new DisplayGeom(geom, gprops);
    }

    private int getIndex() {
        Object parent = this.getParent();
        if (parent == null) {
            return -1;
        }
        if (parent instanceof Behavior) {
            Behavior behavior = (Behavior)parent;
            return behavior.indexOf(this);
        }
        return -1;
    }

    @Override
    public List<RenderString> getStrings(IDisplayProps displayProps) {
        Color color;
        String lbl;
        int ix = this.getIndex();
        String string = lbl = ix >= 0 ? Integer.toString(ix + 1) : "";
        if (displayProps instanceof IMerlinDispProps) {
            IMerlinDispProps mprops = (IMerlinDispProps)displayProps;
            color = mprops.getTextColor(this);
        } else {
            color = Color.WHITE;
        }
        return List.of(new RenderString(lbl, color, Util.translateMat(this.getLocation()), RenderString.Justification.LEFT, GeomConstants.PNT3D_ORIGIN, TEXT_PADDING, null, null));
    }

    @Override
    public TextAttrs getAttrs() {
        return s_textAttrs;
    }

    private int surrogateHashCode() {
        int hash = 7;
        hash = 31 * hash + theUtil.hashCode(this.getLocation());
        hash = 31 * hash + theUtil.hashCode(this.getArriveRadius());
        hash = 31 * hash + theUtil.hashCode(this.isVisible());
        return hash;
    }

    public class Destination
    implements IDestination {
        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof Destination && ((Destination)obj).getWaypoint().d_location.equals(GotoWaypoint.this.d_location) && ((Destination)obj).getWaypoint().d_arriveRadius.equals(GotoWaypoint.this.d_arriveRadius) && ((Destination)obj).getWaypoint().d_normal.equals(GotoWaypoint.this.d_normal) && Objects.equals(((Destination)obj).getWaypoint().d_room, GotoWaypoint.this.d_room);
        }

        @Override
        public int hashCode() {
            return 0xFA9832F ^ GotoWaypoint.this.d_location.hashCode() + GotoWaypoint.this.d_arriveRadius.hashCode() + GotoWaypoint.this.d_normal.hashCode() + Objects.hashCode(GotoWaypoint.this.d_room);
        }

        protected GotoWaypoint getWaypoint() {
            return GotoWaypoint.this;
        }

        @Override
        public IUnreachable getUnreachable(IEgressComp source) {
            if (MerlinUtil.isConnected(source, GotoWaypoint.this)) {
                return null;
            }
            return new IUnreachable(){

                @Override
                public SimError getError(IMerlinObj source) {
                    String name = MerlinUtil.getName(source);
                    return new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("\"%s\" cannot reach the next waypoint."), name), String.format(Intl.intl("Move \"%s,\" move the next waypoint, or connect their rooms."), name), source, GotoWaypoint.this);
                }
            };
        }

        @Override
        public Collection<? extends IEgressComp> getExitComponents() {
            return GotoWaypoint.this.d_room == null ? Collections.EMPTY_LIST : Arrays.asList(GotoWaypoint.this.d_room);
        }
    }
}

