/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Collection;
import java.util.List;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.IUnreachable;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.util.ILabeledEnum;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.PropertySet;

public class GotoCurrentAttractor
extends NamedMerlinObj
implements IBehaviorAction,
IDestinationAction {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<GotoCurrentAttractor> PROP_TYPES = PropertyDefs.defsInheritPropsOnlyMultiple(GotoCurrentAttractor.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
    }), List.of(NamedMerlinObj.PROPS, IBehaviorAction.PROP_TYPES), Filters.reject(NamedMerlinObj.NAME));
    public static final DisplayProp<UnitDouble> PROP_ARRIVAL_RADIUS = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"GotoCurrentAttractor.ARRIVAL_RADIUS", new UnitDouble(1.0, SI.METER), Intl.intl("Arrival Radius"), Intl.intl("The distance to the trigger at which the occupant decides they have reached the trigger."), 0).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    public static final DisplayProp<Tracking> PROP_TRACKING = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"GotoCurrentAttractor.TRACKING", Tracking.class, Tracking.DYNAMIC_ONCE, Intl.intl("Tracking"), Intl.intl("Defines how the occupant will track the trigger.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v.name)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().options(Tracking.values())).attrFinish();
    public static final DisplayProp<TargetUnreachable> PROP_UNREACHABLE = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"GotoCurrentAttractor.PROP_UNREACHABLE", TargetUnreachable.class, TargetUnreachable.SKIP, Intl.intl("Destination unreachable"), Intl.intl("Defines what to do if the trigger becomes unreachable, such as if all paths to the trigger become blocked.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> v.name)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().options(TargetUnreachable.values())).attrFinish();
    public static final DisplayProp<String> NAME = GotoCurrentAttractor.buildCustomNameProp(PROP_TYPES).attrGetter(obj -> {
        String name = obj.getStoredName();
        if (name == null) {
            name = Intl.intl("Goto Current Trigger");
        }
        return name;
    }, STORED_NAME).attrFinish();
    private PropertySet d_props = new PropertySet();

    public GotoCurrentAttractor() {
        super(null);
    }

    public GotoCurrentAttractor(String name, UnitDouble arriveRad, TargetUnreachable unreachable) {
        super(name);
        this.set(PROP_ARRIVAL_RADIUS, arriveRad);
        this.set(PROP_UNREACHABLE, unreachable);
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public IDestination getDestination() {
        return Destination.INSTANCE;
    }

    private static class Destination
    implements IDestination {
        public static final Destination INSTANCE = new Destination();

        private Destination() {
        }

        @Override
        public IUnreachable getUnreachable(IEgressComp source) {
            return null;
        }

        @Override
        public Collection<? extends IEgressComp> getExitComponents() throws Exception {
            throw new Exception();
        }
    }

    public static enum TargetUnreachable implements ILabeledEnum,
    ILabeled
    {
        SKIP(Intl.intl("Skip action"), Intl.intl("This action is skipped.")),
        WAIT(Intl.intl("Wait"), Intl.intl("The occupant waits until the trigger becomes reachable again."));

        public final String name;
        public final String desc;

        private TargetUnreachable(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Tracking implements ILabeledEnum,
    ILabeled
    {
        DYNAMIC_ONCE(Intl.intl("Go to trigger"), Intl.intl("The occupant seeks their current trigger until they are within the arrival\nradius and there is a clear line-of-sight to the trigger.")),
        DYNAMIC_CONTINUOUS(Intl.intl("Follow trigger"), Intl.intl("The occupant seeks and follows the trigger as long as the\ntrigger still exists.")),
        INITIAL_LOC(Intl.intl("Go to initial location"), Intl.intl("The occupant records the location of their current trigger when the action\nis started, and then seeks that point until they are within the arrival radius\nand there is a clear line-of-sight to the point.\nNOTE: The trigger might not still be at the point when the occupant\narrives."));

        public final String name;
        public final String desc;

        private Tracking(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

