/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.gui.ObjSources;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.PropertyDefsFramework;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.theUtil;

public class DestroyAttractor
extends NamedMerlinObj
implements IBehaviorAction,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    private static final long serialVersionUID = 7824814114567292619L;
    public static final PropertyDefs<DestroyAttractor> PROP_TYPES = PropertyDefs.defsInheritPropsOnlyMultiple(DestroyAttractor.class, PropertyDefsFramework.none(), List.of(NamedMerlinObj.PROPS, IBehaviorAction.PROP_TYPES), Filters.reject(NamedMerlinObj.NAME));
    public static final DisplayProp<Set<Attractor>> PROP_ATTRACTORS = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("DestroyAttractor.ATTRACTORS", Set.class, DisplayProps.emptySet(Attractor.class), Intl.intl("Triggers"), Intl.intl("<html>The set of triggers to destroy.<br>Only triggers previously created by this occupant will be destroyed.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(attractors -> MerlinUtil.formatNamedSet(attractors, Intl.intl("[none]")))).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(DestroyAttractor::getAttractors, Stream.empty()).attrSetter(DestroyAttractor::setAttractors, null).attrDependency(prop -> Dependencies.newDependencyInSet(prop, DLink.WEAK, Attractor.class, Attractor::isTemplate)).attrComparisonEditor(PropComparisons.factory().multiObj(md -> ObjSources.getAttractorTemplates(md, Intl.intl("[none]")))).attrFinish();
    public static final DisplayProp<String> NAME = DestroyAttractor.buildCustomNameProp(PROP_TYPES).attrGetter(obj -> {
        String name = obj.getStoredName();
        if (name != null) {
            return name;
        }
        if (obj.d_attractors.size() == 1) {
            return String.format(Intl.intl("Destroy %s"), obj.d_attractors.iterator().next().getName());
        }
        return Intl.intl("Destroy Triggers");
    }, Stream.of(STORED_NAME, PROP_ATTRACTORS)).attrFinish();
    private Set<Attractor> d_attractors;

    public DestroyAttractor(Set<Attractor> attractors) {
        super(null);
        this.d_attractors = attractors;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    public Set<Attractor> getAttractors() {
        return Collections.unmodifiableSet(this.d_attractors);
    }

    public void setAttractors(Set<Attractor> attractors) {
        if (!theUtil.setsEqual(attractors, this.d_attractors)) {
            this.d_attractors = attractors;
            this.changedEvt(PROP_ATTRACTORS);
        }
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }
}

