/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import common.data.ClientAwareness;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import merlin.Intl;
import merlin.data.AMerlinObj;
import merlin.data.AssistedEvacTeam;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.IUnreachable;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.gui.ObjSources;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.framework.property.CompositeProp;
import thunderheadeng.gui.framework.property.CompositeProps;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.PropertyDefsFramework;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.theUtil;

public class AssistOccupants
extends AMerlinObj
implements IDestinationAction,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<AssistOccupants> PROP_TYPES = PropertyDefs.defsInheritPropsOnly(AssistOccupants.class, PropertyDefsFramework.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
    }), IBehaviorAction.PROP_TYPES, Filters.reject(NamedMerlinObj.NAME));
    public static final DisplayProp<AssistedEvacTeam> TEAM = ((TeciDisplayProps.Builder)DisplayProps.build((Object)"AssistOccupants.TEAM", AssistedEvacTeam.class, null, Intl.intl("Team"), Intl.intl("The team on which the occupant will assist.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyAsValue(prop, DLink.STRONG, AssistedEvacTeam.class, Predicates.alwaysTrue())).attrComparisonEditor(PropComparisons.factory().singleObj(md -> ObjSources.getEvacTeams(md, null))).attrFinish();
    public static final DisplayProp<Set<IEgressOccupiable>> ROOMS = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"AssistOccupants.ROOMS", theUtil.makeGeneric(Set.class), Collections.emptySet(), Intl.intl("Rooms"), Intl.intl("The rooms in which this assistant can assist clients.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(rooms -> MerlinUtil.formatNamedSet(rooms, Intl.intl("[none]")))).attrStoreAsPlainOldData(PROP_TYPES).attrDependency(prop -> Dependencies.newDependencyInSet(prop, DLink.WEAK, IEgressOccupiable.class, Predicates.alwaysTrue())).attrComparisonEditor(PropComparisons.factory().multiObj(md -> ObjSources.getRooms(md, Intl.intl("[none]")))).attrFinish();
    public static final DisplayProp<ClientAwareness> CLIENT_AWARENESS = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"AssistOccupants.CLIENT_AWARENESS", ClientAwareness.class, ClientAwareness.GLOBAL, Intl.intl("Client Awareness"), Intl.intl("Determines which clients the assistant can assist.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(awareness -> awareness.name)).attrStoreAsPlainOldData(PROP_TYPES).attrSetter((prop, obj, val) -> {
        obj.pauseUpdates();
        if (PROP_TYPES.compareAndSetDirect((AssistOccupants)obj, prop, val) && val != ClientAwareness.ROOMS) {
            obj.set(ROOMS, Collections.emptySet());
        }
        obj.resumeUpdates();
    }, (prop, obj, val) -> PROP_TYPES.compareAndSetDirect((AssistOccupants)obj, prop, val)).attrUndoPropRestore(false, ROOMS).attrComparisonEditor(PropComparisons.factory().options(ClientAwareness.values())).attrFinish();
    public static final String AWARENESS_RADIUS_DISABLED_STR = Intl.intl("INF");
    public static final DisplayProp<UnitDouble> AWARENESS_RADIUS = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"AssistOccupants.AWARENESS_RADIUS", new UnitDouble(Double.POSITIVE_INFINITY, SI.METER), Intl.intl("Awareness Radius"), String.format(Intl.intl("The assistant will only assist clients they have been within this distance to.\n\"%s\" may be specified to disable distance requirements."), AWARENESS_RADIUS_DISABLED_STR), 0).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrFinish();
    static final CompositeProp AWARENESS_COMP_PROP = (CompositeProp)((CompositeProps.CompositePropBuilder)CompositeProps.build(CLIENT_AWARENESS, ROOMS, AWARENESS_RADIUS).attrMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsComposite(PROP_TYPES).attrFinish();
    public static final DisplayProp<String> NAME = PROP_TYPES.storeAsReadOnly(NamedMerlinObj.NAME).attrGetter(AssistOccupants::getName, TEAM).attrFinish();
    private PropertySet d_props = new PropertySet();

    public AssistOccupants(AssistedEvacTeam team) {
        this.d_props.set(TEAM, team);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public boolean mustBeLast() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public String getName() {
        return String.format(Intl.intl("Assist <%s>"), this.get(TEAM).getName());
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    @Override
    public IDestination getDestination() {
        return new Destination();
    }

    private int surrogateHashCode() {
        return this.hashCode();
    }

    public class Destination
    implements IDestination {
        @Override
        public IUnreachable getUnreachable(IEgressComp source) {
            return null;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof Destination && ((Destination)obj).getAction().get(TEAM).equals(AssistOccupants.this.get(TEAM));
        }

        @Override
        public int hashCode() {
            return 0xFA9832F ^ this.getAction().get(TEAM).hashCode();
        }

        protected AssistOccupants getAction() {
            return AssistOccupants.this;
        }

        @Override
        public Collection<? extends IEgressComp> getExitComponents() throws Exception {
            throw new Exception();
        }
    }
}

