/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.data.MerlinData;
import merlin.data.PredefTags;
import merlin.data.egress.agents.ConstOccCount;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.IOccCount;
import merlin.data.egress.agents.Occupancy;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.SpeedModifier;
import merlin.data.egress.scripting.GotoWaypoint;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.framework.property.CompositeProp;
import thunderheadeng.gui.framework.property.CompositeProps;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.PropertyDefsFramework;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.units.UnitDouble;

public interface IEgressOccupiable
extends IEgressComp {
    public static final PropertyDefs<IEgressOccupiable> PROPS = PropertyDefs.defsRoot(IEgressOccupiable.class, PropertyDefs.none());
    public static final DisplayProp<UnitDouble> AREA = (DisplayProp)DisplayProps.build((Object)"IEgressOccupiable.AREA", null, Intl.intl("Area"), "", 4).attrStoreAsReadOnly(PROPS).attrGetter(IEgressOccupiable::getArea, Stream.empty()).attrSurrogateEquals(PropertyDefsFramework::defaultSurrogateEquals).attrComparisonEditor(PropComparisons.factory().unitdouble(4)).attrFinish();
    public static final DisplayProp<Integer> OCC_COUNT = (DisplayProp)DisplayProps.build((Object)"IEgressOccupiable.OCC_COUNT", 0, Intl.intl("Pers"), "The amount of occupants currently positioned within the room.").attrStoreAsReadOnly(PROPS).attrGetter(obj -> obj.getOccupants().size(), Stream.empty()).attrComparisonEditor(PropComparisons.factory().integer()).attrFinish();
    public static final DisplayProp<SpeedModifier> SPEED_MODIFIER = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"IEgressOccupiable.SPEED_MODIFIER", SpeedModifier.class, SpeedModifier.IDENTITY, Intl.intl("Speed Modifier"), Intl.intl("Modifier applied to the speed of occupants in the room.")).attrFormatValueWithToString()).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROPS).attrGetter(IEgressOccupiable::getSpeedModifier, Stream.empty()).attrSetter(IEgressOccupiable::setSpeedModifier, null).attrComparisonEditor(PropComparisons.factory().convert(speedMod -> speedMod.type, PropComparisons.factory().options(SpeedModifier.Type.values()))).attrFinish();
    public static final Object OCCUPANCY_CHANGED = "IEgressOccupiable.OCCUPANCY_CHANGED";
    public static final DisplayProp<IOccCount> PROP_CAPACITY = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"AEgressComp.CAPACITY", IOccCount.class, new ConstOccCount(50), Intl.intl("Capacity"), Intl.intl("If checked, sets a custom capacity limit for selected components.<br>If unchecked, no capacity limit is used for selected components.")).attrFormatValueWithToString()).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROPS).attrGetter(IEgressOccupiable::getCapacity, Stream.empty()).attrSetter(IEgressOccupiable::setCapacity, null).attrFinish();
    public static final DisplayProp<Boolean> PROP_CAPACITY_ENABLED = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"AEgressComp.CAPACITY_ENABLED", false, Intl.intl("Capacity Enabled"), Intl.intl("Whether or not to enforce the set Capacity.")).attrFormatValue(v -> v != false ? Intl.intl("Enabled") : Intl.intl("Disabled"))).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROPS).attrGetter(IEgressOccupiable::getCapacityEnabled, Stream.empty()).attrSetter(IEgressOccupiable::setCapacityEnabled, null).attrComparisonEditor(PropComparisons.factory().booleanCustom(Intl.intl("is Enabled"), Intl.intl("is Disabled"))).attrFinish();
    public static final CompositeProp CAPACITY_PROPS = (CompositeProp)((CompositeProps.CompositePropBuilder)CompositeProps.build(PROP_CAPACITY, PROP_CAPACITY_ENABLED).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsComposite(PROPS).attrFinish();
    public static final DisplayProp<Boolean> REFUGE_AREA = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"IEgressOccupiable.RefugeArea", false, Intl.intl("Refuge Area"), Intl.intl("Specifies whether the component is considered a refuge area.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsWrapper(PROPS).attrGetter(IEgressOccupiable::getRefugeArea, Stream.of(PREDEFINED_OCC_TAGS)).attrSetter(IEgressOccupiable::setRefugeArea, null).attrComparisonEditor(PropComparisons.factory().booleanTrueFalse()).attrFinish();

    public UnitDouble getArea();

    public Occupancy getOccupancy();

    public boolean isWalkable(Point3d var1);

    public boolean getOccupantsAllowed();

    public Set<EgressAgent> getOccupants();

    public Set<GotoWaypoint> getWaypoints();

    public IOccCount getCapacity();

    public void setCapacity(IOccCount var1);

    public boolean getCapacityEnabled();

    public void setCapacityEnabled(boolean var1);

    public SpeedModifier getSpeedModifier();

    public void setSpeedModifier(SpeedModifier var1);

    public Model getModel();

    default public Predicate<Edge> getBoundaryEdgeFilter() {
        return edge -> !edge.faces.isEmpty() && edge.partOfGroup(1);
    }

    public boolean isModelCached();

    @Override
    public IGeomNode getGeom();

    default public boolean getRefugeArea() {
        return ((Set)this.get(PREDEFINED_OCC_TAGS)).contains(PredefTags.SAFE.name);
    }

    default public void setRefugeArea(boolean isRefuge) {
        String tag = PredefTags.SAFE.name;
        HashSet<String> d_tags = (HashSet<String>)this.get(PREDEFINED_OCC_TAGS);
        if (isRefuge && !d_tags.contains(tag)) {
            d_tags = new HashSet<String>(d_tags);
            d_tags.add(tag);
        } else if (!isRefuge && d_tags.contains(tag)) {
            d_tags = new HashSet(d_tags);
            d_tags.remove(tag);
        }
        this.set(PREDEFINED_OCC_TAGS, d_tags);
        this.changedEvt(REFUGE_AREA);
    }
}

