/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import java.io.Serializable;
import java.util.function.Function;
import javax.vecmath.Vector2d;
import merlin.data.egress.geom.EgressDoorDir;
import thunderheadeng.util.theUtil;
import thunderheadeng.util.value.ConstVariant;
import thunderheadeng.util.value.DiscreteVariant;
import thunderheadeng.util.value.IVariant;
import thunderheadeng.util.value.VariantUtil;

public class EgressConnectorState
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final EgressConnectorState CONNECTOR_OPEN = new EgressConnectorState(true, false, null);
    public static final EgressConnectorState CONNECTOR_CLOSED = new EgressConnectorState(false, true, null);
    public final boolean open;
    public final boolean closed;
    public final Vector2d openDir;

    public EgressConnectorState(boolean open, boolean closed, Vector2d openDir) {
        this.open = open;
        this.closed = closed;
        this.openDir = openDir;
        assert (openDir == null ? open ^ closed : !open && !closed);
    }

    public EgressDoorDir toDoorDir() {
        if (this.open) {
            return EgressDoorDir.ALL;
        }
        if (this.closed) {
            return EgressDoorDir.NONE;
        }
        assert (this.openDir != null);
        return EgressDoorDir.toDir(this.openDir);
    }

    public static IVariant<EgressDoorDir> getDoorDirStateVariant(IVariant<EgressConnectorState> state) {
        if (state instanceof ConstVariant) {
            return new ConstVariant<EgressDoorDir>(((EgressConnectorState)((ConstVariant)state).value).toDoorDir());
        }
        if (state instanceof DiscreteVariant) {
            DiscreteVariant discreteVarState = (DiscreteVariant)state;
            EgressDoorDir initVal = ((EgressConnectorState)discreteVarState.initVal).toDoorDir();
            DiscreteVariant.Entry[] entries = new DiscreteVariant.Entry[discreteVarState.entries.length];
            for (int i = 0; i < discreteVarState.entries.length; ++i) {
                entries[i] = new DiscreteVariant.Entry<EgressDoorDir>(discreteVarState.entries[i].t, ((EgressConnectorState)discreteVarState.entries[i].val).toDoorDir());
            }
            return VariantUtil.newVariant(initVal, entries);
        }
        assert (false);
        return null;
    }

    public static IVariant<EgressConnectorState> getConnectorStateVariant(IVariant<EgressDoorDir> state, Function<EgressDoorDir, Vector2d> adjustForDoor) {
        Function<EgressDoorDir, EgressConnectorState> processDoorDir = doorDir -> {
            switch (doorDir) {
                case ALL: {
                    return CONNECTOR_OPEN;
                }
                case NONE: {
                    return CONNECTOR_CLOSED;
                }
            }
            return new EgressConnectorState(false, false, (Vector2d)adjustForDoor.apply((EgressDoorDir)doorDir));
        };
        if (state instanceof ConstVariant) {
            return new ConstVariant<EgressConnectorState>(processDoorDir.apply((EgressDoorDir)((ConstVariant)state).value));
        }
        if (state instanceof DiscreteVariant) {
            DiscreteVariant discreteVarState = (DiscreteVariant)state;
            EgressConnectorState initVal = processDoorDir.apply((EgressDoorDir)discreteVarState.initVal);
            DiscreteVariant.Entry[] entries = new DiscreteVariant.Entry[discreteVarState.entries.length];
            for (int i = 0; i < discreteVarState.entries.length; ++i) {
                entries[i] = new DiscreteVariant.Entry<EgressConnectorState>(discreteVarState.entries[i].t, processDoorDir.apply((EgressDoorDir)discreteVarState.entries[i].val));
            }
            return VariantUtil.newVariant(initVal, entries);
        }
        assert (false);
        return null;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + theUtil.hashCode(this.closed);
        hash = 31 * hash + theUtil.hashCode(this.open);
        hash = 31 * hash + theUtil.hashCode(this.openDir);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EgressConnectorState)) {
            return false;
        }
        EgressConnectorState state = (EgressConnectorState)obj;
        return state.closed == this.closed && state.open == this.open && state.openDir == this.openDir;
    }
}

