/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import merlin.data.SimParams;
import merlin.data.egress.geom.IEgressFlowrate;
import merlin.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;

public class DoorUtil {
    public static IEgressFlowrate getFlowrate(SimParams sp, UnitDouble doorWidth) {
        if (sp.get(SimParams.USE_DOOR_QUEUES).booleanValue() && sp.get(SimParams.DOOR_FLOW_DENSITY_FLAG).booleanValue()) {
            return IEgressFlowrate.FROM_DENSITY;
        }
        if (sp.get(SimParams.USE_DOOR_QUEUES).booleanValue()) {
            UnitDouble specFlow = sp.get(SimParams.REACTIVE_STEERING) != false ? sp.get(SimParams.SPECIFIC_FLOW_STEERING) : SIUS.newud(1.32, 12);
            return new IEgressFlowrate.Limited(DoorUtil.getFlowrate(specFlow, sp.get(SimParams.DOOR_BOUNDARY_LAYER), doorWidth));
        }
        return IEgressFlowrate.UNLIMITED;
    }

    public static UnitDouble getFlowrate(UnitDouble sflowrate, UnitDouble doorBoundaryLayer, UnitDouble doorWidth) {
        UnitDouble blayer = doorBoundaryLayer.scale(2.0);
        doorWidth = UnitDouble.max(doorWidth.sub(blayer), SIUS.newud(0.0, 0));
        return sflowrate.multiply(doorWidth);
    }
}

