/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import merlin.data.AMerlinObj;
import merlin.data.IMerlinObj;
import merlin.data.IOpacity;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.Opacity;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.util.MerlinDepSnapshot;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;

public abstract class AEgressComp
extends NamedMerlinObj
implements IEgressComp,
Serializable,
Cloneable,
ISurrogate,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<AEgressComp> PROP_TYPES = PropertyDefs.defsInheritPropsOnlyMultiple(AEgressComp.class, PropertyDefs.none(), List.of(NamedMerlinObj.PROPS, IEgressComp.PROPS), Filters.acceptAll());
    public static final TypedProp<Boolean> STORED_VISIBILITY = ((TypedProps.Builder)TypedProps.build((Object)"AEgressComp.STORED_VISIBILITY", true).attrMarkers(MerlinData.VISIBILITY_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrGetter(AEgressComp::getStoredVisibility, Stream.empty()).attrSetter(AEgressComp::setStoredVisibility, null).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Boolean> ENABLED = PROP_TYPES.storeAsPlainOldData(MerlinData.ENABLED).attrGetter(AEgressComp::isEnabled, Stream.empty()).attrSetter(AEgressComp::setEnabled, null).attrUndoPropRestoreAll().attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Boolean> VISIBILITY = PROP_TYPES.storeAsWrapper(MerlinData.VISIBILITY).attrGetter(AEgressComp::isVisible, Stream.of(STORED_VISIBILITY, MerlinData.ENABLED)).attrSetter(AEgressComp::setVisible, (obj, val) -> {
        obj.d_visible = val;
    }).attrUndoPropRestore(false, STORED_VISIBILITY).attrFinish();
    public static final DisplayProp<IOpacity> OPACITY = PROP_TYPES.storeAsPlainOldData(MerlinData.OPACITY).attrGetter(obj -> new Opacity(obj.getOpacity()), Stream.empty()).attrSetter((obj, val) -> obj.setOpacity(val.getValue()), null).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Color> COLOR = PROP_TYPES.storeAsPlainOldData(MerlinData.COLOR).attrGetter(AEgressComp::getColor, Stream.empty()).attrSetter(AEgressComp::setColor, null).attrFinish();
    public static final DisplayProp<Color> SEARCH_COLOR = PROP_TYPES.storeAsReadOnly(MerlinData.SEARCH_COLOR).attrGetter(comp -> comp.get(COLOR), COLOR).attrFinish();
    public static final DisplayProp<Set<Tag>> TAGS = TagsUtil.buildTagsProp(PROP_TYPES).attrGetter(AEgressComp::getTags, Stream.empty()).attrSetter(AEgressComp::setTags, null).attrFinish();
    private boolean d_visible = true;
    private boolean d_enabled = true;
    private Color d_color = null;
    private float d_transparency = 0.0f;
    private Set<Tag> d_tags = Collections.emptySet();

    public AEgressComp(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_enabled = true;
        this.d_tags = Collections.emptySet();
        in.defaultReadObject();
    }

    @Override
    public Collection<Pair<IEgressComp, IEgressComp.ConflictType>> getConflicts() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Color getColor() {
        return this.d_color;
    }

    @Override
    public void setColor(Color color) {
        if (!Objects.equals(this.d_color, color)) {
            this.d_color = color;
            this.changedEvt(COLOR);
        }
    }

    @Override
    public void setOpacity(float opacity) {
        float trans = 1.0f - opacity;
        if (theUtil.eq(trans, this.d_transparency, 0.0)) {
            return;
        }
        this.d_transparency = trans;
        this.changedEvt(OPACITY);
    }

    @Override
    public float getOpacity() {
        return 1.0f - this.d_transparency;
    }

    @Override
    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(MerlinData.ENABLED, EventChannel.EVT_GENERAL, MerlinData.TOPOLOGY);
        }
    }

    private Set<Tag> getTags() {
        return Collections.unmodifiableSet(this.d_tags);
    }

    private void setTags(Set<Tag> tags) {
        if (Objects.equals(this.d_tags, tags)) {
            return;
        }
        this.d_tags = tags;
        this.changedEvt(TAGS);
    }

    public Collection<AMerlinObj> getConnObjectsForEnable(MerlinData md, Supplier<MerlinDepSnapshot> deps) {
        return Collections.emptyList();
    }

    public final boolean getStoredVisibility() {
        return this.d_visible;
    }

    public final void setStoredVisibility(boolean visible) {
        if (this.d_visible == visible) {
            return;
        }
        this.d_visible = visible;
        this.changedEvt(STORED_VISIBILITY);
    }

    @Override
    public final void setVisible(boolean visible) {
        this.set(STORED_VISIBILITY, visible);
    }

    @Override
    public final boolean isVisible() {
        return this.d_visible && this.d_enabled;
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }
}

