/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.elevators;

import java.util.ArrayList;
import java.util.Arrays;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.elevators.ElevatorDoor;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressOccupiable;

public class ElevatorUtil {
    public static Floor getFloor(MerlinData md, Object obj) {
        if (obj instanceof ElevatorRoom) {
            return ElevatorUtil.getFloor(md, (ElevatorRoom)obj);
        }
        while (obj != null && !(obj instanceof Floor)) {
            obj = md.hierarchy.getParent(obj);
        }
        return (Floor)obj;
    }

    public static Floor getFloor(MerlinData md, ElevatorRoom elevatorRoom) {
        return ElevatorUtil.getFloor(md, elevatorRoom, false);
    }

    public static Floor getFloor(MerlinData md, ElevatorRoom room, boolean includeDisconnected) {
        for (ElevatorDoor door : room.getElevatorDoors()) {
            Floor floor = ElevatorUtil.getFloor(md, room, door, includeDisconnected);
            if (floor == null) continue;
            return floor;
        }
        return null;
    }

    public static Floor getFloor(MerlinData md, ElevatorRoom elevatorRoom, ElevatorDoor door) {
        return ElevatorUtil.getFloor(md, elevatorRoom, door, false);
    }

    public static Floor getFloor(MerlinData md, ElevatorRoom elevatorRoom, ElevatorDoor door, boolean includeDisconnected) {
        EgressRoom disconnectedRoom;
        ArrayList<IEgressOccupiable> connectedToDoor = new ArrayList<IEgressOccupiable>(Arrays.asList(door.getConnectedComps()));
        if (includeDisconnected && (disconnectedRoom = door.getDisconnectedRoom()) != null) {
            connectedToDoor.add(disconnectedRoom);
        }
        for (IEgressOccupiable connRoom : connectedToDoor) {
            if (connRoom == elevatorRoom) continue;
            Object parent = md.hierarchy.getParent(connRoom);
            while (parent != null && !(parent instanceof Floor)) {
                parent = md.hierarchy.getParent(parent);
            }
            if (parent == null) continue;
            return (Floor)parent;
        }
        return null;
    }
}

