/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.elevators;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.IMerlinObj;
import merlin.data.INameGenerator;
import merlin.data.SequentialNameGen;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorGroup;
import thunderheadeng.util.TypeFilter;

public class ElevatorRoot
extends GeomComposite<Elevator> {
    private static final long serialVersionUID = 342354923948723948L;
    private INameGenerator d_nameGen = new SequentialNameGen(Intl.intl("Elevator"), 2);
    private static final Predicate<IMerlinObj> s_filter = new TypeFilter<IMerlinObj>(Elevator.class, ElevatorGroup.class);

    public ElevatorRoot() {
        super(Intl.intl("Elevators"));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_nameGen == null) {
            this.d_nameGen = new SequentialNameGen(Intl.intl("Elevator"), 2);
        }
    }

    public INameGenerator getNameGen() {
        return this.d_nameGen;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof ElevatorRoot)) {
            return;
        }
        ElevatorRoot er = (ElevatorRoot)obj;
        this.pauseUpdates();
        super.restoreFrom(obj);
        this.d_nameGen = er.d_nameGen;
        this.resumeUpdates();
    }

    @Override
    public void clear() {
        this.d_nameGen.reset();
        super.clear();
    }

    @Override
    public void add(IMerlinObj obj) {
        if (!(obj instanceof Elevator) && !(obj instanceof ElevatorGroup)) {
            return;
        }
        super.add(obj);
    }

    @Override
    public Predicate<IMerlinObj> getFilter() {
        return s_filter;
    }

    @Override
    public Composite<?> newGroup(String name) {
        return new ElevatorGroup(name);
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Elevator Group");
    }
}

