/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import inferno.geom.Inter;
import inferno.sim.VehicleBody;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.data.AMerlinObj;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.agents.IAvatar;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.geom.Geometry;
import merlin.util.ILabeledEnum;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.NGon;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.gui.ILabeled;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.gui.value.ObjComboBox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Sets;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;

public class VehicleShape
extends AMerlinObj
implements Serializable,
IMerlinObj,
ISurrogate,
IDirectDependent<MerlinData> {
    private static final long serialVersionUID = -425533861258326633L;
    public static final PropertyDefs<VehicleShape> PROP_TYPES = PropertyDefs.defsRoot(VehicleShape.class, PropertyDefs.serializedOnly(obj -> obj.d_props, obj -> {
        obj.d_props = new PropertySet();
    }));
    public static final DisplayProp<Set<Tag>> PROP_TAGS = TagsUtil.buildTagsProp(PROP_TYPES).attrSurrogateEquals(null).attrFinish();
    private static final Point3d[] pointsWheelchair;
    public static final IPolygon POINTS_DEFAULT_WHEELCHAIR;
    public static final Point3d[] ATTACHED_AGENTS_POSITIONS_DEFAULT_WHEELCHAIR;
    private static final Point3d[] pointsBed;
    public static final IPolygon POINTS_DEFAULT_BED_TWO_NURSES;
    public static final Point3d[] ATTACHED_AGENTS_POSITIONS_DEFAULT_BED_TWO_NURSES;
    public static final VehicleShape NONE;
    public static final DisplayProp<String> PROP_NAME;
    public static final DisplayProp<String> SEARCH_NAME;
    public static final DisplayProp<String> PROP_DESC;
    public static final DisplayProp<String> SEARCH_DESC;
    public static final DisplayProp<UnitDouble> PROP_HEIGHT;
    @Deprecated
    public static final TypedProp<AnimType> PROP_ANIM_TYPE;
    public static final DisplayProp<Set<String>> PROP_ANIM_TAGS;
    public static final DisplayProp<UnitPoint3D> PROP_OCCAVATAR_OFFSET;
    public static final DisplayProp<IAvatar> PROP_MODEL;
    public static final DisplayProp<IPolygon> PROP_POINTS;
    public static final DisplayProp<Point3d[]> PROP_ATTACHED_AGENTS_POSITIONS;
    public static final DisplayProp<Point3d> PROP_PIVOT;
    public static final DisplayProp<Boolean> PROP_ALLOW_LATERAL;
    private PropertySet d_props = new PropertySet();

    private static PropComparisons.ObjSrcSupplier<IAvatar> getAvatarSrc() {
        return PropComparisons.getAvatarSrc(ResourceAvatar.Type.VEHICLE, IAvatar.HIDDEN_NAME);
    }

    private static String formatIPolygon(IPolygon p) {
        if (p.getNumLoops() < 0 || p.getNumPoints(0) < 1) {
            return "[]";
        }
        Object s = "[";
        for (int i = 0; i < p.getNumPoints(0); ++i) {
            if (i > 0) {
                s = (String)s + ", ";
            }
            Point3d point = p.getPoint(0, i);
            s = (String)s + new Point2d(point.x, point.y).toString();
        }
        s = (String)s + "]";
        return s;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_props.isDefined(PROP_ANIM_TYPE)) {
            AnimType type = this.d_props.get(PROP_ANIM_TYPE);
            this.d_props.set(PROP_ANIM_TAGS, type.tags);
            this.d_props.remove(PROP_ANIM_TYPE);
        }
    }

    @Override
    public String getName() {
        return this.get(PROP_NAME);
    }

    @Override
    public void setName(String name) {
        this.set(PROP_NAME, name);
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROP_TYPES;
    }

    public Point3d[] getBodyPoints(Point3d loc, double angle) {
        Point3d[] bodyShapePoints = PolyUtil.getLoop(this.get(PROP_POINTS), 0, false);
        return VehicleShape.getPoints(loc, angle, bodyShapePoints);
    }

    public Point3d[] getBodyPoints(double angle) {
        Point3d[] bodyShapePoints = this.getBodyPoints();
        return VehicleShape.getPoints(angle, bodyShapePoints);
    }

    public Point3d[] getBodyPoints() {
        return PolyUtil.getLoop(this.get(PROP_POINTS), 0, false);
    }

    public Point3d[] getAttachedPositions(Point3d loc, double angle) {
        Point3d[] attachedPositions = this.get(PROP_ATTACHED_AGENTS_POSITIONS);
        return VehicleShape.getPoints(loc, angle, attachedPositions);
    }

    public Point3d[] getAttachedPositions(double angle) {
        Point3d[] attachedPositions = this.get(PROP_ATTACHED_AGENTS_POSITIONS);
        return VehicleShape.getPoints(angle, attachedPositions);
    }

    private static Point3d[] getPoints(Point3d loc, double angle, Point3d[] points) {
        Point3d[] pointsOnFace = VehicleShape.getPoints(angle, points);
        for (int i = 0; i < pointsOnFace.length; ++i) {
            pointsOnFace[i].add(loc);
        }
        return pointsOnFace;
    }

    private static Point3d[] getPoints(double angleRad, Point3d[] points) {
        Point3d origin = new Point3d(0.0, 0.0, 0.0);
        Point3d[] pointsOnFace = new Point3d[points.length];
        for (int i = 0; i < points.length; ++i) {
            pointsOnFace[i] = new Point3d(points[i]);
            Inter.rotateTuple2D(pointsOnFace[i], angleRad, origin);
        }
        return pointsOnFace;
    }

    public Point3d[] getOuterPoints(Point3d loc, double angle) {
        Point3d[] pointsOnFace = this.getBodyPoints(loc, angle);
        Point3d[] attachedAgentsPositions = this.getAttachedPositions(loc, angle);
        return VehicleBody.calcOuterPoints(pointsOnFace, Arrays.asList(attachedAgentsPositions));
    }

    public static Point3d[] get3dPoints(Point3d[] points, double height) {
        Point3d[] ret = new Point3d[points.length * 2];
        for (int i = 0; i < points.length; ++i) {
            ret[i] = points[i];
            ret[i + points.length] = new Point3d(points[i].x, points[i].y, points[i].z + height);
        }
        return ret;
    }

    private static Point3d[] generateRectangle(double length, double width) {
        int i = 0;
        Point3d[] points = new Point3d[4];
        points[i++] = new Point3d(-length / 2.0, -width / 2.0, 0.0);
        points[i++] = new Point3d(length / 2.0, -width / 2.0, 0.0);
        points[i++] = new Point3d(length / 2.0, width / 2.0, 0.0);
        points[i++] = new Point3d(-length / 2.0, width / 2.0, 0.0);
        return points;
    }

    private int surrogateHashCode() {
        int hash = 7;
        for (Point3d p : this.getBodyPoints()) {
            hash = 31 * hash + theUtil.hashCode(p);
        }
        hash = 31 * hash + theUtil.hashCode(this.get(PROP_NAME));
        return hash;
    }

    public Set<Tag> getTags() {
        return this.get(MerlinData.TAGS);
    }

    public void setTags(Set<Tag> newTags) {
        this.set(MerlinData.TAGS, newTags);
    }

    public String toString() {
        return this.getName();
    }

    static {
        double widthWC = 0.76;
        double lengthWC = 1.32;
        double fullLengthWC = 1.72;
        pointsWheelchair = VehicleShape.generateRectangle(lengthWC, widthWC);
        POINTS_DEFAULT_WHEELCHAIR = new NGon(pointsWheelchair);
        Point3d p1 = new Point3d(-(fullLengthWC / 2.0 - 0.15), 0.0, 0.0);
        ATTACHED_AGENTS_POSITIONS_DEFAULT_WHEELCHAIR = new Point3d[]{p1};
        double widthB = 1.0;
        double lengthB = 2.15;
        double fullLengthB = lengthB + 0.6;
        pointsBed = VehicleShape.generateRectangle(lengthB, widthB);
        POINTS_DEFAULT_BED_TWO_NURSES = new NGon(pointsBed);
        Point3d p2 = new Point3d(-(fullLengthB / 2.0 - 0.15), 0.0, 0.0);
        Point3d p3 = new Point3d(fullLengthB / 2.0 - 0.15, 0.0, 0.0);
        ATTACHED_AGENTS_POSITIONS_DEFAULT_BED_TWO_NURSES = new Point3d[]{p2, p3};
        NONE = null;
        PROP_NAME = (DisplayProp)DisplayProps.build((Object)"VehicleShape.NAME", "", Intl.intl("Name"), "").attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
        SEARCH_NAME = PROP_TYPES.storeDirectWrapper(NamedMerlinObj.NAME, PROP_NAME).attrFinish();
        PROP_DESC = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"VehicleShape.DESC", "", Intl.intl("Description"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrFinish();
        SEARCH_DESC = PROP_TYPES.storeDirectWrapper(MerlinData.DESCRIPTION, PROP_DESC).attrFinish();
        PROP_HEIGHT = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"VehicleShape.HEIGHT", new UnitDouble(1.0, SI.METER), Intl.intl("Height"), "", 0).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitdouble(0)).attrSurrogateEquals(null).attrFinish();
        PROP_ANIM_TYPE = TypedProps.build("VehicleShape.ANIM_TYPE", AnimType.class, AnimType.NORMAL).attrStoreAsPlainOldData(PROP_TYPES).attrFinish();
        PROP_ANIM_TAGS = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("VehicleShape.ANIM_TAGS", Set.class, AnimType.NORMAL.tags, Intl.intl("Occupant Animation"), Intl.intl("The animation applied to occupants using the shape.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValueWithToString()).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrFinish();
        PROP_OCCAVATAR_OFFSET = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"VehicleShape.OCCAVATAR_OFFSET", UnitPoint3D.class, new UnitPoint3D(0.0, 0.0, 0.0, SI.METER), Intl.intl("Occupant Offset"), Intl.intl("The offset for the occupant's 3d model so it lines up with the shape's 3d model.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValueWithToString()).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().unitPoint3D(0)).attrSurrogateEquals(null).attrFinish();
        PROP_MODEL = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"VehicleShape.MODEL", IAvatar.class, null, Intl.intl("3D Model"), "<html>" + Intl.intl("The 3d model that represents the shape. This is shown in addition to<br>the 3d model of the occupant using the shape.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(av -> av == null ? IAvatar.HIDDEN_NAME : av.getName())).attrStoreAsPlainOldData(PROP_TYPES).attrComparisonEditor(PropComparisons.factory().singleObj(VehicleShape.getAvatarSrc(), md -> new ObjComboBox((Mediator)md, VehicleShape.getAvatarSrc().get(md), null), PropComparisons.factory().getMultiChooser(VehicleShape.getAvatarSrc()), null)).attrSurrogateEquals(null).attrFinish();
        PROP_POINTS = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"VehicleShape.POINTS", IPolygon.class, POINTS_DEFAULT_WHEELCHAIR, Intl.intl("Points"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> VehicleShape.formatIPolygon(v))).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals((shape1, poly1, shape2, poly2, ignore) -> Arrays.equals(shape1.getBodyPoints(), shape2.getBodyPoints())).attrFinish();
        PROP_ATTACHED_AGENTS_POSITIONS = (DisplayProp)((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.buildGeneric("VehicleShape.ATTACHED_AGENTS_POSITIONS", Point3d[].class, ATTACHED_AGENTS_POSITIONS_DEFAULT_WHEELCHAIR, Intl.intl("Positions of attached occupants"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(v -> Arrays.stream(v).map(p -> new Point2d(p.x, p.y).toString()).collect(Collectors.joining()))).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrFinish();
        PROP_PIVOT = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"VehicleShape.PIVOT", Point3d.class, new Point3d(0.0, 0.0, 0.0), Intl.intl("Pivot"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrComparisonEditor(PropComparisons.factory().convert(p -> new UnitPoint3D((Point3d)p, Geometry.LENGTH_UNIT), PropComparisons.factory().unitPoint3D(0))).attrFinish();
        PROP_ALLOW_LATERAL = (DisplayProp)((TeciDisplayProps.Builder)DisplayProps.build((Object)"VehicleShape.ALLOW_LATERAL", Boolean.class, false, Intl.intl("Allow sideways movement"), "<html>" + Intl.intl("Whether occupants using this shape can move in a direction they<br>are not facing in order to avoid other occupants.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(PROP_TYPES).attrSurrogateEquals(null).attrFinish();
    }

    public static enum AnimType implements ILabeledEnum
    {
        NORMAL(Intl.intl("Default"), Intl.intl("The occupant uses the animation defined in the their profile."), new String[0]),
        WHEELCHAIR(Intl.intl("Wheelchair"), Intl.intl("The occupant uses an animation where they operate a wheelchair."), "default", "wheelchair"),
        BED(Intl.intl("Bed"), Intl.intl("The occupant uses an animation where they lie on their back."), "default", "lay");

        public final String displayName;
        public final String displayDesc;
        public final Set<String> tags;

        private AnimType(String name, String desc, String ... tags) {
            this.displayName = name;
            this.displayDesc = desc;
            this.tags = Sets.fromArrayLHS(tags);
        }

        @Override
        public String getName() {
            return this.displayName;
        }

        @Override
        public String getDescription() {
            return this.displayDesc;
        }
    }

    public static enum ShapeType implements ILabeled
    {
        POLYGON(Intl.intl("Polygon")),
        CYLINDER(Intl.intl("Cylinder"));

        public final String name;

        private ShapeType(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return "";
        }
    }
}

