/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import merlin.Intl;
import merlin.data.egress.agents.IOccArea;
import org.jscience.physics.units.NonSI;
import thunderheadeng.units.UnitDouble;

public class PredefOccArea
implements IOccArea {
    public static final long serialVersionUID = 1L;
    private final Token d_token;

    public PredefOccArea(Token token) {
        this.d_token = token;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof PredefOccArea && ((PredefOccArea)obj).d_token == this.d_token;
    }

    public int hashCode() {
        return this.d_token.hashCode();
    }

    public String toString() {
        if (this.d_token.area.isInfinite()) {
            return this.getName();
        }
        return String.format(Intl.intl("%s -- %s/occupant"), this.getName(), this.getArea().toString());
    }

    @Override
    public String getName() {
        return this.d_token.desc;
    }

    @Override
    public UnitDouble getArea() {
        return this.d_token.area;
    }

    public static enum Token {
        EMPTY(Intl.intl("Empty"), Double.POSITIVE_INFINITY),
        ASSEMBLY_CONCENTRATED(Intl.intl("Assembly (Concentrated)"), 1008.0),
        ASSEMBLY_UNCONCENTRATED(Intl.intl("Assembly (Unconcentrated)"), 2160.0),
        BUSINESS_GROSS(Intl.intl("Business (gross)"), 14400.0),
        COURTROOMS(Intl.intl("Courtrooms"), 5760.0),
        INDUSTRIAL_GROSS(Intl.intl("Industrial (gross)"), 14400.0),
        INSTITUTIONAL_INPATIENT(Intl.intl("Institutional (Inpatient)"), 34560.0),
        INSTITUTIONAL_OUTPATIENT(Intl.intl("Institutional (OutPatient)"), 14400.0),
        INSTITUTIONAL_SLEEPING(Intl.intl("Institutional (Sleeping)"), 17280.0),
        LIBRARY_READING_ROOM(Intl.intl("Library (Reading Room)"), 7200.0),
        LIBRARY_STACKS(Intl.intl("Library (Stacks)"), 14400.0),
        MERCANTILE_GRADE(Intl.intl("Mercantile (grade)"), 4320.0),
        MERCANTILE_PUBLIC(Intl.intl("Mercantile (public/other)"), 8640.0),
        MERCANTILE_STORAGE(Intl.intl("Mercantile (Storage)"), 43200.0),
        PARKING_GARAGE(Intl.intl("Parking Garage"), 28800.0),
        RESIDENTIAL(Intl.intl("Residential"), 28800.0),
        RESTAURANT(Intl.intl("Restaurant"), 2160.0),
        MECHANICAL_STORAGE(Intl.intl("Mechanical/Storage"), 43200.0),
        WAITING_SPACES(Intl.intl("Waiting Spaces"), 432.0);

        public final String desc;
        public final UnitDouble area;

        private Token(String name, double areaSqIn) {
            this(name, new UnitDouble(areaSqIn, NonSI.INCH.pow(2)));
        }

        private Token(String name, UnitDouble area) {
            this.desc = name;
            this.area = area;
        }
    }
}

