/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.IOccArea;
import merlin.data.egress.agents.OccArea;
import merlin.data.egress.agents.OccAreaMgr;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;

public class Occupancy {
    public static final int OCCSPAC_UNIFORM = 0;
    public static final int OCCSPAC_RANDOM = 1;
    private final Collection<? extends IEgressOccupiable> d_rooms;
    private Collection<EgressAgent> d_occupants;
    private UnitDouble d_totalArea;
    private IOccArea d_occDensity = null;
    private Integer d_spacing = null;

    public Occupancy(IEgressOccupiable ... rooms) {
        this(Arrays.asList(rooms));
    }

    public Occupancy(Collection<? extends IEgressOccupiable> rooms) {
        this.d_rooms = rooms;
        int occCount = 0;
        for (IEgressOccupiable iEgressOccupiable : rooms) {
            occCount += iEgressOccupiable.getOccupants().size();
        }
        this.d_occupants = new ArrayList<EgressAgent>(occCount);
        for (IEgressOccupiable iEgressOccupiable : this.d_rooms) {
            this.d_occupants.addAll(iEgressOccupiable.getOccupants());
        }
    }

    public int getNumOccupants() {
        return this.d_occupants.size();
    }

    public UnitDouble getRoomArea() {
        if (this.d_totalArea == null) {
            this.d_totalArea = new UnitDouble(0.0, SI.METER.pow(2));
            for (IEgressOccupiable iEgressOccupiable : this.d_rooms) {
                this.d_totalArea = this.d_totalArea.add(iEgressOccupiable.getArea());
            }
        }
        return this.d_totalArea;
    }

    public IOccArea getOccDensity() {
        return this.getOccDensity(null);
    }

    public IOccArea getOccDensity(OccAreaMgr mgr) {
        if (this.d_occDensity == null) {
            double density = this.d_occupants.isEmpty() ? Double.POSITIVE_INFINITY : this.getRoomArea().getValue(SIUS.unit(4)) / (double)this.d_occupants.size();
            UnitDouble densityU = new UnitDouble(density, SIUS.unit(2));
            this.d_occDensity = mgr == null ? new OccArea(densityU) : mgr.get(densityU);
        }
        return this.d_occDensity;
    }

    public int getSpacing() {
        if (this.d_spacing == null) {
            this.d_spacing = 1;
        }
        return this.d_spacing;
    }
}

