/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import common.data.EscalatorPreference;
import common.data.SpeedInSmoke;
import inferno.sim.VehicleBody;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.AMerlinObj;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.NamedMerlinObj;
import merlin.data.ObjsFilter;
import merlin.data.egress.SimError;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.IAvatar;
import merlin.data.egress.agents.IProfileObj;
import merlin.data.egress.agents.IProfileProp;
import merlin.data.egress.agents.IProfilePropDist;
import merlin.data.egress.agents.ProfileProps;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.EgressStair;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.property.DisplayProps;
import merlin.data.property.Function1dProp;
import merlin.data.property.PropComparisons;
import merlin.data.property.PropertyDefs;
import merlin.data.stat.DisabledCurve;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.data.value.IFunction1d;
import merlin.data.value.PiecewiseFunction1d;
import merlin.gui.AvatarEditor;
import merlin.gui.MerlinValueFields;
import merlin.gui.ObjSources;
import merlin.gui.StrTagsEditor;
import merlin.gui.StrTagsField;
import merlin.gui.TagsEditor;
import merlin.gui.agents.AttractorsFilterEditorComponents;
import merlin.gui.agents.CompRestrictionsEditor;
import merlin.gui.agents.PersonalDistanceEditor;
import merlin.gui.agents.ProfileFunctionEditor;
import merlin.gui.agents.ShapeEditor;
import merlin.gui.agents.SpeedInSmokeEditor;
import merlin.gui.filter.ObjsFilterEditor;
import merlin.gui.filter.ObjsFilterEditorComponents;
import merlin.gui.guiUtil;
import merlin.gui.labels.DefaultLabelGenerator;
import merlin.gui.stat.VerboseCurveEditor;
import merlin.gui.stat.guiCurveUtil;
import merlin.gui.value.Function1dEditorFactory;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.unitsystem.SIUS;
import merlin.util.Dependencies;
import merlin.util.MerlinUtil;
import merlin.util.StringTagsUtil;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.gui.Comm;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.colorscheme.ColorValEditor;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.IPropComparisonEditorSupplier;
import thunderheadeng.gui.framework.property.PropertyDefsFramework;
import thunderheadeng.gui.framework.property.TeciDisplayProps;
import thunderheadeng.gui.stat.UrnValEditor;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.value.BooleanValEditor;
import thunderheadeng.gui.value.ConstValEditor;
import thunderheadeng.gui.value.DiscreteValEditor;
import thunderheadeng.gui.value.FixedValEditor;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.gui.value.MultiValEditor;
import thunderheadeng.gui.value.ObjComboBox;
import thunderheadeng.gui.value.PopupValEditor;
import thunderheadeng.gui.value.PropValueToValEditor;
import thunderheadeng.gui.value.UrnToBallEditor;
import thunderheadeng.gui.value.ValueFieldEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.LWPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Sets;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.InfiniteUrn;
import thunderheadeng.util.stat.UniformCurve;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;

public class OccProfile
extends AMerlinObj
implements Serializable,
IMerlinObj,
IDirectDependent<MerlinData>,
ICyclicSurrogate,
IProfileObj {
    static final long serialVersionUID = 1L;
    public static final PropertyDefs<IProfileObj> SHARED_PROFILE_PROPS = PropertyDefs.defsRoot(IProfileObj.class, new ProfileStorage());
    private static final PropertyDefsFramework.Attribute<IPropComparisonEditorSupplier<MerlinData, IProfileObj, ?>> OCC_COMP_ED_ATTR = new PropertyDefsFramework.Attribute<Object>("OccProfile.OCC_COMP_ED_ATTR", null, false);
    private static final IFunction1d SFPE_FUNDAMENTAL_CURVE = OccProfile.getSFPEFundamentalCurve(0.15);
    private static final Function<ICurve, String> CURVE_FORMATTER = c -> c.format(MerlinUtil.getDisplayUnitSupplier(new int[0]));
    private static final UnitDouble DEFAULT_COMFORT_DISTANCE = new UnitDouble(0.08, SI.METER);
    private static final int MAX_STRING_LENGTH = 30;
    public static final IFunction1d SFPE_STAIR_FUNCTION = PiecewiseFunction1d.newFunction(Unit.ONE, Unit.ONE, 0.0, 1.0, 0.5, 0.8785714285714287, 0.541, 0.8285714285714285, 0.638, 0.7714285714285716, 0.748, 0.7142857142857143, 1.8, 0.02428571428571429);
    public static final IFunction1d SFPE_RAMP_FUNCTION = PiecewiseFunction1d.newFunction(Unit.ONE, Unit.ONE, 0.0, 1.0, 1.0, 1.0);
    public static final DisplayProp<OccProfile> PROP_PROF_PARENT = ((TeciDisplayProps.Builder)((TeciDisplayProps.Builder)DisplayProps.build((Object)"PROP_PROF_PARENT", OccProfile.class, null, Intl.intl("Profile"), Intl.intl("The occupant's profile.")).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValue(prof -> MerlinUtil.getName(prof))).attrToProp();
    public static final ProfileProps.UnaryProp<String> PROP_NAME = (ProfileProps.UnaryProp)ProfileProps.buildUnaryProp(ProfileProps.Group.NONE, "OccProfile.NAME", String.class, "", Intl.intl("Name"), "").attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrFinish();
    public static final ProfileProps.UnaryProp<String> PROP_DESC = (ProfileProps.UnaryProp)((ProfileProps.UnaryPropBuilder)ProfileProps.buildUnaryProp(ProfileProps.Group.NONE, "OccProfile.DESC", String.class, "", Intl.intl("Description"), "").attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrFinish();
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_MAXVEL = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.CHARACTERISTICS, "OccProfile.MAXVEL", 160705858904975L, OccProfile.cc(1.19, SI.METER.divide(SI.SECOND)), Intl.intl("Speed"), "", true).attrValEditor((md, inline) -> new VerboseCurveEditor(5, inline, 15, UnitDoubleVR.above(0.0, SIUS.unit(5), true)))).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(5)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(5))).attrFinish();
    public static final ProfileProps.ProfileFunction1dProp PROP_FUNDAMENTAL = OccProfile.newFundamentalProp("OccProfile.FUNDAMENTAL", Intl.intl("Speed-Density Profile"), Intl.intl("Modifies an occupant's maximum speed as a function of local occupant density."), Intl.intl("Speed-Density Profile"), OccProfile.getSFPEFundamentalCurve(0.15), f -> f);
    public static final ProfileProps.ProfileFunction1dProp PROP_STAIR_SPEED_UP = OccProfile.newSlopeProp("OccProfile.SPEED_STAIR_UP", Intl.intl("Speed Fraction Up"), "<html>" + Intl.intl("Modifies an occupant's maximum speed up stairs as a function<br>of stair slope (tread rise/tread run)."), Intl.intl("Stair Speed Fraction Up"), SFPE_STAIR_FUNCTION);
    public static final ProfileProps.ProfileFunctionProp PROP_STAIR_FUNDAMENTAL_UP = OccProfile.newFundamentalProp("OccProfile.FUNDAMENTAL_STAIR_UP", Intl.intl("Speed-Density Up"), Intl.intl("The speed-density function to use when the occupant travels up stairs."), Intl.intl("Stair Speed-Density Up"), null, f -> f.toProfileFunctionProp());
    public static final ProfileProps.ProfileFunction1dProp PROP_STAIR_SPEED_DOWN = OccProfile.newSlopeProp("OccProfile.SPEED_STAIR_DOWN", Intl.intl("Speed Fraction Down"), "<html>" + Intl.intl("Modifies an occupant's maximum speed down stairs as a function<br>of stair slope (tread rise/tread run)."), Intl.intl("Stair Speed Fraction Down"), SFPE_STAIR_FUNCTION);
    public static final ProfileProps.ProfileFunctionProp PROP_STAIR_FUNDAMENTAL_DOWN = OccProfile.newFundamentalProp("OccProfile.FUNDAMENTAL_STAIR_DOWN", Intl.intl("Speed-Density Down"), Intl.intl("The speed-density function to use when the occupant travels down stairs."), Intl.intl("Stair Speed-Density Down"), null, f -> f.toProfileFunctionProp());
    public static final ProfileProps.ProfileFunction1dProp PROP_RAMP_SPEED_UP = OccProfile.newSlopeProp("OccProfile.SPEED_RAMP_UP", Intl.intl("Speed Fraction Up"), "<html>" + Intl.intl("Modifies an occupant's maximum speed up ramps as a function<br>of ramp slope."), Intl.intl("Ramp Speed Fraction Up"), SFPE_RAMP_FUNCTION);
    public static final ProfileProps.ProfileFunctionProp PROP_RAMP_FUNDAMENTAL_UP = OccProfile.newFundamentalProp("OccProfile.FUNDAMENTAL_RAMP_UP", Intl.intl("Speed-Density Up"), Intl.intl("The speed-density function to use when the occupant travels up ramps."), Intl.intl("Ramp Speed-Density Up"), null, f -> f.toProfileFunctionProp());
    public static final ProfileProps.ProfileFunction1dProp PROP_RAMP_SPEED_DOWN = OccProfile.newSlopeProp("OccProfile.SPEED_RAMP_DOWN", Intl.intl("Speed Fraction Down"), "<html>" + Intl.intl("Modifies an occupant's maximum speed down ramps as a function<br>of ramp slope."), Intl.intl("Ramp Speed Fraction Down"), SFPE_RAMP_FUNCTION);
    public static final ProfileProps.ProfileFunctionProp PROP_RAMP_FUNDAMENTAL_DOWN = OccProfile.newFundamentalProp("OccProfile.FUNDAMENTAL_RAMP_DOWN", Intl.intl("Speed-Density Down"), Intl.intl("The speed-density function to use when the occupant travels down ramps."), Intl.intl("Ramp Speed-Density Down"), null, f -> f.toProfileFunctionProp());
    public static final ProfileProps.UnaryProp<SpeedInSmokeConfig> PROP_SPEED_IN_SMOKE = (ProfileProps.UnaryProp)((ProfileProps.UnaryPropBuilder)((ProfileProps.UnaryPropBuilder)((ProfileProps.UnaryPropBuilder)ProfileProps.buildUnaryProp(ProfileProps.Group.ADVANCED, "speedInSmoke", SpeedInSmokeConfig.class, new SpeedInSmokeConfig(SpeedInSmoke.Data.DEFAULT), Intl.intl("Speed in Smoke"), Intl.intl("Controls the occupant's speed in smoke when using FDS integration.")).attrFormatValue(value -> value.format())).attrValEditor((md, inline) -> new SpeedInSmokeEditor(new Comm()))).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrFinish();
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_ACCEL_TIME = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.ADVANCED, "OccProfile.ACCEL_TIME", 3772195293760533400L, OccProfile.cc(1.1, SI.SECOND), Intl.intl("Acceleration Time"), Intl.intl("The amount of time for an occupant to accelerate from standing to moving at maximum velocity."), true, 1).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(1)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(1))).attrFinish();
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_DIAMETER = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.CHARACTERISTICS, "OccProfile.DIAMETER", 70367L, OccProfile.cc(0.4558, SI.METER), Intl.intl("Shoulder Width"), Intl.intl("The occupant diameter used when performing collisions with other occupants."), true, -1).attrMarkGeometric()).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(0)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(0))).attrFinish();
    public static final ProfileProps.UnaryProp<UnitDouble> PROP_GEOM_DIAMETER = (ProfileProps.UnaryProp)((ProfileProps.UnaryPropBuilder)((ProfileProps.UnaryPropBuilder)ProfileProps.buildUnaryProp(ProfileProps.Group.CHARACTERISTICS, "OccProfile.GEOM_DIAMETER", UnitDouble.class, null, Intl.intl("Geometry Shoulder Width"), Intl.intl("The minimum diameter to which an occupant can reduce its body to move past narrow geometry.")).attrMarkGeometric()).attrFormatValue(v -> v == null ? "" : guiUtil.format(v, 6))).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().unitdouble(6)).attrFinish();
    public static final ProfileProps.UnaryProp<Double> PROP_MIN_SQUEEZE_FACTOR_CONST = (ProfileProps.UnaryProp)ProfileProps.buildUnaryProp(ProfileProps.Group.CHARACTERISTICS, "OccProfile.MIN_SQUEEZE_FACTOR_CONST", Double.class, 0.7, Intl.intl("Reduction Factor"), Intl.intl("The fraction by which an occupant can reduce their radius to move past others.")).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().dbl()).attrFinish();
    public static final ProfileProps.UnaryProp<Point3f> PROP_COLOR = (ProfileProps.UnaryProp)((ProfileProps.UnaryPropBuilder)((ProfileProps.UnaryPropBuilder)ProfileProps.buildUnaryProp(ProfileProps.Group.APPEARANCE, "OccProfile.COLOR", Point3f.class, new Point3f(0.4f, 0.4f, 1.0f), Intl.intl("Color"), Intl.intl("The color of the occupant.")).attrValEditor((md, inline) -> ColorValEditor.t3f(Point3f.class))).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsMutable(SHARED_PROFILE_PROPS).attrCloneAndRestoreValue((obj, c) -> (Point3f)c.clone()).attrFinish();
    public static final ProfileProps.DistProp<IAvatar, IUrn<IAvatar>> PROP_OCCMODEL = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)OccProfile.newUrnProp(ProfileProps.Group.APPEARANCE, "OccProfile.OCCMODEL", 59846346733L, IAvatar.class, new Urn<IAvatar>(OccProfile.getDefaultAvatars()), Intl.intl("3D Model"), Intl.intl("The 3D model used to represent the occupant in Results.")).attrFormatValue(OccProfile::formatAvatars)).attrValEditor((md, inline) -> new PropValueToValEditor<IUrn<IAvatar>>(OccProfile.urnType(IAvatar.class), new AvatarEditor(3, ResourceAvatar.Type.OCCUPANT)))).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().convert(avatarUrn -> avatarUrn.getUnique(theUtil.makeGeneric(LinkedHashSet.class)), PropComparisons.factory().multiObj(OccProfile.getAvatarSrc()))).attrCustom(OccProfile.occCompEd(PropComparisons.factory().singleObj(OccProfile.getAvatarSrc(), md -> new ObjComboBox((Mediator)md, OccProfile.getAvatarSrc().get(md), null), PropComparisons.factory().getMultiChooser(OccProfile.getAvatarSrc()), null))).attrFinish();
    public static final ProfileProps.DistProp<Integer, IUrn<Integer>> PROP_PRIORITY_LEVEL = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)OccProfile.newUrnProp(ProfileProps.Group.CHARACTERISTICS, "OccProfile.PRIORITY_LEVEL", 691837209914168L, Integer.class, new Urn<Integer>(0), Intl.intl("Priority Level"), Intl.intl("The priority of the occupant.  Higher values indicate higher priority.")).attrFormatValue(OccProfile.urnFormatter(i -> Integer.toString(i)))).attrValEditor((md, inline) -> new UrnToBallEditor<Integer>(new ValueFieldEditor<Integer>(Integer.class, MerlinValueFields.intFld(IntVR.above(0, true)))))).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().convert(prio -> (Integer)UrnUtil.getDominant(prio), PropComparisons.factory().integer())).attrCustom(OccProfile.occCompEd(PropComparisons.factory().integer())).attrFinish();
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_PERSIST_TIME = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.ADVANCED, "OccProfile.PERSIST_TIME", 4501553410181778L, OccProfile.cc(1.0, SI.SECOND), Intl.intl("Persist Time"), Intl.intl("Amount of time an occupant keeps elevated priority to resolve conflicts when no progress is being made."), true, 1).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(1)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(1))).attrFinish();
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_COLLISION_RESPONSE_TIME = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.ADVANCED, "OccProfile.COLLISION_RESPONSE_TIME", 2872109906997839L, OccProfile.cc(1.5, SI.SECOND), Intl.intl("Collision Response Time"), Intl.intl("Time used by an occupant to determine the critical stopping distance to avoid hitting other occupants."), true, 1).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(1)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(1))).attrFinish();
    public static final ProfileProps.DistProp<Spacing, Spacing> PROP_SPACING = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)ProfileProps.buildDistProp(ProfileProps.Group.ADVANCED, "OccProfile.PROP_SPACING", 685236812626031156L, Spacing.class, Spacing.class, new Spacing(SpacingType.COMFORT_DIST, new ConstantCurve(DEFAULT_COMFORT_DISTANCE)), Intl.intl("Personal Distance"), Intl.intl("Controls the spacing of occupants when queueing or traveling with restricted speed.")).attrValEditor((md, inline) -> new PersonalDistanceEditor(new Comm()))).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrValFromSample(s -> s)).attrSampleVal(prop -> (prof, val, profSeed, orientSeed) -> val.getValue(prof, prop.seed, profSeed))).attrFormatValueWithToString()).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrFinish();
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_SOCIAL_DIST = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.ADVANCED, "OccProfile.PROP_SOCIAL_DIST", 756474136765175587L, new ConstantCurve(new UnitDouble(0.0, SI.METER)), Intl.intl("Social Distance"), Intl.intl("The preferred distance to other occupants outside the occupant's movement group\nand whom are accepted by <b>Social Distance Occupants</b>."), true).attrValEditor((md, inline) -> new VerboseCurveEditor(0, inline, 15))).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(0)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(0))).attrFinish();
    public static final ProfileProps.UnaryProp<ObjsFilter<Tag>> PROP_SOCIAL_DIST_FILTER = ((ProfileProps.UnaryPropBuilder)((ProfileProps.UnaryPropBuilder)((ProfileProps.UnaryPropBuilder)ProfileProps.buildUnaryProp(ProfileProps.Group.ADVANCED, "OccProfile.PROP_SOCIAL_DIST_FILTER", OccProfile.filterType(Tag.class), ObjsFilter.rejectAll(Tag.class), Intl.intl("Social Distance Occupants"), Intl.intl("Defines which occupants are considered for social distancing. Social distance will only be kept\nfrom occupants with the specified tags.")).attrValEditor((md, inline) -> {
        Supplier<IValEditor> getEditor = () -> new ObjsFilterEditor<Tag>(new ObjsFilterEditorComponents<Tag>(null, Tag.class, new TagsEditor(true)));
        if (!inline) {
            return new PopupValEditor<ObjsFilter>(PopupValEditor.Mode.HTML, ObjsFilter.class, Intl.intl("Distance from Occupants with Tags"), getEditor, v -> v.format(30));
        }
        return getEditor.get();
    })).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValueWithToString()).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrDependency(prop -> ObjsFilter.newDepCallback(prop, Tag.class)).attrComparisonEditor(PropComparisons.factory().objsFilter(md -> ObjSources.getTags(md, null))).attrFinish();
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_SLOW_FACTOR = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.ADVANCED, "OccProfile.SLOW_FACTOR", 41361678648555699L, OccProfile.cc(0.1), Intl.intl("Slow Factor"), Intl.intl("The fraction of an occupant's maximum speed that determines if the occupant is slow,\nallowing the occupant to consider more travel directions."), true, 11).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(11)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(11))).attrFinish();
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_HEIGHT = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.CHARACTERISTICS, "OccProfile.HEIGHT", 4823856332702527L, OccProfile.cc(1.8288, SI.METER), Intl.intl("Height"), Intl.intl("The height used when performing collisions with other occupants."), true, -1).attrMarkGeometric()).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(0)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(0))).attrFinish();
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_BOUNDARY_LAYER = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.ADVANCED, "OccProfile.BOUNDARY_LAYER", 265469670362069667L, OccProfile.cc(15.0, SI.CENTI(SI.METER)), Intl.intl("Wall Boundary Layer"), Intl.intl("The distance the occupant tries to maintain with walls."), true, 0).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(0)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(0))).attrFinish();
    public static final ProfileProps.DistProp<Boolean, IUrn<Boolean>> PROP_ASSIST = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)OccProfile.newUrnProp(MerlinApp.isFP() ? ProfileProps.Group.MOVEMENT : ProfileProps.Group.NONE, "OccProfile.ASSIST", 9435912272635L, Boolean.class, new Urn<Boolean>(false), Intl.intl("Requires Assistance to Move"), Intl.intl("Controls whether the occupants require assistance from others to reach their desired exits.")).attrFormatValue(DisplayProps.formatUrnYesNo())).attrValEditor((md, inline) -> new UrnToBallEditor<Boolean>(new BooleanValEditor()))).attrAddMarkersIf(MerlinApp.isFP(), MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrFinish();
    public static final ProfileProps.DistProp<Boolean, IUrn<Boolean>> PROP_OBEY_ONEWAY_DOORS = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)OccProfile.newUrnProp(ProfileProps.Group.MOVEMENT, "OccProfile.OBEY_ONEWAY_DOORS", 1527562427425878947L, Boolean.class, new Urn<Boolean>(true), Intl.intl("Ignore One-way Door Restrictions"), Intl.intl("Controls whether occupants observe directionality of one-way doors,\nstairs, and ramps. If they ignore it, they will go through in either \ndirection; if not, they will go only in the required direction.")).attrFormatValue(OccProfile.urnFormatter(v -> v != false ? Intl.intl("No") : Intl.intl("Yes")))).attrValEditor((md, inline) -> new UrnToBallEditor<Boolean>(new BooleanValEditor(true)))).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().convert(ignore -> (Boolean)UrnUtil.getDominant(ignore), PropComparisons.factory().booleanTrueFalse(true))).attrCustom(OccProfile.occCompEd(PropComparisons.factory().booleanTrueFalse(true))).attrFinish();
    public static final ProfileProps.DistProp<EscalatorPreference, IUrn<EscalatorPreference>> PROP_ESCALATOR_PREF = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)OccProfile.newUrnProp(ProfileProps.Group.MOVEMENT, "OccProfile.ESCALATOR_PREF", -6968375068520378298L, EscalatorPreference.class, new Urn<EscalatorPreference>(EscalatorPreference.STAND_ANYWHERE), Intl.intl("Escalator Preference"), Intl.intl("Controls how occupants use escalators and moving walkways.")).attrFormatValue(OccProfile.urnFormatter(e -> e.name))).attrValEditor((md, inline) -> new UrnToBallEditor<EscalatorPreference>(new DiscreteValEditor<EscalatorPreference>(EscalatorPreference.class, val -> new Pair<String, String>(val.name, val.desc), EscalatorPreference.values())))).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().convert(prefs -> (EscalatorPreference)UrnUtil.getDominant(prefs), PropComparisons.factory().options(EscalatorPreference.values()))).attrCustom(OccProfile.occCompEd(PropComparisons.factory().options(EscalatorPreference.values()))).attrFinish();
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_LOCAL_QUEUE_TIME_FACTOR = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.DOOR_CHOICE, "OccProfile.LOCAL_QUEUE_TIME_FACTOR", 725907575970042L, OccProfile.cc(1.0), Intl.intl("Current Room Queue Time"), Intl.intl("This value affects the cost of waiting in a queue at a door in the\noccupant's current room.  Higher values increase a door's cost in\nthis category."), true, 11).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(11)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(11))).attrFinish();
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_LOCAL_TRAVEL_TIME_FACTOR = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.DOOR_CHOICE, "OccProfile.LOCAL_TRAVEL_TIME_FACTOR", 625208248450526L, OccProfile.cc(1.0), Intl.intl("Current Room Travel Time"), Intl.intl("This value affects the cost of traveling to a door in the occupant's\ncurrent room.  Higher values increase a door's cost in this category."), true, 11).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(11)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(11))).attrFinish();
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_TAIL_TIME_FACTOR = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.DOOR_CHOICE, "OccProfile.TAIL_TIME_FACTOR", 686610875145200458L, OccProfile.cc(1.0), Intl.intl("Global Travel Time"), Intl.intl("This value affects the cost of traveling from a door in the occupant's\ncurrent room to an exit or the occupant's next goal. Higher values increase\na door's cost in this category."), true, 11).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(11)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(11))).attrFinish();
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_CURR_DOOR_PREF = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.DOOR_CHOICE, "OccProfile.CURR_DOOR_PREF", 9478288431L, OccProfile.cc(35.0, NonSI.PERCENT), Intl.intl("Current Door Preference"), Intl.intl("This value is used to help occupants stick to their currently chosen\ndoors, preventing excessive switching.  A value of 100 % will cause\noccupants to never switch doors, and a value of 0 % will allow occupants\nto freely change their selected doors."), true, 10).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(10)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(10))).attrFinish();
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_CURRENT_ROOM_DIST_PENALTY = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.DOOR_CHOICE, "OccProfile.DIST_TRAVELLED_DOUBLE_DIST", 18843351117539L, OccProfile.cc(35.0, SI.METER), Intl.intl("Current Room Distance Penalty"), Intl.intl("<b>NOTE: Enter <i>0</i> to turn off.</b>\nThis value is used as a simple way to model fatigue.  The further an occupant\ntravels in a room, the more the occupant prefers shorter distances over shorter\ntimes.<br>More precisely, every time the occupant travels this distance in the current\nroom, the overall travel time cost will have doubled."), true, 0).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(0)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(0))).attrFinish();
    public static final ProfileProps.DistProp<Boolean, IUrn<Boolean>> PROP_PRINT_EXTRA_OUTPUT = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)OccProfile.newUrnProp(ProfileProps.Group.OUTPUT, "OccProfile.PRINT_EXTRA_OUTPUT", 14614216L, Boolean.class, new Urn<Boolean>(false), Intl.intl("Output Detailed Data"), Intl.intl("Whether to enabled printing to a detailed occupant CSV file.\nWARNING: Enabling CSV output for many occupants may use significant computing\nresources and/or disk space during simulation.")).attrFormatValue(DisplayProps.formatUrnYesNo())).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().convert(output -> (Boolean)UrnUtil.getDominant(output), PropComparisons.factory().booleanTrueFalse())).attrCustom(OccProfile.occCompEd(PropComparisons.factory().booleanTrueFalse())).attrFinish();
    public static final ProfileProps.UnaryProp<VehicleShape> PROP_VEHICLE_SHAPE = ((ProfileProps.UnaryPropBuilder)ProfileProps.buildUnaryProp(ProfileProps.Group.CHARACTERISTICS, "OccProfile.VEHICLE_SHAPE", VehicleShape.class, VehicleShape.NONE, Intl.intl("Vehicle Shape"), Intl.intl("Shape of the vehicle occupant.")).attrMarkGeometric()).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrDependency(thisProp -> Dependencies.newDependencyAsValue(thisProp, DLink.WEAK, VehicleShape.class, Predicates.alwaysTrue())).attrComparisonEditor(PropComparisons.factory().singleObj(md -> ObjSources.getVehicleShapes(md, null))).attrFinish();
    public static final ProfileProps.DistProp<OccShape, OccShape> PROP_SHAPE = ((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)ProfileProps.buildDistProp(ProfileProps.Group.CHARACTERISTICS, "OccProfile.SHAPE", 0L, OccShape.class, OccShape.class, new OccShape(VehicleShape.NONE, OccProfile.cc(0.4558, SI.METER), null, OccProfile.cc(1.8288, SI.METER), 0.7), Intl.intl("Shape"), Intl.intl("Specifies the shape and size of the occupant.")).attrMarkGeometric()).attrValEditor((md, inline) -> new ShapeEditor((MerlinData)md, 15, new DefaultLabelGenerator()))).attrGetErrors((md, owner, shape, errors) -> shape.getErrors(md, owner, errors))).attrValFromSample(s -> s)).attrSampleVal(prop -> (prof, val, profSeed, orientSeed) -> val.toOccValue(prof, profSeed, orientSeed))).attrFormatValueWithToString()).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsWrapper(SHARED_PROFILE_PROPS).attrDependency(prop -> OccShape.newVehicleDepCallback(prop)).attrGetter(obj -> new OccShape(obj.get(PROP_VEHICLE_SHAPE), (ICurve)obj.get(PROP_DIAMETER), obj.get(PROP_GEOM_DIAMETER), (ICurve)obj.get(PROP_HEIGHT), obj.get(PROP_MIN_SQUEEZE_FACTOR_CONST)), Stream.of(PROP_VEHICLE_SHAPE, PROP_DIAMETER, PROP_GEOM_DIAMETER, PROP_HEIGHT, PROP_MIN_SQUEEZE_FACTOR_CONST)).attrSetter((obj, shape) -> {
        try (IDomainObject.EventPause paused = obj.openPause();){
            if (shape.type.equals(VehicleShape.ShapeType.CYLINDER)) {
                obj.set(PROP_DIAMETER, shape.shoulderWidth);
                obj.set(PROP_GEOM_DIAMETER, shape.geomShoulderWidth);
                obj.set(PROP_HEIGHT, shape.height);
                obj.set(PROP_VEHICLE_SHAPE, null);
            } else {
                obj.set(PROP_VEHICLE_SHAPE, shape.vehicleShape);
                obj.set(PROP_DIAMETER, (ICurve)OccProfile.PROP_DIAMETER.defVal);
                obj.set(PROP_GEOM_DIAMETER, (UnitDouble)OccProfile.PROP_GEOM_DIAMETER.defVal);
                obj.set(PROP_HEIGHT, (ICurve)OccProfile.PROP_HEIGHT.defVal);
            }
            obj.set(PROP_MIN_SQUEEZE_FACTOR_CONST, shape.minSqueezeFactor);
        }
    }, null).attrUndoPropRestore(false, PROP_VEHICLE_SHAPE, PROP_DIAMETER, PROP_GEOM_DIAMETER, PROP_HEIGHT, PROP_MIN_SQUEEZE_FACTOR_CONST).attrComparisonEditor(PropComparisons.factory().convert(p -> p.type, PropComparisons.factory().options(VehicleShape.ShapeType.values()))).attrCustom(OccProfile.occCompEd(PropComparisons.factory().convert(p -> p.type, PropComparisons.factory().options(VehicleShape.ShapeType.values())))).attrFinish();
    public static final ProfileProps.DistProp<Boolean, IUrn<Boolean>> PROP_REQUIRES_ASSISTANCE = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)OccProfile.newUrnProp(ProfileProps.Group.MOVEMENT, "OccProfile.REQUIRES_ASSISTANCE", 281103528794162L, Boolean.class, new Urn<Boolean>(false), Intl.intl("Requires Assistance to Move"), Intl.intl("Recommended for occupants that are unable to move under their own power (e.g. in a bed or other carrying device).")).attrMarkGeometric()).attrFormatValue(DisplayProps.formatUrnYesNo())).attrValEditor((md, inline) -> new UrnToBallEditor<Boolean>(new BooleanValEditor()))).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().convert(requires -> (Boolean)UrnUtil.getDominant(requires), PropComparisons.factory().booleanTrueFalse())).attrCustom(OccProfile.occCompEd(PropComparisons.factory().booleanTrueFalse())).attrFinish();
    public static final Vector3d INIT_ORIENT_REF = GeomConstants.VEC3D_XPOS;
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_INIT_ORIENT = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.NONE, "OccProfile.INIT_ORIENT", 0L, new UniformCurve(new UnitDouble(0.0, SI.RADIAN), new UnitDouble(Math.PI * 2, SI.RADIAN)), Intl.intl("Initial Orientation"), Intl.intl("Set the initial orientation in degrees from positive x axis counter-clockwise"), false).attrValEditor((md, inline) -> new VerboseCurveEditor(7, inline, UnitDoubleVR.unbounded()))).attrMarkGeometric()).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(7)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(7))).attrFinish();
    public static final ProfileProps.UnaryProp<CompRestrictions> PROP_RESTRICTED_COMPONENTS = SHARED_PROFILE_PROPS.storeAsPlainOldData(new CompRestrictionsProp()).attrDependencyStream(prop -> {
        EnumMap d_depCallbacks = new EnumMap(CompRestrictions.Type.class);
        for (CompRestrictions.Type type : CompRestrictions.Type.values()) {
            d_depCallbacks.put(type, CompRestrictions.newCallback(prop, type));
        }
        return obj -> d_depCallbacks.values().stream();
    }).attrFinish();
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_ELEVATOR_WAIT_TIME = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.DOOR_CHOICE, "OccProfile.ELEVATOR_WAIT_TIME", 0L, OccProfile.cc(0.0, SI.SECOND), Intl.intl("Elevator Wait Time"), Intl.intl("This value determines for how long occupants wait for an elevator even if there\nis a faster alternative."), true, 1).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(1)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(1))).attrFinish();
    public static final ProfileProps.UnaryProp<Boolean> PROP_NO_CHANGE = (ProfileProps.UnaryProp)ProfileProps.buildUnaryProp(ProfileProps.Group.NONE, "OccProfile.NO_CHANGE", Boolean.class, false, Intl.intl("No Change"), "").attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrFinish();
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.MOVEMENT, "OccProfile.ATTRACTOR_SUSCEPTIBILITY", 574529506091934536L, OccProfile.cc(1.0, NonSI.PERCENT), Intl.intl("Trigger Susceptibility (Seeking)"), Intl.intl("Defines how susceptible an occupant is to trigger objects when seeking. This\nvalue is multiplied by a trigger's influence to determine the probability\nthat an occupant will be influenced by a trigger."), true).attrValEditor((md, inline) -> new VerboseCurveEditor(10, inline, UnitDoubleVR.between(0.0, 100.0, NonSI.PERCENT, true, true)))).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(10)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(10))).attrFinish();
    public static final ProfileProps.DistProp<UnitDouble, ICurve> PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE = (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.MOVEMENT, "OccProfile.ATTRACTOR_SUSCEPTIBILITY_IDLE", 574529506091934536L, OccProfile.cc(5.0, NonSI.PERCENT), Intl.intl("Trigger Susceptibility (Waiting)"), Intl.intl("Defines how susceptible an occupant is to trigger objects when waiting. This\nvalue is multiplied by a trigger's influence to determine the probability\nthat an occupant will be influenced by a trigger."), true).attrValEditor((md, inline) -> new VerboseCurveEditor(10, inline, UnitDoubleVR.between(0.0, 100.0, NonSI.PERCENT, true, true)))).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrComparisonEditor(PropComparisons.factory().curve(10)).attrCustom(OccProfile.occCompEd(PropComparisons.factory().unitdouble(10))).attrFinish();
    public static final ProfileProps.UnaryProp<ObjsFilter<Attractor>> PROP_ATTRACTOR_RESTRICTIONS = ((ProfileProps.UnaryPropBuilder)((ProfileProps.UnaryPropBuilder)((ProfileProps.UnaryPropBuilder)ProfileProps.buildUnaryProp(ProfileProps.Group.MOVEMENT, "OccProfile.ATTRACTOR_RESTRICTIONS", OccProfile.filterType(Attractor.class), ObjsFilter.acceptAll(Attractor.class), Intl.intl("Trigger Restrictions"), Intl.intl("Defines which triggers can influence the occupant.")).attrValEditor((md, inline) -> new ObjsFilterEditor<Attractor>(new AttractorsFilterEditorComponents((MerlinData)md, false)))).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrFormatValueWithToString()).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrDependency(prop -> ObjsFilter.newDepCallback(prop, Attractor.class)).attrComparisonEditor(PropComparisons.factory().objsFilter(md -> ObjSources.getAttractors(md, null))).attrFinish();
    public static final ProfileProps.UnaryProp<Set<Tag>> PROP_TAGS = TagsUtil.newTagsProp(SHARED_PROFILE_PROPS);
    public static final ProfileProps.DistProp<Set<String>, IUrn<Set<String>>> PROP_ANIMS_MOVING = OccProfile.newAnimTagsProp("OccProfile.MOVE_ANIMS", 1252506382136L, false, Intl.intl("Move Animations"), Intl.intl("Defines which animations to use when the occupants are moving."));
    public static final ProfileProps.DistProp<Set<String>, IUrn<Set<String>>> PROP_ANIMS_IDLE = OccProfile.newAnimTagsProp("OccProfile.IDLE_ANIMS", 113466752117554L, true, Intl.intl("Idle Animations"), Intl.intl("Defines which animations to use when the occupants are idle."));
    public static final PropertyDefs<OccProfile> ALL_PROPS = PropertyDefs.defsInheritStorageAndProps(OccProfile.class, null, SHARED_PROFILE_PROPS);
    public static final DisplayProp<String> SEARCH_NAME = ALL_PROPS.storeDirectWrapper(NamedMerlinObj.NAME, PROP_NAME).attrFinish();
    public static final DisplayProp<String> SEARCH_DESC = ALL_PROPS.storeDirectWrapper(MerlinData.DESCRIPTION, PROP_DESC).attrFinish();
    public static final DisplayProp<Color> SEARCH_COLOR = ALL_PROPS.storeAsReadOnly(MerlinData.SEARCH_COLOR).attrGetter(profile -> {
        Point3f cf = profile.get(PROP_COLOR);
        return new Color(cf.x, cf.y, cf.z);
    }, PROP_COLOR).attrFinish();
    private OccProfile d_parent;
    @Deprecated
    private Map<Object, Object> d_data;
    private LWPropertySet d_values;

    public static <OccT> PropertyDefsFramework.Attribute<IPropComparisonEditorSupplier<MerlinData, ? super IProfileObj, OccT>> occCompEdAttr() {
        return OCC_COMP_ED_ATTR;
    }

    public static <PropT extends TypedProp<ProfT>, ProfT, OccT> Function<PropT, PropertyDefsFramework.CustomAttr<IPropComparisonEditorSupplier<MerlinData, ? super IProfileObj, OccT>>> occCompEd(IPropComparisonEditorSupplier<MerlinData, ? super IProfileObj, OccT> supplier) {
        return prop -> new PropertyDefsFramework.CustomAttr<IPropComparisonEditorSupplier>(OccProfile.occCompEdAttr(), supplier);
    }

    private static <FinalValT, FinalPropT extends TypedProp<FinalValT>> FinalPropT newFundamentalProp(String name, String desc, String longDesc, String displayName, IFunction1d defVal, Function<ProfileProps.ProfileFunction1dProp, FinalPropT> finalizeProp) {
        Function1dProp.PredefFunction[] predef = new Function1dProp.PredefFunction[]{new Function1dProp.PredefFunction(Intl.intl("SFPE"), Intl.intl("Load SFPE profile..."), SFPE_FUNDAMENTAL_CURVE)};
        ProfileProps.Group group = ProfileProps.Group.ADVANCED_SPEED;
        ProfileProps.ProfileFunction1dProp prop = new ProfileProps.ProfileFunction1dProp(group, new Function1dProp((Object)name, group.displayStr, defVal, desc, longDesc, displayName, null, new Function1dProp.Var(Intl.intl("Density"), 3, UnitDoubleVR.above(SIUS.newud(0.0, 3), true)), new Function1dProp.Var(Intl.intl("Fraction of Max. Speed"), 11, UnitDoubleVR.between(0.0, 1.0, Unit.ONE, true, true)), new UnitDouble[]{SIUS.newud(0.0, 3), new UnitDouble(0.0, Unit.ONE), null, null}, Function1dEditorFactory.GENERAL_TYPES, Set.of(MerlinData.SCENARIO_MARKER), predef));
        TypedProp fprop = (TypedProp)finalizeProp.apply(prop);
        return (FinalPropT)SHARED_PROFILE_PROPS.storeAsPlainOldData(fprop).attrFinish();
    }

    private static ProfileProps.ProfileFunction1dProp newSlopeProp(String name, String desc, String longDesc, String displayName, IFunction1d defFunction) {
        Function1dProp.PredefFunction[] predef = new Function1dProp.PredefFunction[]{new Function1dProp.PredefFunction(Intl.intl("SFPE"), Intl.intl("Load SFPE profile..."), defFunction)};
        ProfileProps.Group group = ProfileProps.Group.ADVANCED_SPEED;
        ProfileProps.ProfileFunction1dProp prop = new ProfileProps.ProfileFunction1dProp(group, new Function1dProp((Object)name, group.displayStr, defFunction, desc, longDesc, displayName, null, new Function1dProp.Var(Intl.intl("Slope"), 11, UnitDoubleVR.above(0.0, Unit.ONE, true)), new Function1dProp.Var(Intl.intl("Fraction of Max. Speed"), 11, UnitDoubleVR.above(0.0, Unit.ONE, true)), new UnitDouble[]{new UnitDouble(0.0, Unit.ONE), null, new UnitDouble(0.0, Unit.ONE), null}, Function1dEditorFactory.GENERAL_TYPES, Set.of(MerlinData.SCENARIO_MARKER), predef));
        return SHARED_PROFILE_PROPS.storeAsPlainOldData(prop).attrFinish();
    }

    public static ProfileProps.DistPropBuilder<UnitDouble, ICurve> newCurveProp(ProfileProps.Group group, String key, long seed, ICurve defVal, String name, String desc, boolean useProfileSeed) {
        return (ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)ProfileProps.buildDistProp(group, key, seed, ICurve.class, UnitDouble.class, defVal, name, desc).attrFormatValue(CURVE_FORMATTER)).attrValFromSample(ConstantCurve::new)).attrSampleVal(prop -> (prof, val, profSeed, orientSeed) -> (UnitDouble)OccProfile.sampleDistVal(prop, val, useProfileSeed ? profSeed : orientSeed));
    }

    public static ProfileProps.DistPropBuilder<UnitDouble, ICurve> newCurveProp(ProfileProps.Group group, String key, long seed, ICurve defVal, String name, String desc, boolean useProfileSeed, int editorUnit) {
        return (ProfileProps.DistPropBuilder)OccProfile.newCurveProp(group, key, seed, defVal, name, desc, useProfileSeed).attrValEditor(editorUnit != -1 ? (md, inline) -> new VerboseCurveEditor(editorUnit, inline) : null);
    }

    public static <SampleT> ProfileProps.DistPropBuilder<SampleT, IUrn<SampleT>> newUrnProp(ProfileProps.Group group, String key, long seed, Class<SampleT> sampleType, IUrn<SampleT> defVal, String name, String desc) {
        return (ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)ProfileProps.buildDistProp(group, key, seed, OccProfile.urnType(sampleType), sampleType, defVal, name, desc).attrSampleVal(prop -> (prof, val, profSeed, orientSeed) -> OccProfile.sampleDistVal(prop, val, profSeed))).attrValFromSample(xva$0 -> new Urn<Object>(xva$0));
    }

    private static PropComparisons.ObjSrcSupplier<IAvatar> getAvatarSrc() {
        return PropComparisons.getAvatarSrc(ResourceAvatar.Type.OCCUPANT, IAvatar.HIDDEN_NAME);
    }

    private static String formatAvatars(IUrn<IAvatar> avatars) {
        Iterator it = avatars.stream().iterator();
        if (!it.hasNext()) {
            return Intl.intl("<none>");
        }
        IAvatar first = (IAvatar)it.next();
        if (it.hasNext()) {
            return Intl.intl("<multiple>");
        }
        return first == null ? IAvatar.HIDDEN_NAME : first.getName();
    }

    public static <T> Class<ObjsFilter<T>> filterType(Class<T> innerType) {
        return theUtil.makeGeneric(ObjsFilter.class);
    }

    public static <T> Class<IUrn<T>> urnType(Class<T> innerType) {
        return theUtil.makeGeneric(IUrn.class);
    }

    private static <SampleT, DistT extends IDistributedVal<SampleT>> SampleT sampleDistVal(IProfilePropDist<SampleT, DistT> prop, DistT distVal, long baseSeed) {
        long newSeed = baseSeed ^ prop.getSeed();
        Random rand = new Random(newSeed);
        return distVal.getValue(rand);
    }

    private static final ProfileProps.DistProp<Set<String>, IUrn<Set<String>>> newAnimTagsProp(String key, long seed, boolean idle, String name, String desc) {
        Function<IUrn, String> format = t -> OccProfile.formatAnimTags(t, 30);
        return (ProfileProps.DistProp)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)OccProfile.newUrnProp(ProfileProps.Group.ANIMATION, key, seed, theUtil.makeGeneric(Set.class, null), PredefAnimTags.DEFAULT_UPRIGHT.dist, name, desc).attrFormatValue(format)).attrAddMarkers(MerlinData.SCENARIO_MARKER)).attrValEditor((md, inline) -> OccProfile.getAnimEditor(IUrn.class, inline, idle, predef -> new ConstValEditor<IUrn<Set<String>>>(IUrn.class, predef.dist), predef -> predef.dist, () -> new UrnValEditor<Set>(Set.class, Intl.intl("Animation Tags"), Intl.intl("NOTE: Each cell in the Animation Tags column specifies a list of tags used to find corresponding animations. An animation must contain all the tags in that cell in order for a match to be made."), 100, new TagsTableCellEditor(), new guiTable.FormattedRenderer<Set>(tags -> StringTagsUtil.format(tags))), format))).attrSampledValEditor((md, inline) -> OccProfile.getAnimEditor(Set.class, inline, idle, predef -> new ConstValEditor<Set<String>>(Set.class, predef.tags), predef -> predef.tags, () -> {
            StrTagsField fld = new StrTagsField(true, Collections.emptySet());
            fld.setEmptyAllowed(false);
            return new StrTagsEditor(fld);
        }, OccProfile::formatAnimTags)).attrStoreAsPlainOldData(SHARED_PROFILE_PROPS).attrFinish();
    }

    private static <T> IValEditor<T> getAnimEditor(Class<T> type, boolean inline, boolean idle, Function<PredefAnimTags, IValEditor<T>> getPredefEditor, Function<PredefAnimTags, T> getDefaultVal, Supplier<IValEditor<T>> customEditor, Function<T, String> format) {
        Function<Boolean, IValEditor> getEditor = popupInline -> {
            ArrayList entries = new ArrayList();
            Predicate<Object> predefFilter = idle ? Filters.acceptAll() : pre -> !pre.idleOnly;
            entries.add(new MultiValEditor.Entry<Object, Object>(Intl.intl("<custom>"), Intl.intl("Uses custom animations."), (IValEditor)customEditor.get(), v -> Stream.of(PredefAnimTags.values()).filter(predefFilter).noneMatch(pre -> Objects.equals(v, getDefaultVal.apply((PredefAnimTags)((Object)pre)))), () -> true, v -> v));
            Stream.of(PredefAnimTags.values()).filter(predefFilter).forEach(predef -> {
                Object defVal = getDefaultVal.apply((PredefAnimTags)((Object)predef));
                entries.add(new MultiValEditor.Entry<Object, Object>(predef.name, idle ? predef.idleDescription : predef.moveDescription, (IValEditor)getPredefEditor.apply((PredefAnimTags)((Object)predef)), v -> Objects.equals(v, defVal), () -> true, v -> defVal));
            });
            return new MultiValEditor(IDistributedVal.class, entries, (boolean)popupInline);
        };
        if (inline) {
            return getEditor.apply(false);
        }
        return new PopupValEditor<T>(PopupValEditor.Mode.HTML, type, Intl.intl("Animation Tags"), () -> (IValEditor)getEditor.apply(true), format);
    }

    private static String formatAnimTags(IUrn<Set<String>> tags, int maxLen) {
        for (PredefAnimTags predef : PredefAnimTags.values()) {
            if (!tags.equals(predef.dist)) continue;
            return predef.getNameLabel();
        }
        return theUtil.truncate(tags.toString(), maxLen);
    }

    private static String formatAnimTags(Set<String> tags) {
        for (PredefAnimTags predef : PredefAnimTags.values()) {
            if (!tags.equals(predef.tags)) continue;
            return predef.getNameLabel();
        }
        return tags.toString();
    }

    private static final ConstantCurve cc(double val) {
        return OccProfile.cc(val, Unit.ONE);
    }

    private static final ConstantCurve cc(double val, Unit unit) {
        return new ConstantCurve(new UnitDouble(val, unit));
    }

    private static boolean validateProps() {
        Optional<TypedProp> firstInvalid = SHARED_PROFILE_PROPS.props().stream().filter(prop -> prop instanceof IProfilePropDist).filter(prop -> SHARED_PROFILE_PROPS.getAttrComparisonEditor(prop) != null).filter(prop -> SHARED_PROFILE_PROPS.getAttrCustom(prop, OccProfile.occCompEdAttr()).isEmptyOrNull()).findFirst();
        if (firstInvalid.isPresent()) {
            assert (false) : String.format("Distributed profile property, <%s>, also requires a comparison editor for the occupant value. Set using attrCustom(occCompEdAttr(...))", firstInvalid.get());
            return false;
        }
        return true;
    }

    public OccProfile() {
        this(null);
    }

    public OccProfile(OccProfile parent) {
        this.d_parent = parent;
        this.d_values = new LWPropertySet();
    }

    @Override
    public OccProfile clone() {
        return (OccProfile)super.clone();
    }

    public void setProfParent(OccProfile parent) {
        assert (this.d_parent == null || parent != null) : "If the profile parent is non-null, you must not set it to null.";
        assert (this.d_parent != null || parent == null) : "If a profile parent is already null, you must not set it to non-null.";
        if (this.d_parent != parent) {
            this.d_parent = parent;
            this.changedEvt(PROP_PROF_PARENT);
        }
    }

    public OccProfile getProfParent() {
        return this.d_parent;
    }

    private void clearDefaults() {
        OccProfile.streamProfileProps().filter(prop -> this.d_values.isDefined(prop.asProp()) && Objects.equals(this.d_values.get(prop.asProp()), prop.asProp().defVal)).forEach(prop -> this.remove(prop.asProp()));
    }

    public static Stream<IProfileProp<?, ?>> streamProfileProps() {
        return ALL_PROPS.props().stream().filter(p -> p instanceof IProfileProp).map(p -> (IProfileProp)((Object)p));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        TypedProp<Urn<String>> LEGACY_PROP_OCCMODEL;
        DisplayProp PROP_COMFORT_DIST;
        TypedProp[] checkProps;
        ICurve curve;
        in.defaultReadObject();
        if (this.d_data != null) {
            assert (this.d_values == null);
            this.d_values = new LWPropertySet(this.d_data);
            this.d_data = null;
        }
        DisplayProp PROP_CAN_USE_STAIRS = ((ProfileProps.DistPropBuilder)((ProfileProps.DistPropBuilder)OccProfile.newUrnProp(ProfileProps.Group.MOVEMENT, "OccProfile.CAN_USE_STAIRS", 339744713286479L, Boolean.class, new Urn<Boolean>(true), Intl.intl("Use Stairs"), "").attrMarkGeometric()).attrFormatValueWithToString()).attrToProp();
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0028) && this.isDefinedLocally(PROP_CURR_DOOR_PREF) && (curve = (ICurve)this.get(PROP_CURR_DOOR_PREF)) instanceof ConstantCurve) {
            ConstantCurve constantCurve = (ConstantCurve)curve;
            double val = constantCurve.getMax().getValue(Unit.ONE);
            ConstantCurve constantCurve2 = new ConstantCurve(new UnitDouble((1.0 - val) * 100.0, NonSI.PERCENT));
            this.set(PROP_CURR_DOOR_PREF, constantCurve2);
        }
        if (this.d_parent == null && MerlinOIS.isPrior(in, MerlinIO.Version.VER_0107)) {
            this.clearDefaults();
        }
        for (TypedProp checkProp : checkProps = new TypedProp[]{PROP_CAN_USE_STAIRS, PROP_ASSIST}) {
            Object val;
            if (!this.d_values.isDefined(checkProp) || !((val = this.d_values.get(checkProp)) instanceof Boolean)) continue;
            Boolean bval = (Boolean)val;
            val = new InfiniteUrn<Boolean>(bval);
            this.d_values.set(checkProp, val);
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0104) && this.isDefinedLocally(PROP_COMFORT_DIST = ((ProfileProps.DistPropBuilder)OccProfile.newCurveProp(ProfileProps.Group.NONE, "OccProfile.COMFORT_DIST", 29593671191177727L, new ConstantCurve(DEFAULT_COMFORT_DISTANCE), Intl.intl("Comfort Distance"), "", true, -1).attrFormatValueWithToString()).attrToProp())) {
            ICurve iCurve = (ICurve)this.remove(PROP_COMFORT_DIST);
            Spacing sval = new Spacing(SpacingType.COMFORT_DIST, iCurve);
            if (this.d_parent != null) {
                this.set(PROP_SPACING, sval);
            } else {
                this.set(PROP_SPACING, sval);
            }
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0116) && this.d_values.isDefined(LEGACY_PROP_OCCMODEL = TypedProps.newProp((Object)"OccProfile.OCCMODEL", theUtil.makeGeneric(IUrn.class), new Urn<String>(new String[0]), new Object[0]))) {
            IUrn iUrn = this.d_values.get(LEGACY_PROP_OCCMODEL);
            this.d_values.remove(LEGACY_PROP_OCCMODEL);
            IUrn<IAvatar> avatars = OccProfile.legacyConvertAvatars(iUrn);
            if (avatars != null) {
                this.d_values.set(PROP_OCCMODEL, avatars);
            }
        }
        if (this.d_parent == null && MerlinOIS.isPrior(in, MerlinIO.Version.VER_0109) && !this.isDefinedLocally(PROP_OCCMODEL)) {
            List<IAvatar> models = Arrays.asList(OccProfile.bea("BMan0001"), OccProfile.bea("BMan0002"), OccProfile.bea("BMan0003"), OccProfile.bea("BWom0001"), OccProfile.bea("BWom0002"), OccProfile.bea("CMan0001"), OccProfile.bea("CMan0002"), OccProfile.bea("CMan0003"), OccProfile.bea("CMan0012"), OccProfile.bea("CWom0001"), OccProfile.bea("CWom0018"), OccProfile.bea("CWom0019"));
            this.set(PROP_OCCMODEL, new Urn<IAvatar>((Collection<IAvatar>)models));
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0124)) {
            boolean bl;
            CompRestrictions restrictedComps = this.get(PROP_RESTRICTED_COMPONENTS);
            boolean bl2 = false;
            if (this.isDefinedLocally(PROP_CAN_USE_STAIRS)) {
                boolean bl3 = true;
                boolean useStairs = (Boolean)UrnUtil.getDominant((IUrn)this.retrieveProfileValue(PROP_CAN_USE_STAIRS, true));
                if (!useStairs) {
                    restrictedComps = restrictedComps.modifyTypeInfo(CompRestrictions.Type.STAIR, new CompRestrictions.CompRestrictionsInfo(false, CompRestrictions.Mode.NONE));
                } else if (restrictedComps.stairInfo.mode == CompRestrictions.Mode.NONE) {
                    restrictedComps = restrictedComps.modifyTypeInfo(CompRestrictions.Type.STAIR, new CompRestrictions.CompRestrictionsInfo(true, CompRestrictions.Mode.ALL));
                    HashSet<IMerlinObj> comps = new HashSet<IMerlinObj>(restrictedComps.comps);
                    comps.removeIf(o -> o instanceof EgressStair);
                    restrictedComps = restrictedComps.modifyObjs(comps);
                }
            }
            if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0140)) {
                DisplayProp PROP_WALK_ON_ESCALATORS = ((ProfileProps.DistPropBuilder)OccProfile.newUrnProp(ProfileProps.Group.MOVEMENT, "OccProfile.WALK_ON_ESCALATORS", -8844344359005193422L, Boolean.class, new Urn<Boolean>(false), Intl.intl("Walk on Escalators"), "").attrFormatValueWithToString()).attrToProp();
                boolean walkOnEscalator = (Boolean)UrnUtil.getDominant((IUrn)this.retrieveProfileValue(PROP_WALK_ON_ESCALATORS, true));
                this.set(PROP_ESCALATOR_PREF, walkOnEscalator ? new Urn<Object>(EscalatorPreference.WALK) : new Urn<Object>(EscalatorPreference.STAND_ANYWHERE));
            }
            if (this.getProfParent() == null) {
                bl = true;
                restrictedComps = restrictedComps.modifyTypeInfo(CompRestrictions.Type.ELEVATOR, new CompRestrictions.CompRestrictionsInfo(false, CompRestrictions.Mode.FROM_BEHAVIOR));
            }
            if (bl) {
                this.set(PROP_RESTRICTED_COMPONENTS, restrictedComps);
            }
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0165) && this.d_parent == null) {
            ICurve socialDist = (ICurve)this.get(PROP_SOCIAL_DIST);
            if (socialDist instanceof DisabledCurve || socialDist == OccProfile.PROP_SOCIAL_DIST.defVal) {
                this.set(PROP_SOCIAL_DIST_FILTER, new ObjsFilter(ObjsFilter.Mode.NONE, false, Collections.emptySet()));
                this.set(PROP_SOCIAL_DIST, (ICurve)OccProfile.PROP_SOCIAL_DIST.defVal);
            } else {
                this.set(PROP_SOCIAL_DIST_FILTER, new ObjsFilter(ObjsFilter.Mode.ALL, false, Collections.emptySet()));
            }
        }
    }

    public static IUrn<IAvatar> legacyConvertAvatars(IUrn<String> names) {
        if (names instanceof Urn) {
            ArrayList nameList = new ArrayList();
            names.getUnique(nameList);
            ArrayList<IAvatar> avatarList = new ArrayList<IAvatar>(nameList.size());
            for (String name : nameList) {
                avatarList.add(OccProfile.bea(name));
            }
            return new Urn<IAvatar>((Collection<IAvatar>)avatarList);
        }
        if (names != null) {
            Map<String, Double> nameWeights = names.getWeights();
            HashMap<IAvatar, Double> avatarWeights = new HashMap<IAvatar, Double>(nameWeights.size());
            for (Map.Entry<String, Double> entry : nameWeights.entrySet()) {
                avatarWeights.put(OccProfile.bea(entry.getKey()), entry.getValue());
            }
            return UrnUtil.newUrn(avatarWeights);
        }
        return null;
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return ALL_PROPS;
    }

    @Deprecated
    public static ProfileProps.UnaryProp<ObjsFilter<String>> getLegacyPre170SocialDistProp() {
        return ((ProfileProps.UnaryPropBuilder)ProfileProps.buildUnaryProp(null, "OccProfile.PROP_SOCIAL_DIST_FILTER", OccProfile.filterType(String.class), ObjsFilter.rejectAll(String.class), "", "").attrFormatValueWithToString()).attrToProp();
    }

    @Deprecated
    public ObjsFilter<String> getLegacyPre170SocialDistFilter() {
        ProfileProps.UnaryProp<ObjsFilter<String>> LEGACY_PROP_SOCIAL_DIST_FILTER = OccProfile.getLegacyPre170SocialDistProp();
        return this.retrieveProfileValue(LEGACY_PROP_SOCIAL_DIST_FILTER, true);
    }

    public boolean isDefinedLocally(IPropertySet.Prop<?> prop) {
        if (prop == PROP_SHAPE) {
            return this.isDefinedLocally(PROP_VEHICLE_SHAPE) || this.isDefinedLocally(PROP_DIAMETER) || this.isDefinedLocally(PROP_GEOM_DIAMETER) || this.isDefinedLocally(PROP_HEIGHT) || this.isDefinedLocally(PROP_MIN_SQUEEZE_FACTOR_CONST);
        }
        return this.d_values.isDefined(prop);
    }

    public <T> T remove(TypedProp<T> prop) {
        if (prop == PROP_SHAPE) {
            T old = this.get(prop);
            this.pauseUpdates();
            this.remove(PROP_VEHICLE_SHAPE);
            this.remove(PROP_DIAMETER);
            this.remove(PROP_GEOM_DIAMETER);
            this.remove(PROP_HEIGHT);
            this.remove(PROP_MIN_SQUEEZE_FACTOR_CONST);
            this.resumeUpdates();
            return old;
        }
        if (this.d_values.isDefined(prop)) {
            T result = this.d_values.get(prop);
            this.d_values.remove(prop);
            this.changedEvt(prop);
            return result;
        }
        return null;
    }

    public void removeAll() {
        if (!this.d_values.isEmpty()) {
            this.d_values.clear();
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public void initProfileValueStorage() {
        this.d_values = new LWPropertySet();
    }

    @Override
    public String getName() {
        return this.get(PROP_NAME);
    }

    @Override
    public void setName(String name) {
        this.set(PROP_NAME, name);
    }

    public String toString() {
        return "OccProfile[name=" + this.getName() + "]";
    }

    public int getNumLocal() {
        return this.d_values.size();
    }

    private static IAvatar bea(String name) {
        return new ResourceAvatar(String.format("md5/%1$s/%1$s.bea", name));
    }

    public static Collection<IAvatar> getDefaultAvatars() {
        return Arrays.asList(OccProfile.bea("BMan0001"), OccProfile.bea("BMan0002"), OccProfile.bea("BMan0003"), OccProfile.bea("BMan0012"), OccProfile.bea("BWom0001"), OccProfile.bea("BWom0002"), OccProfile.bea("BWom0011"), OccProfile.bea("CMan0001"), OccProfile.bea("CMan0002"), OccProfile.bea("CMan0003"), OccProfile.bea("CMan0012"), OccProfile.bea("CWom0001"), OccProfile.bea("CWom0018"), OccProfile.bea("CWom0019"));
    }

    public static <T> Function<IUrn<T>, String> urnFormatter(Function<T, String> valFormat) {
        return DisplayProps.urnFormatter(valFormat);
    }

    private UnitDouble getSpacingVal(long profSeed, long orientSeed) {
        return this.toOccValue(OccProfile.PROP_SPACING, (long)profSeed, (long)orientSeed).val.getAvg();
    }

    public static double getComfortDistanceFromDensity(double d, double r) {
        return Math.max(2.0 / (Math.sqrt(d) * Math.pow(12.0, 0.25)) - 2.0 * r, 0.0);
    }

    public <SampledT, DistT> SampledT toOccValue(IProfileProp<SampledT, DistT> oprop, long profileSeed, long orientSeed) {
        Object distVal = this.get(oprop.asProp());
        return oprop.toOccValue(this, distVal, profileSeed, orientSeed);
    }

    public static IFunction1d getSFPEFundamentalCurve(double ymin) {
        double a = 0.266;
        double m = -0.31158486587794304;
        double b = 1.0 - m * 0.55;
        double xmin = (ymin - b) / m;
        double[] x = new double[]{0.55, xmin};
        double[] y = new double[]{1.0, ymin};
        PiecewiseFunction1d.Entry[] entries = new PiecewiseFunction1d.Entry[]{new PiecewiseFunction1d.Entry(SIUS.newud(x[0], 3), new UnitDouble(y[0], Unit.ONE)), new PiecewiseFunction1d.Entry(SIUS.newud(x[1], 3), new UnitDouble(y[1], Unit.ONE))};
        return new PiecewiseFunction1d(entries);
    }

    public PropHasher getHasher() {
        return this.getHasher(Predicates.alwaysTrue());
    }

    public PropHasher getHasher(Predicate<IPropertySet.Prop> propFilter) {
        return new PropHasher(this, propFilter);
    }

    public static IValEditor<IProfileFunction> newSlopedFundEditor(ProfileProps.ProfileFunctionProp prop, Supplier<IFunction1d> levelFund) {
        List<MultiValEditor.Entry<IFunction1d, ? extends IFunction1d>> fentries = Function1dEditorFactory.getEntries(prop.fprop, false, levelFund, Function1dEditorFactory.GENERAL_TYPES);
        ArrayList entries = new ArrayList(fentries.size() + 1);
        entries.add(new MultiValEditor.Entry<IProfileFunction, FromLevelFundamental>(Intl.intl("From Level Terrain"), Intl.intl("Use the same speed-density function as for level terrain."), new FixedValEditor<FromLevelFundamental>(FromLevelFundamental.class, FromLevelFundamental.INSTANCE), f -> f != null, () -> true, f -> FromLevelFundamental.INSTANCE));
        for (MultiValEditor.Entry<IFunction1d, ? extends IFunction1d> fentry : fentries) {
            entries.add(new MultiValEditor.Entry<IProfileFunction, ConstProfileFunction>(fentry.key, fentry.tooltip, new ProfileFunctionEditor(fentry.editor), f -> f != null && fentry.editor.getType().isInstance(f.function) && fentry.filter.test(f.function), () -> fentry.init.getAsBoolean(), f -> {
                if (f == null) {
                    return new ConstProfileFunction((IFunction1d)fentry.converter.apply(null));
                }
                if (f instanceof FromLevelFundamental) {
                    return new ConstProfileFunction((IFunction1d)fentry.converter.apply((IFunction1d)levelFund.get()));
                }
                if (f instanceof ConstProfileFunction) {
                    ConstProfileFunction pf = (ConstProfileFunction)f;
                    IFunction1d cfunc = (IFunction1d)fentry.converter.apply(pf.function);
                    return cfunc == pf.function ? pf : new ConstProfileFunction(cfunc);
                }
                assert (false);
                return null;
            }));
        }
        return new MultiValEditor(IProfileFunction.class, entries, false);
    }

    @Override
    public <T> T retrieveProfileValue(TypedProp<T> prop, boolean serialized) {
        OccProfile prof = this;
        while (prof != null) {
            if (prof.d_values.isDefined(prop)) {
                return prof.d_values.get(prop);
            }
            prof = prof.d_parent;
        }
        return (T)prop.defVal;
    }

    @Override
    public <T> boolean storeProfileValue(TypedProp<T> prop, T value, boolean serialized, boolean mutable) {
        if (this.d_parent == null) {
            T prev = this.d_values.get(prop);
            if (mutable) {
                this.d_values.set(prop, value);
                return prev != value;
            }
            this.d_values.setIfNotDefault(prop, value);
            return !Objects.equals(prev, value);
        }
        boolean prevDefined = this.d_values.isDefined(prop);
        T prev = this.d_values.get(prop);
        if (mutable) {
            this.d_values.set(prop, value);
            return !prevDefined || prev != value;
        }
        this.d_values.set(prop, value);
        return !prevDefined || !Objects.equals(prev, value);
    }

    static {
        assert (OccProfile.validateProps());
    }

    private static enum PredefAnimTags {
        DEFAULT_UPRIGHT(false, Intl.intl("<default>"), Intl.intl("Occupants idle in a standing position."), Intl.intl("Occupants walk normally."), "default", "upright"),
        IDLE_SIT_GROUND(true, Intl.intl("Sit (ground)"), Intl.intl("Occupants sit on the ground."), null, "sit", "ground"),
        IDLE_LAY_LATERAL_INJURED(true, Intl.intl("Lie (injured)"), Intl.intl("Occupants lie on their side while injured."), null, "lay", "side", "injured"),
        DEFAULT_LAY_SUPINE(false, Intl.intl("Lie (back)"), Intl.intl("Occupants lie on their back facing upward."), Intl.intl("Occupants lie on their back facing upward while moving. This is normally only used for occupants using a bed."), "default", "lay", "supine"),
        DEFAULT_WHEELCHAIR(false, Intl.intl("Wheelchair"), Intl.intl("Occupants sit as if they're in a wheelchair."), Intl.intl("Occupants move as if they're operating a wheelchair."), "default", "wheelchair");

        public final String name;
        public final String idleDescription;
        public final String moveDescription;
        public final boolean idleOnly;
        public final Set<String> tags;
        public final IUrn<Set<String>> dist;

        private PredefAnimTags(boolean idleOnly, String name, String idleDesciption, String moveDescription, String ... tags) {
            this.name = name;
            this.idleOnly = idleOnly;
            this.idleDescription = idleDesciption;
            this.moveDescription = moveDescription;
            this.tags = Sets.fromArrayLHS(tags);
            this.dist = new Urn<Set<String>>((Collection<Set<String>>)Collections.singleton(this.tags));
        }

        public String getNameLabel() {
            return this.name.replace("<", "&lt;").replace(">", "&gt;");
        }
    }

    public static class Spacing
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final SpacingType type;
        public final ICurve val;

        public Spacing(SpacingType type, ICurve val) {
            this.type = type;
            this.val = val;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Spacing && ((Spacing)o).type == this.type && ((Spacing)o).val.equals(this.val);
        }

        public int hashCode() {
            return 0xA234FF3E ^ Objects.hash(new Object[]{this.type, this.val});
        }

        public String format() {
            if (this.type == SpacingType.COMFORT_DIST) {
                return String.format("%s", guiCurveUtil.format(this.val));
            }
            return String.format("%s=%s", this.type.desc, guiCurveUtil.format(this.val));
        }

        public String toString() {
            return this.format();
        }

        public boolean isConstant() {
            return this.val.isConstant();
        }

        public Spacing getValue(OccProfile profile, long spacingSeed, long profileSeed) {
            if (this.val.isConstant()) {
                return this;
            }
            long newSeed = spacingSeed ^ profileSeed;
            Random rand = new Random(newSeed);
            return new Spacing(this.type, new ConstantCurve(this.val.getValue(rand)));
        }
    }

    public static enum SpacingType {
        COMFORT_DIST(Intl.intl("Personal Distance"), (agent, rnd) -> agent.getProfile().getSpacingVal(agent.getProfileSeed(), agent.getOrientSeed())),
        DENSITY(Intl.intl("From Queue Density"), (agent, rnd) -> {
            UnitDouble radius = agent.toOccValue(PROP_DIAMETER).scale(0.5);
            UnitDouble density = agent.getProfile().getSpacingVal(agent.getProfileSeed(), agent.getOrientSeed());
            double cd = OccProfile.getComfortDistanceFromDensity(density.getValue(Unit.ONE.divide(SI.METER.pow(2))), radius.getValue(SI.METER));
            return new UnitDouble(cd, SI.METER);
        }),
        AREA(Intl.intl("From Queue Area"), (agent, rnd) -> {
            UnitDouble radius = agent.toOccValue(PROP_DIAMETER).scale(0.5);
            UnitDouble area = agent.getProfile().getSpacingVal(agent.getProfileSeed(), agent.getOrientSeed());
            double cd = OccProfile.getComfortDistanceFromDensity(1.0 / area.getValue(SI.METER.pow(2)), radius.getValue(SI.METER));
            return new UnitDouble(cd, SI.METER);
        });

        public final String desc;
        public final BiFunction<EgressAgent, Random, UnitDouble> getComfortDist;

        private SpacingType(String desc, BiFunction<EgressAgent, Random, UnitDouble> gcd) {
            this.desc = desc;
            this.getComfortDist = gcd;
        }
    }

    public static class CompRestrictions
    implements Serializable,
    Cloneable,
    ISurrogate {
        static final long serialVersionUID = 1L;
        public static final CompRestrictionsInfo ALL = new CompRestrictionsInfo(true, Mode.ALL);
        private static final Predicate<EgressStair> isEscalator = stair -> stair.isEscalator();
        private static final Predicate<EgressStair> isStair = isEscalator.negate();
        private static final Predicate<EgressCorridor> isMovingWalkway = ramp -> ramp.isMovingWalkway();
        private static final Predicate<EgressCorridor> isWalkway = ramp -> ramp.isWalkway();
        private Set<IMerlinObj> comps;
        private CompRestrictionsInfo roomInfo;
        private CompRestrictionsInfo doorInfo;
        private CompRestrictionsInfo stairInfo;
        private CompRestrictionsInfo escalatorInfo;
        private CompRestrictionsInfo rampInfo;
        private CompRestrictionsInfo movingWalkwayInfo;
        private CompRestrictionsInfo elevatorInfo;

        public CompRestrictions() {
            this(Collections.emptySet(), Collections.emptyMap());
        }

        public CompRestrictions(Set<IMerlinObj> comps, Map<Type, CompRestrictionsInfo> infos) {
            this.comps = Collections.unmodifiableSet(comps);
            for (Type type : Type.values()) {
                type.set.accept(this, infos.getOrDefault((Object)type, ALL));
            }
        }

        public CompRestrictions(Set<IMerlinObj> comps, CompRestrictionsInfo doorInfo, CompRestrictionsInfo roomInfo, CompRestrictionsInfo stairInfo, CompRestrictionsInfo escalatorInfo, CompRestrictionsInfo rampInfo, CompRestrictionsInfo movingWalkwayInfo, CompRestrictionsInfo elevatorInfo) {
            this.comps = Collections.unmodifiableSet(comps);
            this.doorInfo = doorInfo;
            this.roomInfo = roomInfo;
            this.stairInfo = stairInfo;
            this.escalatorInfo = escalatorInfo;
            this.rampInfo = rampInfo;
            this.movingWalkwayInfo = movingWalkwayInfo;
            this.elevatorInfo = elevatorInfo;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.escalatorInfo == null) {
                this.escalatorInfo = new CompRestrictionsInfo(this.stairInfo.rejected, this.stairInfo.mode);
            }
            if (this.movingWalkwayInfo == null) {
                this.movingWalkwayInfo = new CompRestrictionsInfo(this.rampInfo.rejected, this.rampInfo.mode);
            }
        }

        public CompRestrictions modifyObjs(Set<IMerlinObj> objs) {
            CompRestrictions clone = this.clone();
            clone.comps = Collections.unmodifiableSet(objs);
            for (Type type : Type.values()) {
                if (!clone.getObjects(type).isEmpty()) continue;
                CompRestrictionsInfo info = clone.getTypeInfo(type);
                Mode newMode = info.rejected ? Mode.ALL : Mode.NONE;
                CompRestrictionsInfo newInfo = info.applyMode(newMode);
                type.set.accept(clone, newInfo);
            }
            return clone;
        }

        public Set<IMerlinObj> getObjs() {
            return this.comps;
        }

        public boolean isAccepted(IMerlinObj obj) {
            EgressStair stair;
            CompRestrictionsInfo info = this.getTypeInfo(obj);
            boolean typeAccepted = CompRestrictions.isTypeAccepted(info);
            if (obj instanceof EgressStair && (stair = (EgressStair)obj).isEscalator() && (this.escalatorInfo.mode == Mode.UP_ONLY || this.escalatorInfo.mode == Mode.DOWN_ONLY)) {
                if (this.escalatorInfo.mode == Mode.UP_ONLY) {
                    typeAccepted ^= stair.isOrientedUp();
                }
                if (this.escalatorInfo.mode == Mode.DOWN_ONLY) {
                    typeAccepted ^= stair.isOrientedDown();
                }
                if (!stair.isOrientedDown() && !stair.isOrientedUp()) {
                    typeAccepted = !typeAccepted;
                }
            }
            return typeAccepted && this.comps.contains(obj) || !typeAccepted && !this.comps.contains(obj);
        }

        public CompRestrictions accept(Collection<? extends IMerlinObj> objs) {
            return this.add(objs, true);
        }

        public CompRestrictions reject(Collection<? extends IMerlinObj> objs) {
            return this.add(objs, false);
        }

        public Set<IMerlinObj> getComps() {
            return Collections.unmodifiableSet(this.comps);
        }

        private CompRestrictions add(Collection<? extends IMerlinObj> objs, boolean accept) {
            if (objs.stream().allMatch(o -> this.isAccepted((IMerlinObj)o) == accept)) {
                return this;
            }
            CompRestrictions modified = this.clone();
            HashSet<IMerlinObj> comps = new HashSet<IMerlinObj>(modified.comps);
            for (IMerlinObj iMerlinObj : objs) {
                Type type = CompRestrictions.getType(iMerlinObj);
                if (type == null) continue;
                CompRestrictionsInfo info = type.get.apply(modified);
                boolean typeAccepted = CompRestrictions.isTypeAccepted(info);
                if (accept == typeAccepted) {
                    comps.add(iMerlinObj);
                    type.set.accept(modified, info.applyMode(Mode.FROM_LIST));
                    continue;
                }
                comps.remove(iMerlinObj);
            }
            return modified.modifyObjs(comps);
        }

        public static boolean isTypeAccepted(CompRestrictionsInfo info) {
            return !info.rejected;
        }

        public static Mode getTypeMode(CompRestrictionsInfo info) {
            return info.mode;
        }

        private static Type getType(IMerlinObj obj) {
            Type result = Stream.of(Type.values()).filter(t -> t.clazz.isInstance(obj) && t.filter.test(obj)).findFirst().orElse(null);
            if (result == null) {
                assert (false);
                return null;
            }
            return result;
        }

        public CompRestrictionsInfo getTypeInfo(IMerlinObj obj) {
            Type type = CompRestrictions.getType(obj);
            if (type == null) {
                return null;
            }
            return type.get.apply(this);
        }

        public CompRestrictionsInfo getTypeInfo(Type type) {
            return type.get.apply(this);
        }

        public CompRestrictions modifyTypeInfo(IMerlinObj obj, CompRestrictionsInfo info) {
            Type type = CompRestrictions.getType(obj);
            if (type == null) {
                return null;
            }
            return this.modifyTypeInfo(type, info);
        }

        public CompRestrictions modifyTypeInfo(Type type, CompRestrictionsInfo info) {
            if (type.get.apply(this).equals(info)) {
                return this;
            }
            CompRestrictions result = this.clone();
            type.set.accept(result, info);
            return result;
        }

        protected final CompRestrictions clone() {
            try {
                return (CompRestrictions)super.clone();
            }
            catch (CloneNotSupportedException e) {
                assert (false);
                return null;
            }
        }

        public <T extends IMerlinObj> Set<T> getObjs(Class<T> clazz) {
            HashSet<IMerlinObj> objs = new HashSet<IMerlinObj>();
            for (IMerlinObj obj : this.comps) {
                if (!clazz.isInstance(obj)) continue;
                objs.add(obj);
            }
            return objs;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CompRestrictions otherRest = (CompRestrictions)other;
            return this.comps.equals(otherRest.comps) && this.compareRestrictions(otherRest);
        }

        public int hashCode() {
            return this.comps.hashCode() + Stream.of(Type.values()).mapToInt(t -> t.get.apply(this).hashCode()).sum();
        }

        @Override
        public boolean surrogateEquals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CompRestrictions otherRest = (CompRestrictions)other;
            return theUtil.surrogateSetsEqual(this.comps, otherRest.comps) && this.compareRestrictions(otherRest);
        }

        private boolean compareRestrictions(CompRestrictions otherRest) {
            return Stream.of(Type.values()).allMatch(t -> t.get.apply(otherRest).equals(t.get.apply(this)));
        }

        public <T extends IMerlinObj> Set<T> getRejected(Class<T> clazz, Composite<? extends IMerlinObj> root, CompRestrictionsInfo cr) {
            return this.getRejected(clazz, root, cr, Predicates.alwaysTrue(), false);
        }

        public <T extends IMerlinObj> Set<T> getRejected(Class<T> clazz, Composite<? extends IMerlinObj> root, CompRestrictionsInfo cr, Predicate<IMerlinObj> filter, boolean alwaysAddToList) {
            return this.get(clazz, root, filter, false, cr, alwaysAddToList);
        }

        public <T extends IMerlinObj> Set<T> getAccepted(Class<T> clazz, Composite<? extends IMerlinObj> root, CompRestrictionsInfo cr) {
            return this.getAccepted(clazz, root, cr, Predicates.alwaysTrue(), false);
        }

        public <T extends IMerlinObj> Set<T> getAccepted(Class<T> clazz, Composite<? extends IMerlinObj> root, CompRestrictionsInfo cr, Predicate<IMerlinObj> filter, boolean alwaysAddToList) {
            return this.get(clazz, root, filter, true, cr, alwaysAddToList);
        }

        private <T extends IMerlinObj> Set<T> get(Class<T> clazz, Composite<? extends IMerlinObj> root, Predicate<IMerlinObj> filter, boolean accept, CompRestrictionsInfo cr, boolean alwaysAddToList) {
            ArrayList<IMerlinObj> list;
            Set<T> objs = this.getObjs(clazz);
            if (CompRestrictions.isTypeAccepted(cr) == accept && !alwaysAddToList) {
                return theUtil.filter(objs, filter);
            }
            HashSet<T> allObjs = new HashSet<T>(root.flatten(clazz));
            if (clazz == EgressStair.class && cr == this.stairInfo && allObjs.size() > 0) {
                list = new ArrayList<IMerlinObj>();
                for (IMerlinObj obj : allObjs) {
                    if (!isEscalator.test((EgressStair)obj)) continue;
                    list.add(obj);
                }
                allObjs.removeAll(list);
            }
            if (clazz == EgressStair.class && cr == this.escalatorInfo && allObjs.size() > 0) {
                list = new ArrayList();
                for (IMerlinObj obj : allObjs) {
                    if (isEscalator.test((EgressStair)obj)) continue;
                    list.add(obj);
                }
                allObjs.removeAll(list);
            }
            if (clazz == EgressCorridor.class && cr == this.rampInfo && allObjs.size() > 0) {
                list = new ArrayList();
                for (IMerlinObj obj : allObjs) {
                    if (!isMovingWalkway.test((EgressCorridor)obj)) continue;
                    list.add(obj);
                }
                allObjs.removeAll(list);
            }
            if (clazz == EgressCorridor.class && cr == this.movingWalkwayInfo && allObjs.size() > 0) {
                list = new ArrayList();
                for (IMerlinObj obj : allObjs) {
                    if (isMovingWalkway.test((EgressCorridor)obj)) continue;
                    list.add(obj);
                }
                allObjs.removeAll(list);
            }
            allObjs.removeAll(objs);
            return theUtil.filter(allObjs, filter);
        }

        public Set<IMerlinObj> getAllRejected(MerlinData md) {
            HashSet<IMerlinObj> allRejected = new HashSet<IMerlinObj>();
            CompRestrictions cr = this;
            boolean alwaysAddEscalatorsToList = this.escalatorInfo.mode == Mode.UP_ONLY || this.escalatorInfo.mode == Mode.DOWN_ONLY;
            allRejected.addAll(this.getRejected(EgressRoom.class, md.floors, cr.roomInfo));
            allRejected.addAll(this.getRejected(EgressDoor.class, md.floors, cr.doorInfo));
            allRejected.addAll(this.getRejected(EgressStair.class, md.floors, cr.stairInfo, stair -> !((EgressStair)stair).isEscalator(), false));
            allRejected.addAll(this.getRejected(EgressStair.class, md.floors, cr.escalatorInfo, stair -> ((EgressStair)stair).isEscalator(), alwaysAddEscalatorsToList));
            allRejected.addAll(this.getRejected(EgressCorridor.class, md.floors, cr.rampInfo, comp -> !(comp instanceof EgressStair) && !((EgressCorridor)comp).isMovingWalkway(), false));
            allRejected.addAll(this.getRejected(EgressCorridor.class, md.floors, cr.movingWalkwayInfo, comp -> !(comp instanceof EgressStair) && ((EgressCorridor)comp).isMovingWalkway(), false));
            allRejected.addAll(this.getRejected(Elevator.class, md.elevators, cr.elevatorInfo));
            if (this.escalatorInfo.mode == Mode.UP_ONLY || this.escalatorInfo.mode == Mode.DOWN_ONLY) {
                HashSet<IMerlinObj> finalRejected = new HashSet<IMerlinObj>();
                for (IMerlinObj comp2 : allRejected) {
                    if (comp2 instanceof EgressStair && ((EgressStair)comp2).isEscalator()) {
                        if (!((EgressStair)comp2).isOrientedUp() && !((EgressStair)comp2).isOrientedDown()) {
                            finalRejected.add(comp2);
                        }
                        if (this.escalatorInfo.mode == Mode.UP_ONLY && ((EgressStair)comp2).isOrientedDown()) {
                            finalRejected.add(comp2);
                        }
                        if (this.escalatorInfo.mode != Mode.DOWN_ONLY || !((EgressStair)comp2).isOrientedUp()) continue;
                        finalRejected.add(comp2);
                        continue;
                    }
                    finalRejected.add(comp2);
                }
                return finalRejected;
            }
            return allRejected;
        }

        public Set<IMerlinObj> getAllAccepted(MerlinData md) {
            HashSet<IMerlinObj> allAccepted = new HashSet<IMerlinObj>();
            CompRestrictions cr = this;
            boolean alwaysAddToList = this.escalatorInfo.mode == Mode.UP_ONLY || this.escalatorInfo.mode == Mode.DOWN_ONLY;
            allAccepted.addAll(this.getAccepted(EgressRoom.class, md.floors, cr.roomInfo));
            allAccepted.addAll(this.getAccepted(EgressDoor.class, md.floors, cr.doorInfo));
            allAccepted.addAll(this.getAccepted(EgressStair.class, md.floors, cr.stairInfo, stair -> !((EgressStair)stair).isEscalator(), false));
            allAccepted.addAll(this.getAccepted(EgressStair.class, md.floors, cr.escalatorInfo, stair -> ((EgressStair)stair).isEscalator(), alwaysAddToList));
            allAccepted.addAll(this.getAccepted(EgressCorridor.class, md.floors, cr.rampInfo, comp -> !(comp instanceof EgressStair) && !((EgressCorridor)comp).isMovingWalkway(), false));
            allAccepted.addAll(this.getAccepted(EgressCorridor.class, md.floors, cr.movingWalkwayInfo, comp -> !(comp instanceof EgressStair) && ((EgressCorridor)comp).isMovingWalkway(), false));
            allAccepted.addAll(this.getAccepted(Elevator.class, md.elevators, cr.elevatorInfo));
            if (this.escalatorInfo.mode == Mode.DOWN_ONLY || this.escalatorInfo.mode == Mode.UP_ONLY) {
                HashSet<IMerlinObj> finalAccepted = new HashSet<IMerlinObj>();
                for (IMerlinObj comp2 : allAccepted) {
                    if (comp2 instanceof EgressStair && ((EgressStair)comp2).isEscalator()) {
                        if (this.escalatorInfo.mode == Mode.UP_ONLY && ((EgressStair)comp2).isOrientedUp()) {
                            finalAccepted.add(comp2);
                        }
                        if (this.escalatorInfo.mode != Mode.DOWN_ONLY || !((EgressStair)comp2).isOrientedDown()) continue;
                        finalAccepted.add(comp2);
                        continue;
                    }
                    finalAccepted.add(comp2);
                }
                return finalAccepted;
            }
            return allAccepted;
        }

        public String format() {
            return "";
        }

        public static boolean isAcceptableType(Class<? extends IMerlinObj> clazz) {
            List<Class<?>> allowedClasses = Arrays.asList(CompRestrictions.getAllowedClasses());
            return allowedClasses.contains(clazz);
        }

        public static Class<?>[] getAllowedClasses() {
            return new Class[]{EgressDoor.class, EgressRoom.class, EgressStair.class, EgressCorridor.class, Elevator.class};
        }

        public static boolean allAcceptableTypes(MerlinSelectionModel sel) {
            List<Class<?>> allowedClasses = Arrays.asList(CompRestrictions.getAllowedClasses());
            for (IMerlinObj obj : sel.flatten(IMerlinObj.class)) {
                if (allowedClasses.contains(obj.getClass())) continue;
                return false;
            }
            return true;
        }

        public Collection<IMerlinObj> getObjects(Type type) {
            return theUtil.filter(this.comps, type.clazz, type.filter);
        }

        public static <SrcT extends IMerlinObj, T extends IMerlinObj> DepCallback<MerlinData, SrcT, CompRestrictions, T> newCallback(ProfileProps.UnaryProp<CompRestrictions> prop, Type type) {
            return Dependencies.newDependency(prop, DLink.WEAK, type.clazz, (md, src, restr) -> restr.getObjects(type).stream(), type.filter, (md, src, oldRestr, old, repl) -> {
                if (oldRestr == null) {
                    assert (false) : String.format("Unexpected null CompRestrictions from %s.", src.getName());
                    return null;
                }
                HashSet<IMerlinObj> newObjs = new HashSet<IMerlinObj>(oldRestr.comps);
                newObjs.remove(old);
                if (repl != null) {
                    newObjs.add((IMerlinObj)repl);
                }
                return oldRestr.modifyObjs(newObjs);
            });
        }

        public static enum Type {
            DOOR(EgressDoor.class, Intl.intl("Use Doors:"), Intl.intl("Restricted Doors"), r -> r.doorInfo, (r, c) -> {
                r.doorInfo = c;
            }, Mode.ALL, Mode.NONE, Mode.FROM_LIST),
            ROOM(EgressRoom.class, Intl.intl("Use Rooms:"), Intl.intl("Restricted Rooms"), r -> r.roomInfo, (r, c) -> {
                r.roomInfo = c;
            }, Mode.ALL, Mode.NONE, Mode.FROM_LIST),
            STAIR(EgressStair.class, isStair, Intl.intl("Use Stairs:"), Intl.intl("Restricted Stairs"), r -> r.stairInfo, (r, c) -> {
                r.stairInfo = c;
            }, Mode.ALL, Mode.NONE, Mode.FROM_LIST),
            ESCALATOR(EgressStair.class, isEscalator, Intl.intl("Use Escalators:"), Intl.intl("Restricted Escalators"), r -> r.escalatorInfo, (r, c) -> {
                r.escalatorInfo = c;
            }, Mode.ALL, Mode.NONE, Mode.UP_ONLY, Mode.DOWN_ONLY, Mode.FROM_LIST),
            RAMP(EgressCorridor.class, isWalkway, Intl.intl("Use Ramps:"), Intl.intl("Restricted Ramps"), r -> r.rampInfo, (r, c) -> {
                r.rampInfo = c;
            }, Mode.ALL, Mode.NONE, Mode.FROM_LIST),
            MOVING_WALKWAY(EgressCorridor.class, isMovingWalkway, Intl.intl("Use Moving Walkways:"), Intl.intl("Restricted Moving Walkways"), r -> r.movingWalkwayInfo, (r, c) -> {
                r.movingWalkwayInfo = c;
            }, Mode.ALL, Mode.NONE, Mode.FROM_LIST),
            ELEVATOR(Elevator.class, Intl.intl("Use Elevators:"), Intl.intl("Restricted Elevators"), r -> r.elevatorInfo, (r, c) -> {
                r.elevatorInfo = c;
            }, Mode.ALL, Mode.NONE, Mode.FROM_LIST, Mode.FROM_BEHAVIOR);

            public final Class<? extends IMerlinObj> clazz;
            public final Predicate filter;
            public final String lbl;
            public final String chooserLbl;
            public final Set<Mode> modes;
            private final Function<CompRestrictions, CompRestrictionsInfo> get;
            private final BiConsumer<CompRestrictions, CompRestrictionsInfo> set;

            private <T extends IMerlinObj> Type(Class<T> type, Predicate<? super T> test, String lbl, String chooserLbl, Function<CompRestrictions, CompRestrictionsInfo> get, BiConsumer<CompRestrictions, CompRestrictionsInfo> set, Mode ... modes) {
                this.clazz = type;
                this.filter = test;
                this.get = get;
                this.set = set;
                this.lbl = lbl;
                this.chooserLbl = chooserLbl;
                this.modes = Sets.fromArrayLHS(modes);
            }

            private <T extends IMerlinObj> Type(Class<T> type, String lbl, String chooserLbl, Function<CompRestrictions, CompRestrictionsInfo> get, BiConsumer<CompRestrictions, CompRestrictionsInfo> set, Mode ... modes) {
                this(type, Predicates.alwaysTrue(), lbl, chooserLbl, get, set, modes);
            }
        }

        public static class CompRestrictionsInfo
        implements Serializable {
            static final long serialVersionUID = 1L;
            public final boolean rejected;
            public final Mode mode;

            public CompRestrictionsInfo(boolean rejected, Mode mode) {
                this.rejected = rejected;
                this.mode = mode;
            }

            public CompRestrictionsInfo applyRejected(boolean rejected) {
                if (rejected == this.rejected) {
                    return this;
                }
                return new CompRestrictionsInfo(rejected, this.mode);
            }

            public CompRestrictionsInfo applyMode(Mode mode) {
                if (mode == this.mode) {
                    return this;
                }
                return new CompRestrictionsInfo(this.rejected, mode);
            }

            public CompRestrictionsInfo() {
                this(true, Mode.ALL);
            }

            public boolean equals(Object other) {
                if (!(other instanceof CompRestrictionsInfo)) {
                    return false;
                }
                return this.rejected == ((CompRestrictionsInfo)other).rejected && this.mode == ((CompRestrictionsInfo)other).mode;
            }

            public int hashCode() {
                return this.mode.hashCode() + (this.rejected ? 1 : 0);
            }
        }

        public static enum Mode {
            ALL(Intl.intl("All"), Intl.intl("Allow all components to be used.")),
            NONE(Intl.intl("None"), Intl.intl("Allow no components to be used.")),
            FROM_LIST(Intl.intl("From List..."), Intl.intl("Choose allowed components from a list.")),
            UP_ONLY(Intl.intl("Up Only"), Intl.intl("Only allow components that move occupants up.")),
            DOWN_ONLY(Intl.intl("Down Only"), Intl.intl("Only allow components that move occupants down.")),
            FROM_BEHAVIOR(Intl.intl("Based on Behavior"), Intl.intl("Only use elevators if part of a \"Goto Elevator\" behavior action."));

            public final String name;
            public final String desc;

            private Mode(String name, String desc) {
                this.name = name;
                this.desc = desc;
            }
        }
    }

    public static class PropHasher {
        public final OccProfile profile;
        public final Predicate<IPropertySet.Prop> propFilter;

        public PropHasher(OccProfile profile, Predicate<IPropertySet.Prop> propFilter) {
            this.profile = profile;
            this.propFilter = propFilter;
        }

        public int hashCode() {
            List<Object> values = OccProfile.streamProfileProps().filter(prop -> this.propFilter.test(prop.asProp())).map(prop -> this.profile.get(prop.asProp())).toList();
            return 0x437FA3 ^ values.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PropHasher)) {
                return false;
            }
            PropHasher hasher = (PropHasher)obj;
            if (hasher.profile == this.profile) {
                return true;
            }
            return OccProfile.streamProfileProps().filter(prop -> this.propFilter.test(prop.asProp())).allMatch(prop -> {
                Object v1 = this.profile.get(prop.asProp());
                Object v2 = hasher.profile.get(prop.asProp());
                return Objects.deepEquals(v1, v2);
            });
        }
    }

    public static class FromLevelFundamental
    implements IProfileFunction,
    Serializable {
        static final long serialVersionUID = 1L;
        public static final FromLevelFundamental INSTANCE = new FromLevelFundamental();

        private FromLevelFundamental() {
        }

        @Override
        public IFunction1d apply(OccProfile profile) {
            if (profile == null) {
                return null;
            }
            return profile.get(PROP_FUNDAMENTAL);
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }

        @Override
        public String format() {
            return Intl.intl("From Fundamental");
        }
    }

    public static interface IProfileFunction
    extends Function<OccProfile, IFunction1d> {
        public String format();

        @Override
        public IFunction1d apply(OccProfile var1);
    }

    public static class ConstProfileFunction
    implements IProfileFunction,
    Serializable {
        static final long serialVersionUID = 1L;
        public final IFunction1d function;

        public ConstProfileFunction(IFunction1d fund) {
            this.function = fund;
        }

        @Override
        public IFunction1d apply(OccProfile profile) {
            return this.function;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ConstProfileFunction && ((ConstProfileFunction)obj).function.equals(this.function);
        }

        public int hashCode() {
            return 0x1908F3E ^ this.function.hashCode();
        }

        @Override
        public String format() {
            return this.function.format(MerlinUtil.getDisplayUnitSupplier(new int[0]));
        }
    }

    private static class TagsTableCellEditor
    extends guiTable.ValidatedEditor<Set<String>> {
        private static final long serialVersionUID = 1L;

        public TagsTableCellEditor() {
            super(tags -> StringTagsUtil.format(tags), text -> StringTagsUtil.parse(text, false, false, Collections.emptySet()), Predicates.alwaysTrue(), false);
        }
    }

    public static class OccShape
    implements Serializable,
    ICyclicSurrogate {
        static final long serialVersionUID = 1L;
        public final VehicleShape vehicleShape;
        public final ICurve shoulderWidth;
        public final UnitDouble geomShoulderWidth;
        public final Double minSqueezeFactor;
        public final ICurve height;
        public final VehicleShape.ShapeType type;

        public OccShape(VehicleShape vehicleShape, ICurve shoulderWidth, UnitDouble geomShoulderWidth, ICurve height, Double minSqueezeFactor) {
            this.vehicleShape = vehicleShape;
            this.shoulderWidth = shoulderWidth;
            this.geomShoulderWidth = geomShoulderWidth;
            this.height = height;
            this.minSqueezeFactor = minSqueezeFactor;
            this.type = vehicleShape == null ? VehicleShape.ShapeType.CYLINDER : VehicleShape.ShapeType.POLYGON;
        }

        public OccShape modifyVehicleShape(VehicleShape vehicleShape) {
            ICurve shoulderWidth = this.shoulderWidth;
            if (vehicleShape == null && shoulderWidth == null) {
                shoulderWidth = (ICurve)OccProfile.PROP_DIAMETER.defVal;
            }
            return new OccShape(vehicleShape, shoulderWidth, this.geomShoulderWidth, this.height, this.minSqueezeFactor);
        }

        public int hashCode() {
            int hash = 1018420;
            switch (this.type) {
                case CYLINDER: {
                    hash += Objects.hash(this.shoulderWidth, this.geomShoulderWidth, this.height, this.minSqueezeFactor);
                    break;
                }
                case POLYGON: {
                    hash += Objects.hash(this.vehicleShape, this.minSqueezeFactor);
                }
            }
            return hash;
        }

        public boolean equals(Object other) {
            return this.equals(other, Objects::equals);
        }

        @Override
        public boolean cyclicEquals(Object other, HashSet<UnorderedPair<Object, Object>> comparedSet) {
            return this.equals(other, (o1, o2) -> theUtil.equal(o1, o2, comparedSet));
        }

        private boolean equals(Object other, BiPredicate<Object, Object> customEquals) {
            if (other == this) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            OccShape otherShape = (OccShape)other;
            if (this.type != otherShape.type) {
                return false;
            }
            if (!Objects.equals(this.minSqueezeFactor, otherShape.minSqueezeFactor)) {
                return false;
            }
            switch (this.type) {
                case CYLINDER: {
                    return this.shoulderWidth.equals(otherShape.shoulderWidth) && Objects.equals(this.geomShoulderWidth, otherShape.geomShoulderWidth) && this.height.equals(otherShape.height);
                }
                case POLYGON: {
                    return customEquals.test(this.vehicleShape, otherShape.vehicleShape);
                }
            }
            return false;
        }

        public UnitDouble getWidth() {
            if (this.type.equals(VehicleShape.ShapeType.CYLINDER)) {
                return this.shoulderWidth.getMax();
            }
            if (this.type.equals(VehicleShape.ShapeType.POLYGON)) {
                double w = VehicleBody.computeRadius(this.vehicleShape.get(VehicleShape.PROP_PIVOT), this.vehicleShape.getBodyPoints());
                return new UnitDouble(w, SI.METER);
            }
            return null;
        }

        public String format() {
            switch (this.type) {
                case CYLINDER: {
                    return String.format(Intl.intl("Cylinder: shoulder width = %s"), guiCurveUtil.format((IDistributedVal<UnitDouble>)this.shoulderWidth, 6));
                }
                case POLYGON: {
                    return String.format(Intl.intl("Polygon: %s"), this.vehicleShape.getName());
                }
            }
            assert (false);
            return Intl.intl("<none>");
        }

        public String toString() {
            return this.format();
        }

        public static DepCallback<MerlinData, IProfileObj, OccShape, VehicleShape> newVehicleDepCallback(ProfileProps.DistProp<OccShape, OccShape> prop) {
            return Dependencies.newDependency(prop, DLink.WEAK, VehicleShape.class, (md, src, oldShape) -> oldShape.vehicleShape != null ? Stream.of(oldShape.vehicleShape) : Stream.empty(), Predicates.alwaysTrue(), (md, src, oldShape, old, repl) -> {
                if (oldShape == null) {
                    assert (false) : String.format("Unexpected null VehicleShape from %s.", src.getName());
                    return null;
                }
                return oldShape.modifyVehicleShape((VehicleShape)repl);
            });
        }

        public void getErrors(MerlinData md, IMerlinObj owner, Consumer<? super SimError> errors) {
        }

        public OccShape toOccValue(OccProfile profile, long profSeed, long orientSeed) {
            UnitDouble shoulderWidth = profile.toOccValue(PROP_DIAMETER, profSeed, orientSeed);
            UnitDouble geomShoulderWidth = profile.get(PROP_GEOM_DIAMETER);
            UnitDouble height = profile.toOccValue(PROP_HEIGHT, profSeed, orientSeed);
            VehicleShape vehicleShape = profile.get(PROP_VEHICLE_SHAPE);
            Double minSqueezeFactor = profile.get(PROP_MIN_SQUEEZE_FACTOR_CONST);
            return new OccShape(vehicleShape, new ConstantCurve(shoulderWidth), geomShoulderWidth, new ConstantCurve(height), minSqueezeFactor);
        }
    }

    public static final class SpeedInSmokeConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final SpeedInSmoke.Mode mode;
        public final UnitDouble customFuncVisThreshold;
        public final SpeedInSmoke.FuncType customFuncVisType;
        public final IFunction1d customFuncVis;

        public SpeedInSmokeConfig(SpeedInSmoke.Mode mode, UnitDouble customFuncVisThreshold, SpeedInSmoke.FuncType customFuncVisType, IFunction1d customFuncVis) {
            this.mode = mode;
            this.customFuncVisThreshold = customFuncVisThreshold;
            this.customFuncVisType = customFuncVisType;
            this.customFuncVis = customFuncVis;
        }

        public SpeedInSmokeConfig(SpeedInSmoke.Data interop) {
            this.mode = interop.mode;
            this.customFuncVisThreshold = interop.customFuncVisThreshold;
            this.customFuncVisType = interop.customFuncVisType;
            this.customFuncVis = interop.customFuncVis != null ? PiecewiseFunction1d.newFunction(interop.customFuncVis) : null;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.customFuncVis, this.customFuncVisThreshold, this.customFuncVisType, this.mode});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SpeedInSmokeConfig other = (SpeedInSmokeConfig)obj;
            return Objects.equals(this.customFuncVis, other.customFuncVis) && Objects.equals(this.customFuncVisThreshold, other.customFuncVisThreshold) && this.customFuncVisType == other.customFuncVisType && this.mode == other.mode;
        }

        public String format() {
            return this.mode.name;
        }

        public String toString() {
            return "SpeedInSmokeConfig [mode=" + String.valueOf((Object)this.mode) + ", customFuncVisThreshold=" + String.valueOf(this.customFuncVisThreshold) + ", customFuncVisType=" + String.valueOf((Object)this.customFuncVisType) + ", customFuncVis=" + String.valueOf(this.customFuncVis) + "]";
        }
    }

    public static class ProfileStorage
    implements PropertyDefsFramework.IStorage<IProfileObj> {
        @Override
        public void initStorage(IProfileObj obj) {
            obj.initProfileValueStorage();
        }

        @Override
        public <T> boolean storeValue(IProfileObj obj, TypedProp<T> prop, T val, boolean serialized, boolean mutable) {
            return obj.storeProfileValue(prop, val, serialized, mutable);
        }

        @Override
        public <T> T retrieveValue(IProfileObj obj, TypedProp<T> prop, boolean serialized) {
            return obj.retrieveProfileValue(prop, serialized);
        }
    }

    public static class CompRestrictionsProp
    extends ProfileProps.UnaryProp<CompRestrictions> {
        private static final long serialVersionUID = 1L;

        public CompRestrictionsProp() {
            super(ProfileProps.Group.RESTRICTIONS, "OccProfile.RESTRICTED_COMPONENTS", (Object)null, CompRestrictions.class, new CompRestrictions(), true, Intl.intl("Component Restrictions"), Intl.intl("Controls which components the occupant is allowed to use."), (Object src, ? super T cr) -> cr.format(), (Mediator md, boolean inline) -> new CompRestrictionsEditor((MerlinData)md, new DefaultLabelGenerator()), null, Set.of(MerlinData.SCENARIO_MARKER), null);
        }
    }

    public static class SerializedProp
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Object key;

        public SerializedProp(Object key) {
            this.key = key;
        }

        private Object readResolve() throws ClassNotFoundException {
            TypedProp<?> gprop = ALL_PROPS.getProp(this.key);
            if (gprop == null) {
                assert (false);
                return this;
            }
            return gprop;
        }
    }
}

